/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFc1pSDK;
import com.appsflyer.internal.AFg1cSDK;
import com.appsflyer.internal.AFi1dSDK;
import com.appsflyer.internal.AFj1iSDK;
import com.appsflyer.internal.AFj1qSDK;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ExecutorService;

public class AFi1aSDK
extends AFi1dSDK {
    public final Map<String, Object> getMediationNetwork = new HashMap<String, Object>();
    @NonNull
    final ExecutorService getRevenue;

    public AFi1aSDK(@NonNull Runnable runnable, @NonNull ExecutorService executorService, @NonNull AFc1pSDK aFc1pSDK) {
        super("store", "google", aFc1pSDK, runnable);
        this.getRevenue = executorService;
    }

    private boolean getRevenue(@NonNull Context context) {
        if (!this.AFAdRevenueData()) {
            return false;
        }
        String string = "com.android.installreferrer.api.InstallReferrerClient";
        try {
            Class.forName(string);
            if (AFj1iSDK.AFAdRevenueData(context, "com.google.android.finsky.permission.BIND_GET_INSTALL_REFERRER_SERVICE")) {
                AFLogger.INSTANCE.d(AFg1cSDK.hashCode, "Install referrer is allowed");
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            AFLogger.afErrorLogForExcManagerOnly("InstallReferrerClient not found", classNotFoundException);
            AFLogger.INSTANCE.v(AFg1cSDK.hashCode, "Class " + string + " not found");
            return false;
        }
        catch (Throwable throwable) {
            AFLogger.INSTANCE.e(AFg1cSDK.hashCode, "An error occurred while trying to verify manifest : ".concat(String.valueOf(string)), throwable);
            return false;
        }
        AFLogger.INSTANCE.d(AFg1cSDK.hashCode, "Install referrer is not allowed");
        return false;
    }

    @Override
    public final void AFAdRevenueData(Context context) {
        if (!this.getRevenue(context)) {
            return;
        }
        AFi1aSDK aFi1aSDK = this;
        this.component4 = System.currentTimeMillis();
        aFi1aSDK.component2 = AFj1qSDK.AFa1ySDK.getMediationNetwork;
        aFi1aSDK.addObserver(new Observer(aFi1aSDK){
            private /* synthetic */ AFj1qSDK getMediationNetwork;
            {
                this.getMediationNetwork = aFj1qSDK;
            }

            public final void update(Observable o, Object arg) {
                this.getMediationNetwork.getCurrencyIso4217Code.run();
            }
        });
        try {
            aFi1aSDK = InstallReferrerClient.newBuilder((Context)context).build();
            AFLogger.INSTANCE.d(AFg1cSDK.hashCode, "Connecting to Install Referrer Library...");
            aFi1aSDK.startConnection(new InstallReferrerStateListener(){
                final /* synthetic */ InstallReferrerClient val$referrerClient;
                final /* synthetic */ Context val$context;
                {
                    this.val$referrerClient = installReferrerClient;
                    this.val$context = context;
                }

                public final void onInstallReferrerSetupFinished(int responseCode) {
                    AFi1aSDK.this.getRevenue.execute(() -> AFi1aSDK.this.getCurrencyIso4217Code(this.val$referrerClient, this.val$context, responseCode));
                }

                public final void onInstallReferrerServiceDisconnected() {
                    AFLogger.INSTANCE.d(AFg1cSDK.hashCode, "Install Referrer service disconnected");
                }
            });
            return;
        }
        catch (Throwable throwable) {
            AFLogger.INSTANCE.e(AFg1cSDK.hashCode, "referrerClient -> startConnection", throwable);
            return;
        }
    }

    @WorkerThread
    @VisibleForTesting
    protected final void getCurrencyIso4217Code(InstallReferrerClient installReferrerClient, Context referrerDetails, int n) {
        this.getMediationNetwork.put("code", String.valueOf(n));
        String string = "com.android.vending";
        referrerDetails = AFj1iSDK.getMonetizationNetwork((Context)referrerDetails, string);
        this.AFAdRevenueData.put("api_ver", referrerDetails.getFirst());
        this.AFAdRevenueData.put("api_ver_name", referrerDetails.getSecond());
        switch (n) {
            case 0: {
                this.AFAdRevenueData.put("response", "OK");
                try {
                    AFLogger.INSTANCE.d(AFg1cSDK.hashCode, "InstallReferrer connected");
                    if (installReferrerClient.isReady()) {
                        referrerDetails = installReferrerClient.getInstallReferrer();
                        Object object = referrerDetails.getInstallReferrer();
                        if (object != null) {
                            this.getMediationNetwork.put("val", object);
                            this.AFAdRevenueData.put("referrer", object);
                        }
                        long l = referrerDetails.getReferrerClickTimestampSeconds();
                        this.getMediationNetwork.put("clk", Long.toString(l));
                        this.AFAdRevenueData.put("click_ts", l);
                        long l2 = referrerDetails.getInstallBeginTimestampSeconds();
                        this.getMediationNetwork.put("install", Long.toString(l2));
                        this.AFAdRevenueData.put("install_begin_ts", l2);
                        object = new HashMap();
                        try {
                            boolean bl = referrerDetails.getGooglePlayInstantParam();
                            this.getMediationNetwork.put("instant", bl);
                            ((AbstractMap)object).put("instant", bl);
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            AFLogger.afErrorLogForExcManagerOnly("getGooglePlayInstantParam not exist", noSuchMethodError);
                        }
                        try {
                            ((AbstractMap)object).put("click_server_ts", referrerDetails.getReferrerClickTimestampServerSeconds());
                            ((AbstractMap)object).put("install_begin_server_ts", referrerDetails.getInstallBeginTimestampServerSeconds());
                            ((AbstractMap)object).put("install_version", referrerDetails.getInstallVersion());
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            AFLogger.INSTANCE.e(AFg1cSDK.hashCode, "some method not exist", noSuchMethodError, false, false);
                        }
                        if (!((AbstractMap)object).isEmpty()) {
                            this.AFAdRevenueData.put("google_custom", object);
                        }
                        installReferrerClient.endConnection();
                        break;
                    }
                    AFLogger.INSTANCE.w(AFg1cSDK.hashCode, "ReferrerClient: InstallReferrer is not ready");
                    this.getMediationNetwork.put("err", "ReferrerClient: InstallReferrer is not ready");
                }
                catch (Throwable throwable) {
                    AFLogger.INSTANCE.w(AFg1cSDK.hashCode, "Failed to get install referrer: " + throwable.getMessage());
                    this.getMediationNetwork.put("err", throwable.getMessage());
                    AFLogger.INSTANCE.e(AFg1cSDK.hashCode, "Failed to get install referrer", throwable, false, false);
                }
                break;
            }
            case 2: {
                AFLogger.INSTANCE.w(AFg1cSDK.hashCode, "InstallReferrer FEATURE_NOT_SUPPORTED");
                this.AFAdRevenueData.put("response", "FEATURE_NOT_SUPPORTED");
                break;
            }
            case 1: {
                this.AFAdRevenueData.put("response", "SERVICE_UNAVAILABLE");
                AFLogger.INSTANCE.w(AFg1cSDK.hashCode, "InstallReferrer not supported");
                break;
            }
            case 3: {
                AFLogger.INSTANCE.w(AFg1cSDK.hashCode, "InstallReferrer DEVELOPER_ERROR");
                this.AFAdRevenueData.put("response", "DEVELOPER_ERROR");
                break;
            }
            case -1: {
                AFLogger.INSTANCE.w(AFg1cSDK.hashCode, "InstallReferrer SERVICE_DISCONNECTED");
                this.AFAdRevenueData.put("response", "SERVICE_DISCONNECTED");
                break;
            }
            default: {
                AFLogger.INSTANCE.w(AFg1cSDK.hashCode, "responseCode not found.");
            }
        }
        AFLogger.INSTANCE.d(AFg1cSDK.hashCode, "Install Referrer collected locally");
        this.getMonetizationNetwork();
    }
}

