/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.appsflyer.AFLogger;
import com.appsflyer.attribution.AppsFlyerRequestListener;
import com.appsflyer.internal.AFa1tSDK;
import com.appsflyer.internal.AFc1dSDK;
import com.appsflyer.internal.AFc1pSDK;
import com.appsflyer.internal.AFc1qSDK;
import com.appsflyer.internal.AFd1aSDK;
import com.appsflyer.internal.AFd1nSDK;
import com.appsflyer.internal.AFd1oSDK;
import com.appsflyer.internal.AFe1dSDK;
import com.appsflyer.internal.AFe1mSDK;
import com.appsflyer.internal.AFe1nSDK;
import com.appsflyer.internal.AFe1oSDK;
import com.appsflyer.internal.AFe1rSDK;
import com.appsflyer.internal.AFe1sSDK;
import com.appsflyer.internal.AFg1nSDK;
import com.appsflyer.internal.AFh1vSDK;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONObject;

public final class AFg1pSDK
extends AFe1dSDK<Map<String, Object>> {
    private static final List<String> component4 = Arrays.asList("googleplay", "playstore", "googleplaystore");
    private final AFd1oSDK copy;
    private final AFc1qSDK equals;
    private final AFh1vSDK hashCode;
    private final AFc1pSDK toString;
    @Nullable
    private Map<String, Object> copydefault;
    @Nullable
    private String AFInAppEventType;

    public AFg1pSDK(@NonNull AFc1dSDK object) {
        super(AFe1mSDK.copy, new AFe1mSDK[]{AFe1mSDK.getCurrencyIso4217Code}, (AFc1dSDK)object, "GCD-FETCH");
        this.copy = object.getMediationNetwork();
        this.equals = object.component1();
        this.hashCode = object.areAllFieldsValid();
        this.toString = object.getMonetizationNetwork();
        AFe1mSDK aFe1mSDK = AFe1mSDK.getMonetizationNetwork;
        object = this;
        ((AFe1sSDK)object).AFAdRevenueData.add(aFe1mSDK);
        aFe1mSDK = AFe1mSDK.toString;
        object = this;
        ((AFe1sSDK)object).AFAdRevenueData.add(aFe1mSDK);
    }

    @Override
    public final void getMediationNetwork() {
        super.getMediationNetwork();
        Map<String, Object> map = this.copydefault;
        String string = this.AFInAppEventType;
        if (map != null) {
            AFg1nSDK.getMediationNetwork(map);
            return;
        }
        if (string != null && !string.isEmpty()) {
            AFg1nSDK.getMediationNetwork(string);
            return;
        }
        AFg1nSDK.getMediationNetwork("Unknown error");
    }

    @Override
    public final AFd1nSDK<Map<String, Object>> getCurrencyIso4217Code(@NonNull String object) {
        String string = AFa1tSDK.getRevenue(this.equals, this.toString.component2());
        String string2 = "";
        if (string != null && !string.trim().isEmpty()) {
            if (!component4.contains(string.toLowerCase(Locale.getDefault()))) {
                string2 = "-".concat(String.valueOf(string));
            } else {
                AFLogger.afWarnLog(String.format("[GCD] AF detected using redundant Google-Play channel for attribution - %s. Using without channel postfix.", string));
            }
        }
        object = this.copy.getCurrencyIso4217Code(string2, (String)object);
        AFLogger.afInfoLog("[GCD-B01] URL: " + ((AFd1nSDK)object).getCurrencyIso4217Code.AFAdRevenueData);
        return object;
    }

    @Override
    @NonNull
    public final AFe1rSDK getRevenue() throws Exception {
        if (this.component3.getRevenue()) {
            AFLogger.afDebugLog("[GCD-E03] 'isStopTracking' enabled");
            this.AFInAppEventType = "'isStopTracking' enabled";
            throw new AFe1oSDK();
        }
        Object object = AFe1rSDK.getMonetizationNetwork;
        for (int i = 0; i <= 2; ++i) {
            boolean bl = i >= 2;
            this.hashCode.copydefault = System.currentTimeMillis();
            try {
                boolean bl2;
                object = super.getRevenue();
                Object object2 = this;
                object2 = ((AFe1dSDK)object2).component2;
                if (object2 == null) continue;
                int n = ((AFd1aSDK)object2).getStatusCode();
                boolean bl3 = bl2 = n == 403 || n >= 500;
                if (((AFd1aSDK)object2).isSuccessful() || n == 404) {
                    object = this;
                    Map map = (Map)((AFd1aSDK)object2).getBody();
                    int n2 = ((AFd1aSDK)object2).getStatusCode();
                    Boolean bl4 = (Boolean)map.get("iscache");
                    if (n2 == 404) {
                        map.remove("error_reason");
                        map.remove("status_code");
                        map.put("af_status", "Organic");
                        map.put("af_message", "organic install");
                    }
                    if (bl4 != null && !bl4.booleanValue()) {
                        ((AFg1pSDK)object).equals.getRevenue("appsflyerConversionDataCacheExpiration", System.currentTimeMillis());
                    }
                    if (map.containsKey("af_siteid")) {
                        if (map.containsKey("af_channel")) {
                            AFLogger.afDebugLog("[Invite] Detected App-Invite via channel: " + map.get("af_channel"));
                        } else {
                            AFLogger.afDebugLog(String.format("[CrossPromotion] App was installed via %s's Cross Promotion", map.get("af_siteid")));
                        }
                    }
                    map.put("is_first_launch", Boolean.FALSE);
                    String string = new JSONObject(map).toString();
                    ((AFg1pSDK)object).equals.getCurrencyIso4217Code("attributionId", string);
                    object = map;
                    if (!this.equals.getMonetizationNetwork("sixtyDayConversionData", false)) {
                        object.put("is_first_launch", Boolean.TRUE);
                    }
                    this.copydefault = object;
                    object = AFe1rSDK.getRevenue;
                    return object;
                }
                if (!bl && bl2) continue;
                this.AFInAppEventType = "Error connection to server: ".concat(String.valueOf(n));
                object = AFe1rSDK.getMonetizationNetwork;
                return object;
            }
            catch (AFe1nSDK aFe1nSDK) {
                AFLogger.afDebugLog("[GCD-E05] AppsFlyer dev key is missing");
                this.AFInAppEventType = "AppsFlyer dev key is missing";
                throw aFe1nSDK;
            }
            catch (Exception exception) {
                AFLogger.afErrorLog("[GCD] Error: " + exception.getMessage(), exception, false, false);
                object = AFe1rSDK.getMonetizationNetwork;
                if (!bl) continue;
                this.AFInAppEventType = exception.getMessage();
                throw exception;
            }
            finally {
                this.hashCode.AFAdRevenueData(i);
                AFLogger.afDebugLog("[GCD-A03] Server retrieving attempt finished");
            }
        }
        return object;
    }

    @Override
    @Nullable
    public final AppsFlyerRequestListener component3() {
        return null;
    }

    @Override
    public final boolean copydefault() {
        return false;
    }

    @Override
    public final boolean getCurrencyIso4217Code() {
        return false;
    }
}

