/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFb1iSDK;
import com.appsflyer.internal.AFd1qSDK;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONObject;

public final class AFb1jSDK {
    public static String getMonetizationNetwork(String string) {
        String string2 = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(string.getBytes(Charset.defaultCharset()));
            string2 = AFb1jSDK.AFAdRevenueData(messageDigest.digest());
        }
        catch (Exception exception) {
            AFLogger.afErrorLog("Error turning data to SHA-256 string", exception);
        }
        return string2;
    }

    private static String AFAdRevenueData(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            stringBuilder.append(Integer.toString((by & 0xFF) + 256, 16).substring(1));
        }
        return ((Object)stringBuilder).toString();
    }

    public static long getRevenue(@NonNull String object) {
        object = AFb1jSDK.getMediationNetwork((String)object);
        long l = -1L;
        if (object != null && ((Object)object).length > 0) {
            if (((Object)object).length > 8) {
                object = Arrays.copyOfRange((byte[])object, 0, 8);
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate(8);
            byteBuffer.put((byte[])object);
            byteBuffer.flip();
            l = byteBuffer.getLong();
        }
        return l;
    }

    @Nullable
    private static byte[] getMediationNetwork(@NonNull String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(string.getBytes(Charset.defaultCharset()));
            return messageDigest.digest();
        }
        catch (Exception exception) {
            AFLogger.afErrorLog("Error turning string to SHA-256 byte array", exception);
            return null;
        }
    }

    public static String getMonetizationNetwork(String string, String string2) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(string2.getBytes(Charset.defaultCharset()), "HmacSHA256"));
            return AFb1jSDK.AFAdRevenueData(mac.doFinal(string.getBytes(Charset.defaultCharset()))).toLowerCase(Locale.getDefault());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException generalSecurityException) {
            GeneralSecurityException generalSecurityException2 = generalSecurityException;
            AFLogger.afErrorLog(generalSecurityException.getMessage(), generalSecurityException2, true);
            return generalSecurityException2.getMessage();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean getMediationNetwork(Map<String, Object> object, String[] object2, AFd1qSDK aFd1qSDK) throws IllegalStateException {
        void var2_3;
        Object object32;
        if (object == null || object.isEmpty()) {
            return false;
        }
        for (Object object32 : object2) {
            if (object.containsKey(object32)) continue;
            return false;
        }
        String string = (String)object.remove("sig");
        if (string == null) {
            return false;
        }
        String string2 = AFd1qSDK.areAllFieldsValid();
        String string3 = new JSONObject((Map)object) + string2;
        object = var2_3;
        object32 = AFb1iSDK.getCurrencyIso4217Code(((AFd1qSDK)object).getMonetizationNetwork, ((AFd1qSDK)object).getRevenue);
        return AFb1jSDK.getMonetizationNetwork(string3, (String)object32).equals(string);
    }
}

