/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.annotation.SuppressLint;
import android.content.ContentProviderClient;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFb1qSDK;
import com.appsflyer.internal.AFd1rSDK;
import com.appsflyer.internal.AFh1wSDK;
import com.appsflyer.internal.AFh1xSDK;
import com.appsflyer.internal.AFi1bSDK;
import com.appsflyer.internal.AFj1qSDK;
import com.appsflyer.internal.AFj1ySDK;
import com.appsflyer.internal.AFj1zSDK;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ExecutorService;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nMetaReferrer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetaReferrer.kt\ncom/appsflyer/internal/referrer/MetaReferrer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,295:1\n1#2:296\n*E\n"})
public final class AFj1vSDK
extends AFi1bSDK {
    @NotNull
    private final AFd1rSDK getCurrencyIso4217Code;
    @NotNull
    private final ExecutorService getMediationNetwork;
    @NotNull
    private final AFj1ySDK getMonetizationNetwork;
    @NotNull
    private final Runnable areAllFieldsValid;
    @Nullable
    private String toString;

    public AFj1vSDK(@NotNull AFd1rSDK aFd1rSDK, @NotNull ExecutorService executorService, @NotNull AFj1ySDK aFj1ySDK, @NotNull Runnable runnable, @NotNull Runnable runnable2) {
        Intrinsics.checkNotNullParameter((Object)aFd1rSDK, (String)"");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)aFj1ySDK), (String)"");
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"");
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"");
        super("app", switch (AFj1zSDK.AFa1uSDK.getRevenue[aFj1ySDK.ordinal()]) {
            case 1 -> "facebook";
            case 2 -> "instagram";
            case 3 -> "facebook_lite";
            default -> throw new NoWhenBranchMatchedException();
        }, aFd1rSDK, runnable);
        this.getCurrencyIso4217Code = aFd1rSDK;
        this.getMediationNetwork = executorService;
        this.getMonetizationNetwork = aFj1ySDK;
        this.areAllFieldsValid = runnable2;
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public final void getMonetizationNetwork(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"");
        if (!this.getMediationNetwork(context)) {
            this.areAllFieldsValid.run();
            return;
        }
        this.getMediationNetwork.execute(() -> AFj1vSDK.getRevenue(this, context));
    }

    private final boolean getMediationNetwork(Context context) {
        String string;
        String string2;
        if (!this.AFAdRevenueData()) {
            AFh1wSDK.d$default(AFLogger.INSTANCE, AFh1xSDK.toString, "Referrer collection disallowed by counter.", false, 4, null);
            return false;
        }
        AFj1vSDK aFj1vSDK = this;
        String string3 = aFj1vSDK.getCurrencyIso4217Code.getMonetizationNetwork("com.facebook.sdk.ApplicationId");
        String string4 = string3 != null ? StringsKt.removePrefix((String)string3, (CharSequence)"fb") : null;
        CharSequence charSequence = string4;
        if (charSequence == null || charSequence.length() == 0) {
            AFh1wSDK.d$default(AFLogger.INSTANCE, AFh1xSDK.toString, "Facebook app id Manifest metadata is not found.", false, 4, null);
            string2 = null;
        } else {
            string2 = string = string4;
        }
        if (string2 == null) {
            String string5;
            String string6 = aFj1vSDK.getCurrencyIso4217Code.AFAdRevenueData("facebook_application_id");
            string4 = string6 != null ? StringsKt.removePrefix((String)string6, (CharSequence)"fb") : null;
            charSequence = string4;
            if (charSequence == null || charSequence.length() == 0) {
                AFh1wSDK.d$default(AFLogger.INSTANCE, AFh1xSDK.toString, "Facebook app id string resource is not found.", false, 4, null);
                string5 = null;
            } else {
                string5 = string = string4;
            }
            if (string5 == null) {
                String string7;
                String string8 = aFj1vSDK.getCurrencyIso4217Code.getMonetizationNetwork("com.appsflyer.FacebookApplicationId");
                string4 = string8 != null ? StringsKt.removePrefix((String)string8, (CharSequence)"fb") : null;
                charSequence = string4;
                if (charSequence == null || charSequence.length() == 0) {
                    AFh1wSDK.d$default(AFLogger.INSTANCE, AFh1xSDK.toString, "AF Facebook app id Manifest metadata is not found.", false, 4, null);
                    string7 = null;
                } else {
                    string7 = string = string4;
                }
                if (string7 == null) {
                    string = aFj1vSDK.toString = null;
                }
            }
        }
        if (this.toString == null) {
            AFh1wSDK.d$default(AFLogger.INSTANCE, AFh1xSDK.toString, "Referrer collection disallowed by missing Facebook app id.", false, 4, null);
            return false;
        }
        if (!this.getRevenue(context)) {
            AFh1wSDK.d$default(AFLogger.INSTANCE, AFh1xSDK.toString, "Referrer collection disallowed by missing content providers.", false, 4, null);
            return false;
        }
        return true;
    }

    private final boolean getRevenue(Context context) {
        switch (AFa1zSDK.AFAdRevenueData[this.getMonetizationNetwork.ordinal()]) {
            case 1: {
                return AFj1vSDK.getCurrencyIso4217Code(context);
            }
            case 2: {
                return AFj1vSDK.AFAdRevenueData(context);
            }
            case 3: {
                return AFj1vSDK.areAllFieldsValid(context);
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private static boolean getCurrencyIso4217Code(Context context) {
        return context.getPackageManager().resolveContentProvider("com.facebook.katana.provider.InstallReferrerProvider", 0) != null;
    }

    private static boolean AFAdRevenueData(Context context) {
        return context.getPackageManager().resolveContentProvider("com.instagram.contentprovider.InstallReferrerProvider", 0) != null;
    }

    private static boolean areAllFieldsValid(Context context) {
        return context.getPackageManager().resolveContentProvider("com.facebook.lite.provider.InstallReferrerProvider", 0) != null;
    }

    private static final void getRevenue(AFj1vSDK aFj1vSDK, Context object) {
        block37: {
            ContentProviderClient contentProviderClient;
            Cursor cursor;
            block39: {
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                block38: {
                    Intrinsics.checkNotNullParameter((Object)aFj1vSDK, (String)"");
                    Intrinsics.checkNotNullParameter((Object)object, (String)"");
                    object5 = aFj1vSDK;
                    aFj1vSDK.component4 = System.currentTimeMillis();
                    ((AFj1qSDK)object5).component2 = AFj1qSDK.AFa1vSDK.getRevenue;
                    ((Observable)object5).addObserver(new Observer((AFj1qSDK)object5){
                        private /* synthetic */ AFj1qSDK getMediationNetwork;
                        {
                            this.getMediationNetwork = aFj1qSDK;
                        }

                        public final void update(Observable o, Object arg) {
                            this.getMediationNetwork.getRevenue.run();
                        }
                    });
                    Intrinsics.checkNotNull((Object)aFj1vSDK.toString);
                    object4 = aFj1vSDK.toString;
                    object5 = object;
                    object = aFj1vSDK;
                    cursor = null;
                    contentProviderClient = null;
                    object3 = object5;
                    Pair[] pairArray = object4;
                    object2 = object.getMonetizationNetwork;
                    Uri uri = switch (AFa1zSDK.AFAdRevenueData[((Enum)object2).ordinal()]) {
                        case 1 -> {
                            if (AFj1vSDK.getCurrencyIso4217Code((Context)object3)) {
                                AFh1wSDK.d$default(AFLogger.INSTANCE, AFh1xSDK.toString, "Found Facebook content provider", false, 4, null);
                                yield Uri.parse((String)("content://com.facebook.katana.provider.InstallReferrerProvider/" + (String)pairArray));
                            }
                            AFh1wSDK.d$default(AFLogger.INSTANCE, AFh1xSDK.toString, "Facebook content provider not found", false, 4, null);
                            yield null;
                        }
                        case 2 -> {
                            if (AFj1vSDK.AFAdRevenueData((Context)object3)) {
                                AFh1wSDK.d$default(AFLogger.INSTANCE, AFh1xSDK.toString, "Found Instagram content provider", false, 4, null);
                                yield Uri.parse((String)("content://com.instagram.contentprovider.InstallReferrerProvider/" + (String)pairArray));
                            }
                            AFh1wSDK.d$default(AFLogger.INSTANCE, AFh1xSDK.toString, "Instagram content provider not found", false, 4, null);
                            yield null;
                        }
                        case 3 -> {
                            if (AFj1vSDK.areAllFieldsValid((Context)object3)) {
                                AFh1wSDK.d$default(AFLogger.INSTANCE, AFh1xSDK.toString, "Found Facebook Lite content provider", false, 4, null);
                                yield Uri.parse((String)("content://com.facebook.lite.provider.InstallReferrerProvider/" + (String)pairArray));
                            }
                            AFh1wSDK.d$default(AFLogger.INSTANCE, AFh1xSDK.toString, "Facebook Lite content provider not found", false, 4, null);
                            yield null;
                        }
                        default -> throw new NoWhenBranchMatchedException();
                    };
                    if (uri == null) break block37;
                    object4 = uri;
                    contentProviderClient = object5.getContentResolver().acquireUnstableContentProviderClient((Uri)object4);
                    Cursor cursor2 = new String[3];
                    object2 = cursor2;
                    cursor2[0] = "install_referrer";
                    object2[1] = "is_ct";
                    object2[2] = "actual_timestamp";
                    ContentProviderClient contentProviderClient2 = contentProviderClient;
                    cursor = contentProviderClient2 != null ? contentProviderClient2.query((Uri)object4, (String[])object2, null, null, null) : null;
                    if (cursor != null && cursor.moveToFirst()) break block38;
                    AFh1wSDK.d$default(AFLogger.INSTANCE, AFh1xSDK.toString, "Content provider returned no data", false, 4, null);
                    Cursor cursor3 = cursor;
                    if (cursor3 != null) {
                        cursor3.close();
                    }
                    if (Build.VERSION.SDK_INT >= 24) {
                        ContentProviderClient contentProviderClient3 = contentProviderClient;
                        if (contentProviderClient3 != null) {
                            contentProviderClient3.close();
                        }
                    } else {
                        ContentProviderClient contentProviderClient4 = contentProviderClient;
                        if (contentProviderClient4 != null) {
                            contentProviderClient4.release();
                        }
                    }
                    break block37;
                }
                try {
                    String string;
                    object2 = cursor;
                    object4 = object;
                    int n = object2.getColumnIndex("install_referrer");
                    if (n != -1) {
                        string = object2.getString(n);
                    } else {
                        AFh1wSDK.d$default(AFLogger.INSTANCE, AFh1xSDK.toString, "No such column, " + object4.getMonetizationNetwork + " provider", false, 4, null);
                        string = null;
                    }
                    if (string == null) break block39;
                    object4 = string;
                    AFh1wSDK.d$default(AFLogger.INSTANCE, AFh1xSDK.toString, "Collected " + object.getMonetizationNetwork + " attribution data.", false, 4, null);
                    Map<String, Object> map = object.AFAdRevenueData;
                    Intrinsics.checkNotNullExpressionValue(map, (String)"");
                    object2 = map;
                    String string2 = "response";
                    object3 = "OK";
                    object2.put(string2, object3);
                    Map<String, Object> map2 = object.AFAdRevenueData;
                    Intrinsics.checkNotNullExpressionValue(map2, (String)"");
                    map2.put("referrer", object4);
                    object4 = cursor;
                    int n2 = object4.getColumnIndex("actual_timestamp");
                    Long l = n2 != -1 ? Long.valueOf(object4.getLong(n2)) : null;
                    if (l != null) {
                        long l2 = ((Number)l).longValue();
                        object.AFAdRevenueData.put("click_ts", l2);
                    }
                    object4 = cursor;
                    n2 = object4.getColumnIndex("is_ct");
                    Integer n3 = n2 != -1 ? Integer.valueOf(object4.getInt(n2)) : null;
                    if (n3 != null) {
                        int n4 = ((Number)n3).intValue();
                        Pair[] pairArray = new Pair[1];
                        object4 = pairArray;
                        pairArray[0] = TuplesKt.to((Object)"is_ct", (Object)n4);
                        object4 = MapsKt.mutableMapOf((Pair[])object4);
                        object.AFAdRevenueData.put("meta_custom", object4);
                    }
                    object2 = object5;
                    object4 = object;
                    String string3 = switch (AFa1zSDK.AFAdRevenueData[object4.getMonetizationNetwork.ordinal()]) {
                        case 1 -> "com.facebook.katana";
                        case 2 -> "com.instagram.android";
                        case 3 -> "com.facebook.lite";
                        default -> throw new NoWhenBranchMatchedException();
                    };
                    Map<String, Object> map3 = object4.AFAdRevenueData;
                    Intrinsics.checkNotNullExpressionValue(map3, (String)"");
                    Map<String, Object> map4 = map3;
                    object5 = "api_ver";
                    Object object6 = AFb1qSDK.AFAdRevenueData((Context)object2, string3);
                    map4.put((String)object5, object6);
                    Map<String, Object> map5 = object4.AFAdRevenueData;
                    Intrinsics.checkNotNullExpressionValue(map5, (String)"");
                    map4 = map5;
                    object5 = "api_ver_name";
                    object6 = AFb1qSDK.getMediationNetwork((Context)object2, string3);
                    map4.put((String)object5, object6);
                }
                catch (Throwable throwable) {
                    try {
                        AFh1wSDK.e$default(AFLogger.INSTANCE, AFh1xSDK.toString, "Error while collecting Meta Install Referrer for " + object.getMonetizationNetwork.name() + " provider", throwable, false, false, false, false, 120, null);
                        break block37;
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                    finally {
                        Cursor cursor4 = cursor;
                        if (cursor4 != null) {
                            cursor4.close();
                        }
                        if (Build.VERSION.SDK_INT >= 24) {
                            ContentProviderClient contentProviderClient5 = contentProviderClient;
                            if (contentProviderClient5 != null) {
                                contentProviderClient5.close();
                            }
                        } else {
                            ContentProviderClient contentProviderClient6 = contentProviderClient;
                            if (contentProviderClient6 != null) {
                                contentProviderClient6.release();
                            }
                        }
                    }
                }
            }
            cursor.close();
            if (Build.VERSION.SDK_INT >= 24) {
                ContentProviderClient contentProviderClient7 = contentProviderClient;
                if (contentProviderClient7 != null) {
                    contentProviderClient7.close();
                }
            } else {
                ContentProviderClient contentProviderClient8 = contentProviderClient;
                if (contentProviderClient8 != null) {
                    contentProviderClient8.release();
                }
            }
        }
        aFj1vSDK.getRevenue();
        aFj1vSDK.areAllFieldsValid.run();
    }

    public final class AFa1zSDK {
        public static final /* synthetic */ int[] AFAdRevenueData;

        static {
            int[] nArray = new int[AFj1ySDK.values().length];
            try {
                nArray[AFj1ySDK.AFAdRevenueData.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[AFj1ySDK.getRevenue.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[AFj1ySDK.getMediationNetwork.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            AFAdRevenueData = nArray;
        }
    }
}

