/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFi1rSDK;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nNetworkDataCollectorApiPre21.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkDataCollectorApiPre21.kt\ncom/appsflyer/internal/network/NetworkDataCollectorApiPre21\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,43:1\n1747#2,3:44\n*S KotlinDebug\n*F\n+ 1 NetworkDataCollectorApiPre21.kt\ncom/appsflyer/internal/network/NetworkDataCollectorApiPre21\n*L\n36#1:44,3\n*E\n"})
public final class AFi1kSDK
extends AFi1rSDK {
    public AFi1kSDK(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"");
        super(context);
    }

    @Override
    @NotNull
    protected final String getMonetizationNetwork() {
        AFi1kSDK aFi1kSDK = this;
        ConnectivityManager connectivityManager = aFi1kSDK.getCurrencyIso4217Code;
        if (connectivityManager != null) {
            aFi1kSDK = connectivityManager;
            if (AFi1kSDK.v_(connectivityManager.getNetworkInfo(1))) {
                return "WIFI";
            }
            if (AFi1kSDK.v_(aFi1kSDK.getNetworkInfo(0))) {
                return "MOBILE";
            }
            NetworkInfo networkInfo = aFi1kSDK.getActiveNetworkInfo();
            if (networkInfo != null) {
                switch (networkInfo.getType()) {
                    case 1: {
                        return "WIFI";
                    }
                    case 0: {
                        return "MOBILE";
                    }
                }
                return "unknown";
            }
            return "unknown";
        }
        return "unknown";
    }

    @Override
    public final boolean getRevenue() {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"");
            ArrayList<NetworkInterface> arrayList = Collections.list(enumeration);
            Intrinsics.checkNotNullExpressionValue(arrayList, (String)"");
            Object object = arrayList;
            if (!(object instanceof Collection) || !((Collection)object).isEmpty()) {
                object = object.iterator();
                while (object.hasNext()) {
                    NetworkInterface networkInterface = (NetworkInterface)object.next();
                    if (!(networkInterface.isUp() && Intrinsics.areEqual((Object)networkInterface.getName(), (Object)"tun0"))) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception exception) {
            AFLogger.afErrorLog("Failed collecting ivc data", exception);
            return false;
        }
    }
}

