/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFd1lSDK;
import com.appsflyer.internal.AFd1rSDK;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AFg1nSDK {
    @NotNull
    private final Map<String, Object> getMediationNetwork;
    @Nullable
    private final PackageManager getCurrencyIso4217Code;
    @NotNull
    private final String getRevenue;

    public AFg1nSDK(@NotNull AFd1lSDK aFd1lSDK, @NotNull AFd1rSDK aFd1rSDK) {
        Intrinsics.checkNotNullParameter((Object)aFd1lSDK, (String)"");
        Intrinsics.checkNotNullParameter((Object)aFd1rSDK, (String)"");
        this.getMediationNetwork = new LinkedHashMap();
        Context context = aFd1lSDK.getCurrencyIso4217Code;
        this.getCurrencyIso4217Code = context != null ? context.getPackageManager() : null;
        String string = aFd1rSDK.getMonetizationNetwork.getCurrencyIso4217Code.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        this.getRevenue = string;
    }

    @NotNull
    public final Map<String, Object> getCurrencyIso4217Code() {
        if (this.getMediationNetwork.isEmpty()) {
            Object object;
            try {
                Object object2 = this.getCurrencyIso4217Code;
                if (object2 != null && (object2 = object2.getInstallerPackageName(this.getRevenue)) != null) {
                    object = object2;
                    this.getMediationNetwork.put("installer_package", object);
                }
            }
            catch (Exception exception) {
                AFLogger.afErrorLog("Exception while getting the app's installer package. ", exception);
            }
            if (Build.VERSION.SDK_INT >= 30) {
                object = this;
                Map map = new LinkedHashMap();
                Object object3 = object.getRevenue;
                PackageManager packageManager = object.getCurrencyIso4217Code;
                if (packageManager != null && (packageManager = packageManager.getInstallSourceInfo((String)object3)) != null) {
                    map = packageManager;
                    Intrinsics.checkNotNullExpressionValue((Object)packageManager, (String)"");
                    object = new LinkedHashMap();
                    String string = map.getInitiatingPackageName();
                    String string2 = "initiating_package";
                    object3 = object;
                    if (string != null) {
                        object3.put(string2, string);
                    }
                    string = map.getInstallingPackageName();
                    string2 = "installing_package";
                    object3 = object;
                    if (string != null) {
                        object3.put(string2, string);
                    }
                    string = map.getOriginatingPackageName();
                    string2 = "originating_package";
                    object3 = object;
                    if (string != null) {
                        object3.put(string2, string);
                    }
                    map = object;
                }
                this.getMediationNetwork.put("install_source_info", map);
            }
        }
        return this.getMediationNetwork;
    }
}

