/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFb1vSDK;
import com.appsflyer.internal.AFd1pSDK;
import com.appsflyer.internal.AFg1cSDK;
import com.appsflyer.internal.AFi1hSDK;
import com.appsflyer.internal.AFj1zSDK;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ExecutorService;

public class AFi1gSDK
extends AFi1hSDK {
    public final Map<String, Object> getCurrencyIso4217Code = new HashMap<String, Object>();
    @NonNull
    private final ExecutorService AFAdRevenueData;

    public AFi1gSDK(@NonNull Runnable runnable, @NonNull ExecutorService executorService, @NonNull AFd1pSDK aFd1pSDK) {
        super("store", "google", aFd1pSDK, runnable);
        this.AFAdRevenueData = executorService;
    }

    private boolean AFAdRevenueData(@NonNull Context context) {
        if (!this.getMonetizationNetwork()) {
            return false;
        }
        String string = "com.android.installreferrer.api.InstallReferrerClient";
        try {
            Class.forName(string);
            if (AFb1vSDK.getCurrencyIso4217Code(context, "com.google.android.finsky.permission.BIND_GET_INSTALL_REFERRER_SERVICE")) {
                AFLogger.INSTANCE.d(AFg1cSDK.toString, "Install referrer is allowed");
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            AFLogger.afErrorLogForExcManagerOnly("InstallReferrerClient not found", classNotFoundException);
            AFLogger.INSTANCE.v(AFg1cSDK.toString, "Class " + string + " not found");
            return false;
        }
        catch (Throwable throwable) {
            AFLogger.INSTANCE.e(AFg1cSDK.toString, "An error occurred while trying to verify manifest : ".concat(String.valueOf(string)), throwable);
            return false;
        }
        AFLogger.INSTANCE.d(AFg1cSDK.toString, "Install referrer is not allowed");
        return false;
    }

    @Override
    public final void getMonetizationNetwork(Context context) {
        if (!this.AFAdRevenueData(context)) {
            return;
        }
        AFi1gSDK aFi1gSDK = this;
        this.component4 = System.currentTimeMillis();
        aFi1gSDK.component3 = AFj1zSDK.AFa1zSDK.AFAdRevenueData;
        aFi1gSDK.addObserver(new Observer(aFi1gSDK){
            private /* synthetic */ AFj1zSDK AFAdRevenueData;
            {
                this.AFAdRevenueData = aFj1zSDK;
            }

            public final void update(Observable o, Object arg) {
                this.AFAdRevenueData.getRevenue.run();
            }
        });
        try {
            aFi1gSDK = InstallReferrerClient.newBuilder((Context)context).build();
            AFLogger.INSTANCE.d(AFg1cSDK.toString, "Connecting to Install Referrer Library...");
            aFi1gSDK.startConnection(new InstallReferrerStateListener((InstallReferrerClient)aFi1gSDK, context){
                final /* synthetic */ InstallReferrerClient val$referrerClient;
                final /* synthetic */ Context val$context;
                {
                    this.val$referrerClient = installReferrerClient;
                    this.val$context = context;
                }

                public final void onInstallReferrerSetupFinished(int responseCode) {
                    AFi1gSDK.this.AFAdRevenueData.execute(() -> AFi1gSDK.this.AFAdRevenueData(this.val$referrerClient, this.val$context, responseCode));
                }

                public final void onInstallReferrerServiceDisconnected() {
                    AFLogger.INSTANCE.d(AFg1cSDK.toString, "Install Referrer service disconnected");
                }
            });
            return;
        }
        catch (Throwable throwable) {
            AFLogger.INSTANCE.e(AFg1cSDK.toString, "referrerClient -> startConnection", throwable);
            return;
        }
    }

    @WorkerThread
    @VisibleForTesting
    protected final void AFAdRevenueData(InstallReferrerClient installReferrerClient, Context context, int n) {
        this.getCurrencyIso4217Code.put("code", String.valueOf(n));
        String string = "com.android.vending";
        this.getMediationNetwork.put("api_ver", AFb1vSDK.getRevenue(context, string));
        this.getMediationNetwork.put("api_ver_name", AFb1vSDK.getMonetizationNetwork(context, string));
        switch (n) {
            case 0: {
                this.getMediationNetwork.put("response", "OK");
                try {
                    AFLogger.INSTANCE.d(AFg1cSDK.toString, "InstallReferrer connected");
                    if (installReferrerClient.isReady()) {
                        context = installReferrerClient.getInstallReferrer();
                        Object object = context.getInstallReferrer();
                        if (object != null) {
                            this.getCurrencyIso4217Code.put("val", object);
                            this.getMediationNetwork.put("referrer", object);
                        }
                        long l = context.getReferrerClickTimestampSeconds();
                        this.getCurrencyIso4217Code.put("clk", Long.toString(l));
                        this.getMediationNetwork.put("click_ts", l);
                        long l2 = context.getInstallBeginTimestampSeconds();
                        this.getCurrencyIso4217Code.put("install", Long.toString(l2));
                        this.getMediationNetwork.put("install_begin_ts", l2);
                        object = new HashMap();
                        try {
                            boolean bl = context.getGooglePlayInstantParam();
                            this.getCurrencyIso4217Code.put("instant", bl);
                            ((AbstractMap)object).put("instant", bl);
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            AFLogger.afErrorLogForExcManagerOnly("getGooglePlayInstantParam not exist", noSuchMethodError);
                        }
                        try {
                            ((AbstractMap)object).put("click_server_ts", context.getReferrerClickTimestampServerSeconds());
                            ((AbstractMap)object).put("install_begin_server_ts", context.getInstallBeginTimestampServerSeconds());
                            ((AbstractMap)object).put("install_version", context.getInstallVersion());
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            AFLogger.INSTANCE.e(AFg1cSDK.toString, "some method not exist", noSuchMethodError, false, false);
                        }
                        if (!((AbstractMap)object).isEmpty()) {
                            this.getMediationNetwork.put("google_custom", object);
                        }
                        installReferrerClient.endConnection();
                        break;
                    }
                    AFLogger.INSTANCE.w(AFg1cSDK.toString, "ReferrerClient: InstallReferrer is not ready");
                    this.getCurrencyIso4217Code.put("err", "ReferrerClient: InstallReferrer is not ready");
                }
                catch (Throwable throwable) {
                    AFLogger.INSTANCE.w(AFg1cSDK.toString, "Failed to get install referrer: " + throwable.getMessage());
                    this.getCurrencyIso4217Code.put("err", throwable.getMessage());
                    AFLogger.INSTANCE.e(AFg1cSDK.toString, "Failed to get install referrer", throwable, false, false);
                }
                break;
            }
            case 2: {
                AFLogger.INSTANCE.w(AFg1cSDK.toString, "InstallReferrer FEATURE_NOT_SUPPORTED");
                this.getMediationNetwork.put("response", "FEATURE_NOT_SUPPORTED");
                break;
            }
            case 1: {
                this.getMediationNetwork.put("response", "SERVICE_UNAVAILABLE");
                AFLogger.INSTANCE.w(AFg1cSDK.toString, "InstallReferrer not supported");
                break;
            }
            case 3: {
                AFLogger.INSTANCE.w(AFg1cSDK.toString, "InstallReferrer DEVELOPER_ERROR");
                this.getMediationNetwork.put("response", "DEVELOPER_ERROR");
                break;
            }
            case -1: {
                AFLogger.INSTANCE.w(AFg1cSDK.toString, "InstallReferrer SERVICE_DISCONNECTED");
                this.getMediationNetwork.put("response", "SERVICE_DISCONNECTED");
                break;
            }
            default: {
                AFLogger.INSTANCE.w(AFg1cSDK.toString, "responseCode not found.");
            }
        }
        AFLogger.INSTANCE.d(AFg1cSDK.toString, "Install Referrer collected locally");
        this.AFAdRevenueData();
    }
}

