/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import android.graphics.Color;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.view.ViewConfiguration;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.appsflyer.AFLogger;
import com.appsflyer.AppsFlyerProperties;
import com.appsflyer.internal.AFb1tSDK;
import com.appsflyer.internal.AFc1gSDK;
import com.appsflyer.internal.AFc1tSDK;
import com.appsflyer.internal.AFd1kSDK;
import com.appsflyer.internal.AFd1rSDK;
import com.appsflyer.internal.AFg1sSDK;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public final class AFg1rSDK {
    @NonNull
    public final AFd1kSDK getRevenue;
    @NonNull
    public final AFg1sSDK getMediationNetwork;
    Map<String, Object> AFAdRevenueData;
    public boolean getMonetizationNetwork = false;
    public long getCurrencyIso4217Code;
    public volatile String component1;
    public volatile boolean component4 = false;
    @Nullable
    public volatile String areAllFieldsValid;

    public AFg1rSDK(@NonNull AFd1kSDK aFd1kSDK, @NonNull AFg1sSDK aFg1sSDK) {
        this.getRevenue = aFd1kSDK;
        this.getMediationNetwork = aFg1sSDK;
    }

    public final boolean getMonetizationNetwork() {
        return this.component4;
    }

    @Nullable
    public final String AFAdRevenueData(AFd1rSDK aFd1rSDK) {
        boolean bl = AppsFlyerProperties.getInstance().getBoolean("collectIMEI", false);
        String string = aFd1rSDK.getCurrencyIso4217Code("imeiCached", null);
        String string2 = null;
        if (bl && AFc1tSDK.getCurrencyIso4217Code(this.areAllFieldsValid)) {
            Object object = this.getRevenue.getCurrencyIso4217Code;
            if (object != null && AFg1rSDK.getMediationNetwork(object)) {
                try {
                    object = (TelephonyManager)object.getSystemService("phone");
                    object = (String)object.getClass().getMethod("getDeviceId", new Class[0]).invoke(object, new Object[0]);
                    if (object != null) {
                        string2 = object;
                    } else if (string != null) {
                        AFLogger.afDebugLog("use cached IMEI: ".concat(String.valueOf(string)));
                        string2 = string;
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (string != null) {
                        AFLogger.afDebugLog("use cached IMEI: ".concat(String.valueOf(string)));
                        string2 = string;
                    }
                    AFLogger.afErrorLog("WARNING: Can't collect IMEI because of missing permissions: " + invocationTargetException.getMessage(), invocationTargetException);
                }
                catch (Exception exception) {
                    if (string != null) {
                        AFLogger.afDebugLog("use cached IMEI: ".concat(String.valueOf(string)));
                        string2 = string;
                    }
                    AFLogger.afErrorLog("WARNING: Can't collect IMEI: other reason: " + exception.getMessage(), exception);
                }
            }
        } else if (this.areAllFieldsValid != null) {
            string2 = this.areAllFieldsValid;
        }
        if (!AFc1tSDK.getCurrencyIso4217Code(string2)) {
            aFd1rSDK.getRevenue("imeiCached", string2);
            return string2;
        }
        AFLogger.afInfoLog("IMEI was not collected.");
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Map<String, Object> getMonetizationNetwork(Map<String, Object> map) {
        try {
            Object v;
            Object object;
            Object[] objectArray;
            block4: {
                try {
                    objectArray = new Object[2];
                    objectArray[1] = this.getRevenue.getCurrencyIso4217Code;
                    objectArray[0] = map;
                    object = AFc1gSDK.registerClient.get(1868116792);
                    if (object == null) break block4;
                    v = object;
                    return (Map)((Constructor)v).newInstance(objectArray);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable.getCause();
                    if (throwable2 == null) throw throwable;
                    throw throwable2;
                }
            }
            long l = ViewConfiguration.getGlobalActionKeyTimeout() - 0L;
            object = ((Class)AFc1gSDK.getCurrencyIso4217Code(122 + (l == 0L ? 0 : (l < 0L ? -1 : 1)), 36 - Color.red((int)0), (char)(-1 - TextUtils.lastIndexOf((CharSequence)"", (char)'0')))).getDeclaredConstructor(Map.class, Context.class);
            AFc1gSDK.registerClient.put(1868116792, object);
            v = object;
            return (Map)((Constructor)v).newInstance(objectArray);
        }
        catch (Throwable throwable) {
            AFLogger.afErrorLogForExcManagerOnly("AFCksmV3: reflection init failed", throwable);
            return new HashMap<String, Object>();
        }
    }

    @NonNull
    public final Map<String, Object> AFAdRevenueData() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (this.getRevenue()) {
            hashMap.put("lvl", this.AFAdRevenueData);
        } else if (this.getMonetizationNetwork) {
            this.AFAdRevenueData = new HashMap<String, Object>();
            this.getMediationNetwork();
            this.AFAdRevenueData.put("error", "pending LVL response");
            hashMap.put("lvl", this.AFAdRevenueData);
        }
        return hashMap;
    }

    private boolean getRevenue() {
        return this.AFAdRevenueData != null && !this.AFAdRevenueData.isEmpty();
    }

    public final boolean getCurrencyIso4217Code() {
        return this.getMonetizationNetwork && !this.getRevenue();
    }

    final void getMediationNetwork() {
        long l = System.currentTimeMillis() - this.getCurrencyIso4217Code;
        this.AFAdRevenueData.put("ttr", l);
        this.AFAdRevenueData.put("lvl_timestamp", this.getCurrencyIso4217Code);
    }

    private static boolean getMediationNetwork(Context context) {
        block3: {
            block2: {
                if (AppsFlyerProperties.getInstance().getBoolean("collectAndroidIdForceByUser", false) || AppsFlyerProperties.getInstance().getBoolean("collectIMEIForceByUser", false)) break block2;
                AFb1tSDK.getMonetizationNetwork();
                if (AFb1tSDK.getMediationNetwork(context)) break block3;
            }
            return true;
        }
        return false;
    }
}

