/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFd1kSDK;
import com.appsflyer.internal.AFd1pSDK;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AFg1kSDK {
    @NotNull
    private final Map<String, Object> AFAdRevenueData;
    @Nullable
    private final PackageManager getRevenue;
    @NotNull
    private final String getMonetizationNetwork;

    public AFg1kSDK(@NotNull AFd1kSDK aFd1kSDK, @NotNull AFd1pSDK aFd1pSDK) {
        Intrinsics.checkNotNullParameter((Object)aFd1kSDK, (String)"");
        Intrinsics.checkNotNullParameter((Object)aFd1pSDK, (String)"");
        this.AFAdRevenueData = new LinkedHashMap();
        Context context = aFd1kSDK.getCurrencyIso4217Code;
        this.getRevenue = context != null ? context.getPackageManager() : null;
        String string = aFd1pSDK.AFAdRevenueData.getCurrencyIso4217Code.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        this.getMonetizationNetwork = string;
    }

    @NotNull
    public final Map<String, Object> getMonetizationNetwork() {
        if (this.AFAdRevenueData.isEmpty()) {
            Object object;
            try {
                Object object2 = this.getRevenue;
                if (object2 != null && (object2 = object2.getInstallerPackageName(this.getMonetizationNetwork)) != null) {
                    object = object2;
                    this.AFAdRevenueData.put("installer_package", object);
                }
            }
            catch (Exception exception) {
                AFLogger.afErrorLog("Exception while getting the app's installer package. ", exception);
            }
            if (Build.VERSION.SDK_INT >= 30) {
                object = this;
                Map map = new LinkedHashMap();
                Object object3 = object.getMonetizationNetwork;
                PackageManager packageManager = object.getRevenue;
                if (packageManager != null && (packageManager = packageManager.getInstallSourceInfo((String)object3)) != null) {
                    map = packageManager;
                    Intrinsics.checkNotNullExpressionValue((Object)packageManager, (String)"");
                    object = new LinkedHashMap();
                    String string = map.getInitiatingPackageName();
                    String string2 = "initiating_package";
                    object3 = object;
                    if (string != null) {
                        object3.put(string2, string);
                    }
                    string = map.getInstallingPackageName();
                    string2 = "installing_package";
                    object3 = object;
                    if (string != null) {
                        object3.put(string2, string);
                    }
                    string = map.getOriginatingPackageName();
                    string2 = "originating_package";
                    object3 = object;
                    if (string != null) {
                        object3.put(string2, string);
                    }
                    map = object;
                }
                this.AFAdRevenueData.put("install_source_info", map);
            }
        }
        return this.AFAdRevenueData;
    }
}

