/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.deeplink;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.appsflyer.AFLogger;
import com.appsflyer.deeplink.DeepLink;
import org.json.JSONException;
import org.json.JSONObject;

public class DeepLinkResult {
    @Nullable
    private final Error error;
    @Nullable
    private final DeepLink deepLink;
    @NonNull
    private final Status status;

    public DeepLinkResult(@Nullable DeepLink deepLink, @Nullable Error error) {
        this.deepLink = deepLink;
        this.error = error;
        this.status = error != null ? Status.ERROR : (deepLink != null ? Status.FOUND : Status.NOT_FOUND);
    }

    public Error getError() {
        return this.error;
    }

    public DeepLink getDeepLink() {
        return this.deepLink;
    }

    @NonNull
    public Status getStatus() {
        return this.status;
    }

    public String toString() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("deepLink", (Object)this.deepLink);
            jSONObject.put("error", (Object)this.error);
            jSONObject.put("status", (Object)this.status);
        }
        catch (JSONException jSONException) {
            AFLogger.afErrorLogForExcManagerOnly("error while creating deep link json", jSONException);
        }
        return jSONObject.toString();
    }

    public static enum Error {
        TIMEOUT,
        NETWORK,
        HTTP_STATUS_CODE,
        UNEXPECTED,
        DEVELOPER_ERROR;

    }

    public static enum Status {
        FOUND,
        NOT_FOUND,
        ERROR;

    }
}

