/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.ContentProviderClient;
import android.content.Context;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.DeadObjectException;
import android.os.RemoteException;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFb1vSDK;
import com.appsflyer.internal.AFd1fSDK;
import com.appsflyer.internal.AFg1bSDK;
import com.appsflyer.internal.AFi1bSDK;
import java.util.Observable;
import java.util.Observer;

public final class AFi1dSDK
extends AFi1bSDK {
    final ProviderInfo values;
    private final AFd1fSDK d;

    public AFi1dSDK(ProviderInfo providerInfo, Runnable runnable, AFd1fSDK aFd1fSDK) {
        super("af_referrer", providerInfo.authority, runnable);
        this.d = aFd1fSDK;
        this.values = providerInfo;
    }

    @Override
    public final void values(Context object) {
        object = new Runnable(this, (Context)object){
            private /* synthetic */ Context AFInAppEventType;
            private /* synthetic */ AFi1dSDK AFInAppEventParameterName;
            {
                this.AFInAppEventParameterName = aFi1dSDK;
                this.AFInAppEventType = context;
            }

            @Override
            public final void run() {
                AFi1dSDK aFi1dSDK = this.AFInAppEventParameterName;
                this.AFInAppEventParameterName.AFLogger = System.currentTimeMillis();
                aFi1dSDK.AFInAppEventType = AFi1bSDK.AFa1uSDK.values;
                aFi1dSDK.addObserver(new Observer(aFi1dSDK){
                    private /* synthetic */ AFi1bSDK valueOf;
                    {
                        this.valueOf = aFi1bSDK;
                    }

                    public final void update(Observable o, Object arg) {
                        this.valueOf.AFKeystoreWrapper.run();
                    }
                });
                aFi1dSDK = Uri.parse((String)("content://" + this.AFInAppEventParameterName.values.authority + "/transaction_id"));
                ContentProviderClient contentProviderClient = AFi1dSDK.valueOf(this.AFInAppEventType, (Uri)aFi1dSDK);
                Cursor cursor = null;
                if (contentProviderClient != null) {
                    try {
                        cursor = contentProviderClient.query((Uri)aFi1dSDK, null, "app_id=" + this.AFInAppEventType.getPackageName(), null, null);
                    }
                    catch (DeadObjectException deadObjectException) {
                        com.appsflyer.AFLogger.INSTANCE.e(AFg1bSDK.afDebugLog, "Failed to acquire unstable content providerClient", deadObjectException, false);
                    }
                    catch (RemoteException remoteException) {
                        com.appsflyer.AFLogger.INSTANCE.e(AFg1bSDK.afDebugLog, "Failed to query unstable content providerClient", remoteException, false);
                    }
                    catch (Throwable throwable) {
                        com.appsflyer.AFLogger.INSTANCE.e(AFg1bSDK.afDebugLog, "Error to get data from providerClient ", throwable, false);
                    }
                    finally {
                        if (Build.VERSION.SDK_INT >= 24) {
                            contentProviderClient.close();
                        } else {
                            contentProviderClient.release();
                        }
                    }
                }
                if (cursor != null) {
                    int n = cursor.getColumnIndex("transaction_id");
                    if (n == -1) {
                        com.appsflyer.AFLogger.INSTANCE.w(AFg1bSDK.afDebugLog, "Wrong column name");
                        this.AFInAppEventParameterName.valueOf.put("response", "FEATURE_NOT_SUPPORTED");
                    } else {
                        this.AFInAppEventParameterName.valueOf.put("response", "OK");
                        if (cursor.moveToFirst()) {
                            String string = cursor.getString(n);
                            cursor.close();
                            if (string != null && !string.isEmpty()) {
                                this.AFInAppEventParameterName.valueOf.put("referrer", string);
                            }
                        }
                    }
                    cursor.close();
                } else {
                    com.appsflyer.AFLogger.INSTANCE.w(AFg1bSDK.afDebugLog, "ContentProvider query failed, got null Cursor");
                    this.AFInAppEventParameterName.valueOf.put("response", "SERVICE_UNAVAILABLE");
                }
                this.AFInAppEventParameterName.valueOf.put("api_ver", AFb1vSDK.AFKeystoreWrapper(this.AFInAppEventType, this.AFInAppEventParameterName.values.packageName));
                this.AFInAppEventParameterName.valueOf.put("api_ver_name", AFb1vSDK.values(this.AFInAppEventType, this.AFInAppEventParameterName.values.packageName));
                this.AFInAppEventParameterName.AFInAppEventType();
            }
        };
        this.d.AFKeystoreWrapper().execute((Runnable)object);
    }

    @VisibleForTesting
    @Nullable
    public static ContentProviderClient valueOf(Context context, Uri uri) {
        ContentProviderClient contentProviderClient = null;
        try {
            contentProviderClient = context.getContentResolver().acquireUnstableContentProviderClient(uri);
        }
        catch (SecurityException securityException) {
            com.appsflyer.AFLogger.INSTANCE.e(AFg1bSDK.afDebugLog, "Failed to acquire unstable content providerClient due to SecurityException", securityException, false);
        }
        catch (Throwable throwable) {
            com.appsflyer.AFLogger.INSTANCE.e(AFg1bSDK.afDebugLog, "Failed to acquire unstable content providerClient due to unexpected throwable", throwable, false);
        }
        return contentProviderClient;
    }
}

