/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.ContentProviderClient;
import android.content.Context;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.DeadObjectException;
import android.os.RemoteException;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFb1qSDK;
import com.appsflyer.internal.AFd1nSDK;
import com.appsflyer.internal.AFg1hSDK;
import com.appsflyer.internal.AFi1nSDK;
import java.util.Observable;
import java.util.Observer;

@RequiresApi(api=19)
public final class AFi1mSDK
extends AFi1nSDK {
    final ProviderInfo AFKeystoreWrapper;
    private final AFd1nSDK valueOf;

    public AFi1mSDK(ProviderInfo providerInfo, Runnable runnable, AFd1nSDK aFd1nSDK) {
        super("af_referrer", providerInfo.authority, runnable);
        this.valueOf = aFd1nSDK;
        this.AFKeystoreWrapper = providerInfo;
    }

    @Override
    public final void values(Context object) {
        object = new Runnable(this, (Context)object){
            private /* synthetic */ Context AFKeystoreWrapper;
            private /* synthetic */ AFi1mSDK AFInAppEventParameterName;
            {
                this.AFInAppEventParameterName = aFi1mSDK;
                this.AFKeystoreWrapper = context;
            }

            @Override
            public final void run() {
                AFi1mSDK aFi1mSDK = this.AFInAppEventParameterName;
                this.AFInAppEventParameterName.d = System.currentTimeMillis();
                aFi1mSDK.unregisterClient = AFi1nSDK.AFa1uSDK.AFKeystoreWrapper;
                aFi1mSDK.addObserver(new Observer(aFi1mSDK){
                    private /* synthetic */ AFi1nSDK values;
                    {
                        this.values = aFi1nSDK;
                    }

                    public final void update(Observable observable, Object object) {
                        this.values.AFInAppEventType.run();
                    }
                });
                aFi1mSDK = Uri.parse((String)("content://" + this.AFInAppEventParameterName.AFKeystoreWrapper.authority + "/transaction_id"));
                ContentProviderClient contentProviderClient = AFi1mSDK.AFInAppEventType(this.AFKeystoreWrapper, (Uri)aFi1mSDK);
                Cursor cursor = null;
                if (contentProviderClient != null) {
                    try {
                        cursor = contentProviderClient.query((Uri)aFi1mSDK, null, "app_id=" + this.AFKeystoreWrapper.getPackageName(), null, null);
                    }
                    catch (DeadObjectException deadObjectException) {
                        com.appsflyer.AFLogger.INSTANCE.e(AFg1hSDK.afInfoLog, "Failed to acquire unstable content providerClient", deadObjectException, false);
                    }
                    catch (RemoteException remoteException) {
                        com.appsflyer.AFLogger.INSTANCE.e(AFg1hSDK.afInfoLog, "Failed to query unstable content providerClient", remoteException, false);
                    }
                    catch (Throwable throwable) {
                        com.appsflyer.AFLogger.INSTANCE.e(AFg1hSDK.afInfoLog, "Error to get data from providerClient ", throwable, false);
                    }
                    finally {
                        if (Build.VERSION.SDK_INT >= 24) {
                            contentProviderClient.close();
                        } else {
                            contentProviderClient.release();
                        }
                    }
                }
                if (cursor != null) {
                    int n = cursor.getColumnIndex("transaction_id");
                    if (n == -1) {
                        com.appsflyer.AFLogger.INSTANCE.w(AFg1hSDK.afInfoLog, "Wrong column name");
                        this.AFInAppEventParameterName.values.put("response", "FEATURE_NOT_SUPPORTED");
                    } else {
                        this.AFInAppEventParameterName.values.put("response", "OK");
                        if (cursor.moveToFirst()) {
                            String string = cursor.getString(n);
                            cursor.close();
                            if (string != null && !string.isEmpty()) {
                                this.AFInAppEventParameterName.values.put("referrer", string);
                            }
                        }
                    }
                    cursor.close();
                } else {
                    com.appsflyer.AFLogger.INSTANCE.w(AFg1hSDK.afInfoLog, "ContentProvider query failed, got null Cursor");
                    this.AFInAppEventParameterName.values.put("response", "SERVICE_UNAVAILABLE");
                }
                this.AFInAppEventParameterName.values.put("api_ver", AFb1qSDK.AFInAppEventParameterName(this.AFKeystoreWrapper, this.AFInAppEventParameterName.AFKeystoreWrapper.packageName));
                this.AFInAppEventParameterName.values.put("api_ver_name", AFb1qSDK.AFKeystoreWrapper(this.AFKeystoreWrapper, this.AFInAppEventParameterName.AFKeystoreWrapper.packageName));
                this.AFInAppEventParameterName.AFInAppEventType();
            }
        };
        this.valueOf.values().execute((Runnable)object);
    }

    @VisibleForTesting
    @Nullable
    public static ContentProviderClient AFInAppEventType(Context context, Uri uri) {
        ContentProviderClient contentProviderClient = null;
        try {
            contentProviderClient = context.getContentResolver().acquireUnstableContentProviderClient(uri);
        }
        catch (SecurityException securityException) {
            com.appsflyer.AFLogger.INSTANCE.e(AFg1hSDK.afInfoLog, "Failed to acquire unstable content providerClient due to SecurityException", securityException, false);
        }
        catch (Throwable throwable) {
            com.appsflyer.AFLogger.INSTANCE.e(AFg1hSDK.afInfoLog, "Failed to acquire unstable content providerClient due to unexpected throwable", throwable, false);
        }
        return contentProviderClient;
    }
}

