/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFh1ySDK;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class AFh1wSDK
extends AFh1ySDK {
    public AFh1wSDK(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"");
        super(context);
    }

    @Override
    @NotNull
    protected final String values() {
        AFh1wSDK aFh1wSDK = this;
        ConnectivityManager connectivityManager = aFh1wSDK.valueOf;
        if (connectivityManager != null) {
            aFh1wSDK = connectivityManager;
            if (AFh1wSDK.AFInAppEventType(connectivityManager.getNetworkInfo(1))) {
                return "WIFI";
            }
            if (AFh1wSDK.AFInAppEventType(aFh1wSDK.getNetworkInfo(0))) {
                return "MOBILE";
            }
            NetworkInfo networkInfo = aFh1wSDK.getActiveNetworkInfo();
            if (networkInfo != null) {
                switch (networkInfo.getType()) {
                    case 1: {
                        return "WIFI";
                    }
                    case 0: {
                        return "MOBILE";
                    }
                }
                return "unknown";
            }
            return "unknown";
        }
        return "unknown";
    }

    @Override
    public final boolean AFInAppEventParameterName() {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"");
            ArrayList<NetworkInterface> arrayList = Collections.list(enumeration);
            Intrinsics.checkNotNullExpressionValue(arrayList, (String)"");
            Object object = arrayList;
            if (!(object instanceof Collection) || !((Collection)object).isEmpty()) {
                object = object.iterator();
                while (object.hasNext()) {
                    NetworkInterface networkInterface = (NetworkInterface)object.next();
                    if (!(networkInterface.isUp() && Intrinsics.areEqual((Object)networkInterface.getName(), (Object)"tun0"))) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception exception) {
            AFLogger.afErrorLog("Failed collecting ivc data", exception);
            return false;
        }
    }
}

