/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.ContentProviderClient;
import android.content.Context;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.DeadObjectException;
import android.os.RemoteException;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFb1rSDK;
import com.appsflyer.internal.AFd1pSDK;
import com.appsflyer.internal.AFh1mSDK;
import java.util.Observable;
import java.util.Observer;

@RequiresApi(api=19)
public final class AFh1jSDK
extends AFh1mSDK {
    final ProviderInfo AFInAppEventType;
    private final AFd1pSDK AFInAppEventParameterName;

    public AFh1jSDK(ProviderInfo providerInfo, Runnable runnable, AFd1pSDK aFd1pSDK) {
        super("af_referrer", providerInfo.authority, runnable);
        this.AFInAppEventParameterName = aFd1pSDK;
        this.AFInAppEventType = providerInfo;
    }

    @Override
    public final void valueOf(Context object) {
        object = new Runnable(){
            private /* synthetic */ Context AFInAppEventType;
            private /* synthetic */ AFh1jSDK valueOf;
            {
                this.valueOf = aFh1jSDK;
                this.AFInAppEventType = context;
            }

            @Override
            public final void run() {
                AFh1jSDK aFh1jSDK = this.valueOf;
                this.valueOf.afRDLog = System.currentTimeMillis();
                aFh1jSDK.afDebugLog = AFh1mSDK.AFa1ySDK.valueOf;
                aFh1jSDK.addObserver(new Observer(aFh1jSDK){
                    private /* synthetic */ AFh1mSDK values;
                    {
                        this.values = aFh1mSDK;
                    }

                    public final void update(Observable observable, Object object) {
                        this.values.valueOf.run();
                    }
                });
                aFh1jSDK = Uri.parse((String)("content://" + this.valueOf.AFInAppEventType.authority + "/transaction_id"));
                ContentProviderClient contentProviderClient = AFh1jSDK.values(this.AFInAppEventType, (Uri)aFh1jSDK);
                Cursor cursor = null;
                if (contentProviderClient != null) {
                    try {
                        cursor = contentProviderClient.query((Uri)aFh1jSDK, null, "app_id=" + this.AFInAppEventType.getPackageName(), null, null);
                    }
                    catch (DeadObjectException deadObjectException) {
                        com.appsflyer.AFLogger.afErrorLog("[Preinstall]: Failed to acquire unstable content providerClient", deadObjectException, false);
                    }
                    catch (RemoteException remoteException) {
                        com.appsflyer.AFLogger.afErrorLog("[Preinstall]: Failed to query unstable content providerClient", remoteException, false);
                    }
                    catch (Throwable throwable) {
                        com.appsflyer.AFLogger.afErrorLog("[Preinstall]: Error to get data from providerClient ", throwable, false);
                    }
                    finally {
                        if (Build.VERSION.SDK_INT >= 24) {
                            contentProviderClient.close();
                        } else {
                            contentProviderClient.release();
                        }
                    }
                }
                if (cursor != null) {
                    int n = cursor.getColumnIndex("transaction_id");
                    if (n == -1) {
                        com.appsflyer.AFLogger.afWarnLog("[Preinstall]: Wrong column name");
                        this.valueOf.AFKeystoreWrapper.put("response", "FEATURE_NOT_SUPPORTED");
                    } else {
                        this.valueOf.AFKeystoreWrapper.put("response", "OK");
                        if (cursor.moveToFirst()) {
                            String string = cursor.getString(n);
                            cursor.close();
                            if (string != null && !string.isEmpty()) {
                                this.valueOf.AFKeystoreWrapper.put("referrer", string);
                            }
                        }
                    }
                    cursor.close();
                } else {
                    com.appsflyer.AFLogger.afWarnLog("[Preinstall]: ContentProvider query failed, got null Cursor");
                    this.valueOf.AFKeystoreWrapper.put("response", "SERVICE_UNAVAILABLE");
                }
                this.valueOf.AFKeystoreWrapper.put("api_ver", AFb1rSDK.AFKeystoreWrapper(this.AFInAppEventType, this.valueOf.AFInAppEventType.packageName));
                this.valueOf.AFKeystoreWrapper.put("api_ver_name", AFb1rSDK.values(this.AFInAppEventType, this.valueOf.AFInAppEventType.packageName));
                this.valueOf.AFInAppEventParameterName();
            }
        };
        this.AFInAppEventParameterName.AFInAppEventType().execute((Runnable)object);
    }

    @VisibleForTesting
    @Nullable
    public static ContentProviderClient values(Context context, Uri uri) {
        ContentProviderClient contentProviderClient = null;
        try {
            contentProviderClient = context.getContentResolver().acquireUnstableContentProviderClient(uri);
        }
        catch (SecurityException securityException) {
            com.appsflyer.AFLogger.afErrorLog("[Preinstall]: Failed to acquire unstable content providerClient due to SecurityException", securityException, false);
        }
        catch (Throwable throwable) {
            com.appsflyer.AFLogger.afErrorLog("[Preinstall]: Failed to acquire unstable content providerClient due to unexpected throwable", throwable, false);
        }
        return contentProviderClient;
    }
}

