/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.util.Log;
import androidx.annotation.NonNull;
import com.appsflyer.AppsFlyerProperties;
import com.appsflyer.internal.AFa1bSDK;

public class AFLogger {
    private static final long AFInAppEventType = System.currentTimeMillis();

    public static void afInfoLog(String string, boolean bl) {
        if (AFLogger.valueOf(LogLevel.INFO)) {
            Log.i((String)"AppsFlyer_6.12.3", (String)AFLogger.AFInAppEventParameterName(string, false));
        }
        if (bl) {
            AFa1bSDK.values().valueOf().afErrorLogForExcManagerOnly().AFInAppEventParameterName("I", AFLogger.AFInAppEventParameterName(string, true));
        }
    }

    @NonNull
    private static String AFInAppEventParameterName(String string, boolean bl) {
        if (string == null) {
            string = "null";
        }
        if (bl || LogLevel.VERBOSE.getLevel() <= AppsFlyerProperties.getInstance().getInt("logLevel", LogLevel.NONE.getLevel())) {
            return "(" + (System.currentTimeMillis() - AFInAppEventType) + ") [" + Thread.currentThread().getName() + "] " + string;
        }
        return string;
    }

    public static void afErrorLog(String string, Throwable throwable, boolean bl, boolean bl2, boolean bl3) {
        if (string == null) {
            string = throwable.getClass().getSimpleName() + " at " + ((Object)throwable.getStackTrace()[0]).toString();
        }
        if (AFLogger.valueOf(LogLevel.ERROR)) {
            String string2 = AFLogger.AFInAppEventParameterName(string, false);
            if (bl2) {
                Log.e((String)"AppsFlyer_6.12.3", (String)string2, (Throwable)throwable);
            } else if (bl) {
                Log.d((String)"AppsFlyer_6.12.3", (String)string2);
            }
        }
        AFa1bSDK.values().valueOf().afErrorLogForExcManagerOnly().AFInAppEventType(throwable);
        if (bl3) {
            AFa1bSDK.values().valueOf().onResponseErrorNative().values(throwable, string);
        }
    }

    public static void AFKeystoreWrapper(String string) {
        if (AFLogger.valueOf(LogLevel.WARNING)) {
            Log.w((String)"AppsFlyer_6.12.3", (String)AFLogger.AFInAppEventParameterName(string, false));
        }
        AFa1bSDK.values().valueOf().afErrorLogForExcManagerOnly().AFInAppEventParameterName("W", AFLogger.AFInAppEventParameterName(string, true));
    }

    public static void afRDLog(String string) {
        if (AFLogger.valueOf(LogLevel.VERBOSE)) {
            Log.v((String)"AppsFlyer_6.12.3", (String)AFLogger.AFInAppEventParameterName(string, false));
        }
        AFa1bSDK.values().valueOf().afErrorLogForExcManagerOnly().AFInAppEventParameterName("V", AFLogger.AFInAppEventParameterName(string, true));
    }

    private static boolean valueOf(LogLevel logLevel) {
        return logLevel.getLevel() <= AppsFlyerProperties.getInstance().getInt("logLevel", LogLevel.NONE.getLevel());
    }

    public static void AFInAppEventType(String string) {
        if (!AFLogger.AFInAppEventType()) {
            Log.d((String)"AppsFlyer_6.12.3", (String)AFLogger.AFInAppEventParameterName(string, false));
        }
        AFa1bSDK.values().valueOf().afErrorLogForExcManagerOnly().AFInAppEventParameterName("F", string);
    }

    private static boolean AFInAppEventType() {
        return AppsFlyerProperties.getInstance().isLogsDisabledCompletely();
    }

    public static void afDebugLog(String string) {
        if (AFLogger.valueOf(LogLevel.DEBUG)) {
            Log.d((String)"AppsFlyer_6.12.3", (String)AFLogger.AFInAppEventParameterName(string, false));
        }
        AFa1bSDK.values().valueOf().afErrorLogForExcManagerOnly().AFInAppEventParameterName("D", AFLogger.AFInAppEventParameterName(string, true));
    }

    public static void afInfoLog(String string) {
        AFLogger.afInfoLog(string, true);
    }

    public static void afErrorLog(String string, Throwable throwable) {
        AFLogger.afErrorLog(string, throwable, true, false, true);
    }

    public static void afErrorLogForExcManagerOnly(String string, Throwable throwable) {
        AFLogger.afErrorLogForExcManagerOnly(string, throwable, false);
    }

    public static void afErrorLogForExcManagerOnly(String string, Throwable throwable, boolean bl) {
        AFLogger.afErrorLog(string, throwable, false, false, !bl);
    }

    public static void afErrorLog(String string, Throwable throwable, boolean bl) {
        AFLogger.afErrorLog(string, throwable, true, bl, true);
    }

    public static void afErrorLog(String string, Throwable throwable, boolean bl, boolean bl2) {
        AFLogger.afErrorLog(string, throwable, true, bl, bl2);
    }

    @Deprecated
    public static void afErrorLog(Throwable throwable) {
        AFLogger.afErrorLogForExcManagerOnly("Unknown", throwable);
    }

    public static void afWarnLog(String string) {
        AFLogger.AFKeystoreWrapper(string);
    }

    public static enum LogLevel {
        NONE(0),
        ERROR(1),
        WARNING(2),
        INFO(3),
        DEBUG(4),
        VERBOSE(5);

        private int AFKeystoreWrapper;

        private LogLevel(int n2) {
            this.AFKeystoreWrapper = n2;
        }

        public final int getLevel() {
            return this.AFKeystoreWrapper;
        }
    }
}

