/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.ContentProviderClient;
import android.content.Context;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.DeadObjectException;
import android.os.RemoteException;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFa1fSDK;
import com.appsflyer.internal.AFc1xSDK;
import com.appsflyer.internal.AFf1pSDK;
import java.util.Observable;
import java.util.Observer;

@RequiresApi(api=19)
public final class AFf1lSDK
extends AFf1pSDK {
    final ProviderInfo AFInAppEventType;
    private final AFc1xSDK valueOf;

    public AFf1lSDK(ProviderInfo providerInfo, Runnable runnable, AFc1xSDK aFc1xSDK) {
        super("af_referrer", providerInfo.authority, runnable);
        this.valueOf = aFc1xSDK;
        this.AFInAppEventType = providerInfo;
    }

    @Override
    public final void valueOf(Context object) {
        object = new Runnable(this, (Context)object){
            private /* synthetic */ Context AFKeystoreWrapper;
            private /* synthetic */ AFf1lSDK AFInAppEventParameterName;
            {
                this.AFInAppEventParameterName = aFf1lSDK;
                this.AFKeystoreWrapper = context;
            }

            @Override
            public final void run() {
                AFf1lSDK aFf1lSDK = this.AFInAppEventParameterName;
                this.AFInAppEventParameterName.afInfoLog = System.currentTimeMillis();
                aFf1lSDK.afDebugLog = AFf1pSDK.AFa1zSDK.AFInAppEventType;
                aFf1lSDK.addObserver(new Observer(aFf1lSDK){
                    private /* synthetic */ AFf1pSDK values;
                    {
                        this.values = aFf1pSDK;
                    }

                    public final void update(Observable observable, Object object) {
                        this.values.values.run();
                    }
                });
                aFf1lSDK = Uri.parse((String)("content://" + this.AFInAppEventParameterName.AFInAppEventType.authority + "/transaction_id"));
                ContentProviderClient contentProviderClient = AFf1lSDK.valueOf(this.AFKeystoreWrapper, (Uri)aFf1lSDK);
                Cursor cursor = null;
                if (contentProviderClient != null) {
                    try {
                        cursor = contentProviderClient.query((Uri)aFf1lSDK, null, "app_id=" + this.AFKeystoreWrapper.getPackageName(), null, null);
                    }
                    catch (DeadObjectException deadObjectException) {
                        AFLogger.afErrorLog("[Preinstall]: Failed to acquire unstable content providerClient", deadObjectException, false);
                    }
                    catch (RemoteException remoteException) {
                        AFLogger.afErrorLog("[Preinstall]: Failed to query unstable content providerClient", remoteException, false);
                    }
                    catch (Throwable throwable) {
                        AFLogger.afErrorLog("[Preinstall]: Error to get data from providerClient ", throwable, false);
                    }
                    finally {
                        if (Build.VERSION.SDK_INT >= 24) {
                            contentProviderClient.close();
                        } else {
                            contentProviderClient.release();
                        }
                    }
                }
                if (cursor != null) {
                    int n = cursor.getColumnIndex("transaction_id");
                    if (n == -1) {
                        AFLogger.afWarnLog("[Preinstall]: Wrong column name");
                        this.AFInAppEventParameterName.AFInAppEventParameterName.put("response", "FEATURE_NOT_SUPPORTED");
                    } else {
                        this.AFInAppEventParameterName.AFInAppEventParameterName.put("response", "OK");
                        if (cursor.moveToFirst()) {
                            String string = cursor.getString(n);
                            cursor.close();
                            if (string != null && !string.isEmpty()) {
                                this.AFInAppEventParameterName.AFInAppEventParameterName.put("referrer", string);
                            }
                        }
                    }
                    cursor.close();
                } else {
                    AFLogger.afWarnLog("[Preinstall]: ContentProvider query failed, got null Cursor");
                    this.AFInAppEventParameterName.AFInAppEventParameterName.put("response", "SERVICE_UNAVAILABLE");
                }
                this.AFInAppEventParameterName.AFInAppEventParameterName.put("api_ver", AFa1fSDK.AFInAppEventType(this.AFKeystoreWrapper, this.AFInAppEventParameterName.AFInAppEventType.packageName));
                this.AFInAppEventParameterName.AFInAppEventParameterName.put("api_ver_name", AFa1fSDK.AFKeystoreWrapper(this.AFKeystoreWrapper, this.AFInAppEventParameterName.AFInAppEventType.packageName));
                this.AFInAppEventParameterName.values();
            }
        };
        this.valueOf.AFInAppEventType().execute((Runnable)object);
    }

    @VisibleForTesting
    @Nullable
    public static ContentProviderClient valueOf(Context context, Uri uri) {
        ContentProviderClient contentProviderClient = null;
        try {
            contentProviderClient = context.getContentResolver().acquireUnstableContentProviderClient(uri);
        }
        catch (SecurityException securityException) {
            AFLogger.afErrorLog("[Preinstall]: Failed to acquire unstable content providerClient due to SecurityException", securityException, false);
        }
        catch (Throwable throwable) {
            AFLogger.afErrorLog("[Preinstall]: Failed to acquire unstable content providerClient due to unexpected throwable", throwable, false);
        }
        return contentProviderClient;
    }
}

