/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import androidx.annotation.NonNull;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFa1cSDK;
import com.appsflyer.internal.AFf1pSDK;
import com.appsflyer.internal.AFf1rSDK;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ExecutorService;

public class AFf1nSDK
extends AFf1rSDK {
    public final Map<String, Object> values = new HashMap<String, Object>();
    @NonNull
    private final ExecutorService valueOf;

    public AFf1nSDK(@NonNull Runnable runnable, @NonNull ExecutorService executorService) {
        super("store", "google", runnable);
        this.valueOf = executorService;
    }

    private static boolean AFInAppEventType(@NonNull Context context) {
        if (!AFf1nSDK.AFKeystoreWrapper(context)) {
            return false;
        }
        String string = "com.android.installreferrer.api.InstallReferrerClient";
        try {
            Class.forName(string);
            if (AFa1cSDK.AFInAppEventType(context, "com.google.android.finsky.permission.BIND_GET_INSTALL_REFERRER_SERVICE")) {
                com.appsflyer.AFLogger.afDebugLog("Install referrer is allowed");
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("InstallReferrerClient not found", classNotFoundException);
            com.appsflyer.AFLogger.afRDLog("Class " + string + " not found");
            return false;
        }
        catch (Throwable throwable) {
            com.appsflyer.AFLogger.afErrorLog("An error occurred while trying to verify manifest : ".concat(String.valueOf(string)), throwable);
            return false;
        }
        com.appsflyer.AFLogger.afDebugLog("Install referrer is not allowed");
        return false;
    }

    @Override
    public final void values(Context context) {
        if (!AFf1nSDK.AFInAppEventType(context)) {
            return;
        }
        AFf1nSDK aFf1nSDK = this;
        this.afDebugLog = System.currentTimeMillis();
        aFf1nSDK.AFLogger = AFf1pSDK.AFa1vSDK.valueOf;
        aFf1nSDK.addObserver(new Observer(aFf1nSDK){
            private /* synthetic */ AFf1pSDK AFInAppEventType;
            {
                this.AFInAppEventType = aFf1pSDK;
            }

            public final void update(Observable observable, Object object) {
                this.AFInAppEventType.AFInAppEventType.run();
            }
        });
        try {
            aFf1nSDK = InstallReferrerClient.newBuilder((Context)context).build();
            com.appsflyer.AFLogger.afDebugLog("Connecting to Install Referrer Library...");
            aFf1nSDK.startConnection(new InstallReferrerStateListener(){
                final /* synthetic */ InstallReferrerClient val$referrerClient;
                final /* synthetic */ Context val$context;
                {
                    this.val$referrerClient = installReferrerClient;
                    this.val$context = context;
                }

                public final void onInstallReferrerSetupFinished(int n) {
                    AFf1nSDK.this.valueOf.execute(() -> AFf1nSDK.AFInAppEventType(AFf1nSDK.this, this.val$referrerClient, this.val$context, n));
                }

                public final void onInstallReferrerServiceDisconnected() {
                    com.appsflyer.AFLogger.afDebugLog("Install Referrer service disconnected");
                }
            });
            return;
        }
        catch (Throwable throwable) {
            com.appsflyer.AFLogger.afErrorLog("referrerClient -> startConnection", throwable);
            return;
        }
    }

    static /* synthetic */ void AFInAppEventType(AFf1nSDK aFf1nSDK, InstallReferrerClient installReferrerClient, Context context, int n) {
        aFf1nSDK.values.put("code", String.valueOf(n));
        String string = "com.android.vending";
        aFf1nSDK.AFInAppEventParameterName.put("api_ver", AFa1cSDK.AFInAppEventParameterName(context, string));
        aFf1nSDK.AFInAppEventParameterName.put("api_ver_name", AFa1cSDK.values(context, string));
        switch (n) {
            case 0: {
                aFf1nSDK.AFInAppEventParameterName.put("response", "OK");
                try {
                    com.appsflyer.AFLogger.afDebugLog("InstallReferrer connected");
                    if (installReferrerClient.isReady()) {
                        context = installReferrerClient.getInstallReferrer();
                        Object object = context.getInstallReferrer();
                        if (object != null) {
                            aFf1nSDK.values.put("val", object);
                            aFf1nSDK.AFInAppEventParameterName.put("referrer", object);
                        }
                        long l = context.getReferrerClickTimestampSeconds();
                        aFf1nSDK.values.put("clk", Long.toString(l));
                        aFf1nSDK.AFInAppEventParameterName.put("click_ts", l);
                        long l2 = context.getInstallBeginTimestampSeconds();
                        aFf1nSDK.values.put("install", Long.toString(l2));
                        aFf1nSDK.AFInAppEventParameterName.put("install_begin_ts", l2);
                        object = new HashMap();
                        try {
                            boolean bl = context.getGooglePlayInstantParam();
                            aFf1nSDK.values.put("instant", bl);
                            ((AbstractMap)object).put("instant", bl);
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("getGooglePlayInstantParam not exist", noSuchMethodError);
                        }
                        try {
                            ((AbstractMap)object).put("click_server_ts", context.getReferrerClickTimestampServerSeconds());
                            ((AbstractMap)object).put("install_begin_server_ts", context.getInstallBeginTimestampServerSeconds());
                            ((AbstractMap)object).put("install_version", context.getInstallVersion());
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("some method not exist", noSuchMethodError);
                        }
                        if (!((AbstractMap)object).isEmpty()) {
                            aFf1nSDK.AFInAppEventParameterName.put("google_custom", object);
                        }
                        installReferrerClient.endConnection();
                        break;
                    }
                    com.appsflyer.AFLogger.afWarnLog("ReferrerClient: InstallReferrer is not ready");
                    aFf1nSDK.values.put("err", "ReferrerClient: InstallReferrer is not ready");
                }
                catch (Throwable throwable) {
                    com.appsflyer.AFLogger.afWarnLog("Failed to get install referrer: " + throwable.getMessage());
                    aFf1nSDK.values.put("err", throwable.getMessage());
                    com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("Failed to get install referrer", throwable);
                }
                break;
            }
            case 2: {
                com.appsflyer.AFLogger.afWarnLog("InstallReferrer FEATURE_NOT_SUPPORTED");
                aFf1nSDK.AFInAppEventParameterName.put("response", "FEATURE_NOT_SUPPORTED");
                break;
            }
            case 1: {
                aFf1nSDK.AFInAppEventParameterName.put("response", "SERVICE_UNAVAILABLE");
                com.appsflyer.AFLogger.afWarnLog("InstallReferrer not supported");
                break;
            }
            case 3: {
                com.appsflyer.AFLogger.afWarnLog("InstallReferrer DEVELOPER_ERROR");
                aFf1nSDK.AFInAppEventParameterName.put("response", "DEVELOPER_ERROR");
                break;
            }
            case -1: {
                com.appsflyer.AFLogger.afWarnLog("InstallReferrer SERVICE_DISCONNECTED");
                aFf1nSDK.AFInAppEventParameterName.put("response", "SERVICE_DISCONNECTED");
                break;
            }
            default: {
                com.appsflyer.AFLogger.afWarnLog("responseCode not found.");
            }
        }
        com.appsflyer.AFLogger.afDebugLog("Install Referrer collected locally");
        aFf1nSDK.AFInAppEventParameterName();
    }
}

