/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.ContentProviderClient;
import android.content.Context;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.DeadObjectException;
import android.os.RemoteException;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFa1bSDK;
import com.appsflyer.internal.AFc1pSDK;
import com.appsflyer.internal.AFg1uSDK;
import java.util.Observable;
import java.util.Observer;

@RequiresApi(api=19)
public final class AFf1aSDK
extends AFg1uSDK {
    final ProviderInfo AFInAppEventType;
    private final AFc1pSDK AFInAppEventParameterName;

    public AFf1aSDK(ProviderInfo providerInfo, Runnable runnable, AFc1pSDK aFc1pSDK) {
        super("af_referrer", providerInfo.authority, runnable);
        this.AFInAppEventParameterName = aFc1pSDK;
        this.AFInAppEventType = providerInfo;
    }

    @Override
    public final void valueOf(Context object) {
        object = new Runnable(){
            private /* synthetic */ Context AFKeystoreWrapper;
            private /* synthetic */ AFf1aSDK AFInAppEventType;
            {
                this.AFInAppEventType = aFf1aSDK;
                this.AFKeystoreWrapper = context;
            }

            @Override
            public final void run() {
                AFf1aSDK aFf1aSDK = this.AFInAppEventType;
                this.AFInAppEventType.afDebugLog = System.currentTimeMillis();
                aFf1aSDK.AFLogger = AFg1uSDK.AFa1xSDK.AFKeystoreWrapper;
                aFf1aSDK.addObserver(new Observer(aFf1aSDK){
                    private /* synthetic */ AFg1uSDK AFKeystoreWrapper;
                    {
                        this.AFKeystoreWrapper = aFg1uSDK;
                    }

                    public final void update(Observable observable, Object object) {
                        this.AFKeystoreWrapper.AFKeystoreWrapper.run();
                    }
                });
                aFf1aSDK = Uri.parse((String)("content://" + this.AFInAppEventType.AFInAppEventType.authority + "/transaction_id"));
                ContentProviderClient contentProviderClient = AFf1aSDK.AFKeystoreWrapper(this.AFKeystoreWrapper, (Uri)aFf1aSDK);
                Cursor cursor = null;
                if (contentProviderClient != null) {
                    try {
                        cursor = contentProviderClient.query((Uri)aFf1aSDK, null, "app_id=" + this.AFKeystoreWrapper.getPackageName(), null, null);
                    }
                    catch (DeadObjectException deadObjectException) {
                        com.appsflyer.AFLogger.afErrorLog("[Preinstall]: Failed to acquire unstable content providerClient", deadObjectException, false);
                    }
                    catch (RemoteException remoteException) {
                        com.appsflyer.AFLogger.afErrorLog("[Preinstall]: Failed to query unstable content providerClient", remoteException, false);
                    }
                    catch (Throwable throwable) {
                        com.appsflyer.AFLogger.afErrorLog("[Preinstall]: Error to get data from providerClient ", throwable, false);
                    }
                    finally {
                        if (Build.VERSION.SDK_INT >= 24) {
                            contentProviderClient.close();
                        } else {
                            contentProviderClient.release();
                        }
                    }
                }
                if (cursor != null) {
                    int n = cursor.getColumnIndex("transaction_id");
                    if (n == -1) {
                        com.appsflyer.AFLogger.afWarnLog("[Preinstall]: Wrong column name");
                        this.AFInAppEventType.valueOf.put("response", "FEATURE_NOT_SUPPORTED");
                    } else {
                        this.AFInAppEventType.valueOf.put("response", "OK");
                        if (cursor.moveToFirst()) {
                            String string = cursor.getString(n);
                            cursor.close();
                            if (string != null && !string.isEmpty()) {
                                this.AFInAppEventType.valueOf.put("referrer", string);
                            }
                        }
                    }
                    cursor.close();
                } else {
                    com.appsflyer.AFLogger.afWarnLog("[Preinstall]: ContentProvider query failed, got null Cursor");
                    this.AFInAppEventType.valueOf.put("response", "SERVICE_UNAVAILABLE");
                }
                this.AFInAppEventType.valueOf.put("api_ver", AFa1bSDK.AFKeystoreWrapper(this.AFKeystoreWrapper, this.AFInAppEventType.AFInAppEventType.packageName));
                this.AFInAppEventType.valueOf.put("api_ver_name", AFa1bSDK.values(this.AFKeystoreWrapper, this.AFInAppEventType.AFInAppEventType.packageName));
                this.AFInAppEventType.AFInAppEventType();
            }
        };
        this.AFInAppEventParameterName.valueOf().execute((Runnable)object);
    }

    @VisibleForTesting
    @Nullable
    public static ContentProviderClient AFKeystoreWrapper(Context context, Uri uri) {
        ContentProviderClient contentProviderClient = null;
        try {
            contentProviderClient = context.getContentResolver().acquireUnstableContentProviderClient(uri);
        }
        catch (SecurityException securityException) {
            com.appsflyer.AFLogger.afErrorLog("[Preinstall]: Failed to acquire unstable content providerClient due to SecurityException", securityException, false);
        }
        catch (Throwable throwable) {
            com.appsflyer.AFLogger.afErrorLog("[Preinstall]: Failed to acquire unstable content providerClient due to unexpected throwable", throwable, false);
        }
        return contentProviderClient;
    }
}

