/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFe1ySDK;
import com.appsflyer.internal.AFf1zSDK;
import org.json.JSONException;
import org.json.JSONObject;

public final class AFe1oSDK {
    private final boolean values;
    @NonNull
    public final String valueOf;
    @NonNull
    public final String AFInAppEventType;
    @NonNull
    public final AFf1zSDK AFInAppEventParameterName;
    @Nullable
    public final AFe1ySDK AFKeystoreWrapper;

    public AFe1oSDK() {
    }

    public static boolean valueOf(Context context) {
        if (Build.VERSION.SDK_INT >= 26) {
            return context.getPackageManager().isInstantApp();
        }
        try {
            context.getClassLoader().loadClass("com.google.android.instantapps.supervisor.InstantAppsRuntime");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            AFLogger.afErrorLogForExcManagerOnly("InstantAppsRuntime not found", classNotFoundException, true);
            return false;
        }
    }

    public AFe1oSDK(String object) throws JSONException {
        if (object == null) {
            throw new JSONException("Failed to parse remote configuration JSON: originalJson is null");
        }
        try {
            JSONObject jSONObject = new JSONObject((String)object);
            this.valueOf = jSONObject.getString("ver");
            this.values = jSONObject.optBoolean("test_mode");
            this.AFInAppEventType = object;
            this.AFInAppEventParameterName = this.valueOf.startsWith("default") ? AFf1zSDK.AFInAppEventType : AFf1zSDK.valueOf;
            object = null;
            jSONObject = jSONObject.optJSONObject("features");
            if (jSONObject != null) {
                object = new AFe1ySDK(jSONObject);
            }
            this.AFKeystoreWrapper = object;
            return;
        }
        catch (JSONException jSONException) {
            AFLogger.afErrorLogForExcManagerOnly("Error in RC config parsing", jSONException);
            throw new JSONException("Failed to parse remote configuration JSON");
        }
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (AFe1oSDK)object;
        if (this.values != ((AFe1oSDK)object).values) {
            return false;
        }
        if (!this.valueOf.equals(((AFe1oSDK)object).valueOf)) {
            return false;
        }
        return this.AFInAppEventType.equals(((AFe1oSDK)object).AFInAppEventType);
    }

    public final int hashCode() {
        int n = this.values ? 1 : 0;
        n = n * 31 + this.valueOf.hashCode();
        n = n * 31 + this.AFInAppEventType.hashCode();
        if (this.AFKeystoreWrapper != null) {
            n = n * 31 + ((Object)this.AFKeystoreWrapper).hashCode();
        }
        return n;
    }
}

