/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import androidx.annotation.NonNull;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFa1cSDK;
import com.appsflyer.internal.AFf1kSDK;
import com.appsflyer.internal.AFf1nSDK;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ExecutorService;

public class AFf1pSDK
extends AFf1nSDK {
    public final Map<String, Object> AFKeystoreWrapper = new HashMap<String, Object>();
    @NonNull
    private final ExecutorService AFInAppEventParameterName;

    public AFf1pSDK(@NonNull Runnable runnable, @NonNull ExecutorService executorService) {
        super("store", "google", runnable);
        this.AFInAppEventParameterName = executorService;
    }

    private static boolean AFInAppEventParameterName(@NonNull Context context) {
        if (!AFf1pSDK.AFKeystoreWrapper(context)) {
            return false;
        }
        String string = "com.android.installreferrer.api.InstallReferrerClient";
        try {
            Class.forName(string);
            if (AFa1cSDK.AFInAppEventParameterName(context, "com.google.android.finsky.permission.BIND_GET_INSTALL_REFERRER_SERVICE")) {
                com.appsflyer.AFLogger.afDebugLog("Install referrer is allowed");
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("InstallReferrerClient not found", classNotFoundException);
            com.appsflyer.AFLogger.afRDLog("Class " + string + " not found");
            return false;
        }
        catch (Throwable throwable) {
            com.appsflyer.AFLogger.afErrorLog("An error occurred while trying to verify manifest : ".concat(String.valueOf(string)), throwable);
            return false;
        }
        com.appsflyer.AFLogger.afDebugLog("Install referrer is not allowed");
        return false;
    }

    @Override
    public final void valueOf(Context context) {
        if (!AFf1pSDK.AFInAppEventParameterName(context)) {
            return;
        }
        AFf1pSDK aFf1pSDK = this;
        this.afInfoLog = System.currentTimeMillis();
        aFf1pSDK.afRDLog = AFf1kSDK.AFa1wSDK.AFKeystoreWrapper;
        aFf1pSDK.addObserver(new Observer(aFf1pSDK){
            private /* synthetic */ AFf1kSDK values;
            {
                this.values = aFf1kSDK;
            }

            public final void update(Observable observable, Object object) {
                this.values.values.run();
            }
        });
        try {
            aFf1pSDK = InstallReferrerClient.newBuilder((Context)context).build();
            com.appsflyer.AFLogger.afDebugLog("Connecting to Install Referrer Library...");
            aFf1pSDK.startConnection(new InstallReferrerStateListener((InstallReferrerClient)aFf1pSDK, context){
                final /* synthetic */ InstallReferrerClient val$referrerClient;
                final /* synthetic */ Context val$context;
                {
                    this.val$referrerClient = installReferrerClient;
                    this.val$context = context;
                }

                public final void onInstallReferrerSetupFinished(int n) {
                    AFf1pSDK.this.AFInAppEventParameterName.execute(() -> AFf1pSDK.values(AFf1pSDK.this, this.val$referrerClient, this.val$context, n));
                }

                public final void onInstallReferrerServiceDisconnected() {
                    com.appsflyer.AFLogger.afDebugLog("Install Referrer service disconnected");
                }
            });
            return;
        }
        catch (Throwable throwable) {
            com.appsflyer.AFLogger.afErrorLog("referrerClient -> startConnection", throwable);
            return;
        }
    }

    static /* synthetic */ void values(AFf1pSDK aFf1pSDK, InstallReferrerClient installReferrerClient, Context context, int n) {
        aFf1pSDK.AFKeystoreWrapper.put("code", String.valueOf(n));
        String string = "com.android.vending";
        aFf1pSDK.AFInAppEventType.put("api_ver", AFa1cSDK.AFKeystoreWrapper(context, string));
        aFf1pSDK.AFInAppEventType.put("api_ver_name", AFa1cSDK.values(context, string));
        switch (n) {
            case 0: {
                aFf1pSDK.AFInAppEventType.put("response", "OK");
                try {
                    com.appsflyer.AFLogger.afDebugLog("InstallReferrer connected");
                    if (installReferrerClient.isReady()) {
                        context = installReferrerClient.getInstallReferrer();
                        Object object = context.getInstallReferrer();
                        if (object != null) {
                            aFf1pSDK.AFKeystoreWrapper.put("val", object);
                            aFf1pSDK.AFInAppEventType.put("referrer", object);
                        }
                        long l = context.getReferrerClickTimestampSeconds();
                        aFf1pSDK.AFKeystoreWrapper.put("clk", Long.toString(l));
                        aFf1pSDK.AFInAppEventType.put("click_ts", l);
                        long l2 = context.getInstallBeginTimestampSeconds();
                        aFf1pSDK.AFKeystoreWrapper.put("install", Long.toString(l2));
                        aFf1pSDK.AFInAppEventType.put("install_begin_ts", l2);
                        object = new HashMap();
                        try {
                            boolean bl = context.getGooglePlayInstantParam();
                            aFf1pSDK.AFKeystoreWrapper.put("instant", bl);
                            ((AbstractMap)object).put("instant", bl);
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("getGooglePlayInstantParam not exist", noSuchMethodError);
                        }
                        try {
                            ((AbstractMap)object).put("click_server_ts", context.getReferrerClickTimestampServerSeconds());
                            ((AbstractMap)object).put("install_begin_server_ts", context.getInstallBeginTimestampServerSeconds());
                            ((AbstractMap)object).put("install_version", context.getInstallVersion());
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("some method not exist", noSuchMethodError);
                        }
                        if (((AbstractMap)object).isEmpty()) break;
                        aFf1pSDK.AFInAppEventType.put("google_custom", object);
                        break;
                    }
                    com.appsflyer.AFLogger.afWarnLog("ReferrerClient: InstallReferrer is not ready");
                    aFf1pSDK.AFKeystoreWrapper.put("err", "ReferrerClient: InstallReferrer is not ready");
                }
                catch (Throwable throwable) {
                    com.appsflyer.AFLogger.afWarnLog("Failed to get install referrer: " + throwable.getMessage());
                    aFf1pSDK.AFKeystoreWrapper.put("err", throwable.getMessage());
                    com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("Failed to get install referrer", throwable);
                }
                break;
            }
            case 2: {
                com.appsflyer.AFLogger.afWarnLog("InstallReferrer FEATURE_NOT_SUPPORTED");
                aFf1pSDK.AFInAppEventType.put("response", "FEATURE_NOT_SUPPORTED");
                break;
            }
            case 1: {
                aFf1pSDK.AFInAppEventType.put("response", "SERVICE_UNAVAILABLE");
                com.appsflyer.AFLogger.afWarnLog("InstallReferrer not supported");
                break;
            }
            case 3: {
                com.appsflyer.AFLogger.afWarnLog("InstallReferrer DEVELOPER_ERROR");
                aFf1pSDK.AFInAppEventType.put("response", "DEVELOPER_ERROR");
                break;
            }
            case -1: {
                com.appsflyer.AFLogger.afWarnLog("InstallReferrer SERVICE_DISCONNECTED");
                aFf1pSDK.AFInAppEventType.put("response", "SERVICE_DISCONNECTED");
                break;
            }
            default: {
                com.appsflyer.AFLogger.afWarnLog("responseCode not found.");
            }
        }
        com.appsflyer.AFLogger.afDebugLog("Install Referrer collected locally");
        aFf1pSDK.AFInAppEventType();
        installReferrerClient.endConnection();
    }
}

