/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.NonNull;
import com.appsflyer.AFLogger;
import com.appsflyer.internal.AFb1xSDK;
import com.appsflyer.internal.AFd1pSDK;
import com.appsflyer.internal.AFd1rSDK;
import com.appsflyer.internal.AFd1tSDK;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class AFd1eSDK
extends AFd1pSDK<Map<String, Object>> {
    private static final int afErrorLog = (int)TimeUnit.SECONDS.toMillis(2L);
    private Map<String, Object> afDebugLog;
    private final Context afRDLog;
    private final Map<String, Object> AFLogger;
    private final Uri afInfoLog;
    private final List<String> afErrorLogForExcManagerOnly;

    public AFd1eSDK(@NonNull Context context, @NonNull Map<String, Object> map, @NonNull Uri uri, @NonNull List<String> list) {
        super(AFd1rSDK.afDebugLog, new AFd1rSDK[]{AFd1rSDK.values}, "ResolveEsp");
        this.afRDLog = context;
        this.AFLogger = map;
        this.afInfoLog = uri;
        this.afErrorLogForExcManagerOnly = list;
    }

    @Override
    public final long valueOf() {
        return 60000L;
    }

    @Override
    public final boolean AFKeystoreWrapper() {
        return false;
    }

    @Override
    @NonNull
    public final AFd1tSDK AFInAppEventType() throws Exception {
        AFd1eSDK aFd1eSDK = this;
        if (!aFd1eSDK.AFInAppEventType(aFd1eSDK.afInfoLog.toString())) {
            AFb1xSDK.AFInAppEventType().values(this.afRDLog, this.AFLogger, this.afInfoLog);
            return AFd1tSDK.AFInAppEventType;
        }
        long l = System.currentTimeMillis();
        String string = this.afInfoLog.toString();
        Integer n = null;
        Map<String, Object> map = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            map = AFd1eSDK.values(Uri.parse((String)string));
            string = (String)map.get("res");
            n = (Integer)map.get("status");
            map = (String)map.get("error");
            if (string == null || !this.AFInAppEventType(string)) break;
            if (i >= 4) continue;
            ((AbstractCollection)arrayList).add(string);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("res", string != null ? string : "");
        hashMap.put("status", n != null ? n : -1);
        if (map != null) {
            hashMap.put("error", map);
        }
        if (!((AbstractCollection)arrayList).isEmpty()) {
            hashMap.put("redirects", arrayList);
        }
        hashMap.put("latency", System.currentTimeMillis() - l);
        map = this.AFLogger;
        synchronized (map) {
            this.AFLogger.put("af_deeplink_r", hashMap);
            this.AFLogger.put("af_deeplink", this.afInfoLog.toString());
        }
        AFb1xSDK.AFInAppEventType().values(this.afRDLog, this.AFLogger, string != null ? Uri.parse((String)string) : this.afInfoLog);
        this.afDebugLog = hashMap;
        return AFd1tSDK.AFInAppEventType;
    }

    private static Map<String, Object> values(Uri object) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            com.appsflyer.AFLogger.afDebugLog("ESP deeplink resolving is started: " + object.toString());
            object = (HttpURLConnection)new URL(object.toString()).openConnection();
            ((HttpURLConnection)object).setInstanceFollowRedirects(false);
            ((URLConnection)object).setReadTimeout(afErrorLog);
            ((URLConnection)object).setConnectTimeout(afErrorLog);
            ((URLConnection)object).setRequestProperty("User-agent", "Dalvik/2.1.0 (Linux; U; Android 6.0.1; Nexus 5 Build/M4B30Z)");
            ((URLConnection)object).setRequestProperty("af-esp", "6.10.2");
            int n = ((HttpURLConnection)object).getResponseCode();
            ((AbstractMap)hashMap).put("status", n);
            if (300 <= n && n <= 305) {
                ((AbstractMap)hashMap).put("res", ((URLConnection)object).getHeaderField("Location"));
            }
            ((HttpURLConnection)object).disconnect();
            com.appsflyer.AFLogger.afDebugLog("ESP deeplink resolving is finished");
        }
        catch (Throwable throwable) {
            ((AbstractMap)hashMap).put("error", throwable.getLocalizedMessage());
            com.appsflyer.AFLogger.afErrorLog(throwable.getMessage(), throwable);
        }
        return hashMap;
    }

    private boolean AFInAppEventType(String string) {
        if (string.contains("af_tranid=")) {
            return false;
        }
        com.appsflyer.AFLogger.afRDLog("Validate if link " + string + " belongs to ESP domains: " + this.afErrorLogForExcManagerOnly);
        try {
            return this.afErrorLogForExcManagerOnly.contains(new URL(string).getHost());
        }
        catch (MalformedURLException malformedURLException) {
            com.appsflyer.AFLogger.afErrorLogForExcManagerOnly("MalformedURLException ESP link", malformedURLException);
            return false;
        }
    }
}

