/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import com.appsflyer.AndroidUtils;
import com.appsflyer.AppsFlyerLibCore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public class EventDataCollector {
    private final Application \u03b9;
    private final SharedPreferences \u0269;

    public EventDataCollector(Context context) {
        this.\u03b9 = (Application)context.getApplicationContext();
        this.\u0269 = AppsFlyerLibCore.getSharedPreferences((Context)this.\u03b9);
    }

    public String signature() throws CertificateException, NoSuchAlgorithmException, PackageManager.NameNotFoundException {
        return AndroidUtils.signature(this.\u03b9.getPackageManager(), this.\u03b9.getPackageName());
    }

    public long bootTime() {
        return System.currentTimeMillis() - SystemClock.elapsedRealtime();
    }

    public String disk() {
        long l2;
        long l3;
        StatFs statFs = new StatFs(Environment.getDataDirectory().getAbsolutePath());
        if (Build.VERSION.SDK_INT >= 18) {
            long l4 = statFs.getBlockSizeLong();
            l3 = statFs.getAvailableBlocksLong() * l4;
            l2 = statFs.getBlockCountLong() * l4;
        } else {
            int n2 = statFs.getBlockSize();
            l3 = statFs.getAvailableBlocks() * n2;
            l2 = statFs.getBlockCount() * n2;
        }
        double d2 = Math.pow(2.0, 20.0);
        l3 = (long)((double)l3 / d2);
        l2 = (long)((double)l2 / d2);
        return l3 + "/" + l2;
    }

    public long getLong(String string) {
        return this.\u0269.getLong(string, 0L);
    }

    @Nullable
    public String getString(String string) {
        return this.\u0269.getString(string, null);
    }

    public void set(String string, long l2) {
        this.\u0269.edit().putLong(string, l2).apply();
    }

    public void set(String string, String string2) {
        this.\u0269.edit().putString(string, string2).apply();
    }

    public void init() {
        if (this.\u01c3()) {
            this.set("init_ts", System.currentTimeMillis());
        }
    }

    public void foreground() {
        if (this.\u01c3()) {
            this.set("fg_ts", System.currentTimeMillis());
        }
    }

    private boolean \u01c3() {
        return AppsFlyerLibCore.getInstance().getLaunchCounter(this.\u0269, false) == 0;
    }
}

