/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.deeplink;

import android.app.Application;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.Nullable;
import com.appsflyer.AFDateFormat;
import com.appsflyer.AFLogger;
import com.appsflyer.AdvertisingIdObject;
import com.appsflyer.AdvertisingIdUtil;
import com.appsflyer.AppsFlyerLibCore;
import com.appsflyer.AppsFlyerProperties;
import com.appsflyer.BackgroundHttpTask;
import com.appsflyer.HashUtils;
import com.appsflyer.ServerConfigHandler;
import com.appsflyer.deeplink.DeepLink;
import com.appsflyer.deeplink.DeepLinkCallbacks;
import com.appsflyer.deeplink.DeepLinkResult;
import com.appsflyer.internal.EventDataCollector;
import com.appsflyer.internal.model.event.BackgroundEvent;
import com.appsflyer.internal.referrer.Referrer;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DdlEvent
extends BackgroundEvent {
    public static String URL = "https://%sdlsdk.%s/v1.0/android/";
    public static long LISTENER_TIMEOUT = TimeUnit.SECONDS.toMillis(3L);
    private final List<Referrer> \u0196 = new ArrayList<Referrer>();
    private final CountDownLatch \u0456 = new CountDownLatch(1);
    private final EventDataCollector \u04cf;
    private final JSONObject \u0237 = new JSONObject();
    private int \u026a;
    private int \u027e;
    private boolean \u0268;
    private int \u0140;

    public DdlEvent(Context context, EventDataCollector eventDataCollector) {
        super(null, Boolean.FALSE, Boolean.TRUE, null, context);
        this.\u04cf = eventDataCollector;
    }

    public static void setUrl(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!entry.getKey().equals("dlsdk")) continue;
            URL = entry.getValue();
        }
    }

    public void start() {
        AFLogger.afDebugLog("[DDL] start");
        FutureTask<DeepLinkResult> futureTask = new FutureTask<DeepLinkResult>(new Callable<DeepLinkResult>(this){
            private /* synthetic */ DdlEvent \u01c3;
            {
                this.\u01c3 = ddlEvent;
            }

            @Override
            public final /* synthetic */ Object call() throws Exception {
                4 var1_1 = this;
                Application application = var1_1.\u01c3.context();
                DdlEvent.\u01c3(var1_1.\u01c3);
                var1_1.\u01c3.\u03b9((Context)application);
                return DdlEvent.\u03b9(var1_1.\u01c3, (Context)application);
            }
        });
        new Thread(futureTask).start();
        try {
            DeepLinkResult deepLinkResult = futureTask.get(LISTENER_TIMEOUT, TimeUnit.MILLISECONDS);
            this.\u0399(deepLinkResult);
            return;
        }
        catch (InterruptedException | ExecutionException exception) {
            AFLogger.afErrorLog("[DDL] Error occurred", exception, true);
            DeepLinkResult deepLinkResult = new DeepLinkResult(null, exception.getCause() instanceof IOException ? DeepLinkResult.Error.NETWORK : DeepLinkResult.Error.UNEXPECTED);
            this.\u0399(deepLinkResult);
            return;
        }
        catch (TimeoutException timeoutException) {
            AFLogger.afDebugLog("[DDL] Timeout, didn't manage to find deferred deep link after " + this.\u027e + " attempt(s) within " + LISTENER_TIMEOUT + " milliseconds");
            this.\u0399(new DeepLinkResult(null, DeepLinkResult.Error.TIMEOUT));
            return;
        }
    }

    private void \u0399(DeepLinkResult deepLinkResult) {
        try {
            this.\u0237.put("status", (Object)((Object)((Object)deepLinkResult.getStatus())).toString());
            this.\u0237.put("timeout_value", LISTENER_TIMEOUT);
        }
        catch (JSONException jSONException) {}
        this.\u04cf.set("ddl", this.\u0237.toString());
        AppsFlyerLibCore.getSharedPreferences((Context)this.context()).edit().putBoolean("ddl_sent", true).apply();
        DeepLinkCallbacks.\u03b9(deepLinkResult);
    }

    @Nullable
    private static Map<String, Object> \u03b9(AdvertisingIdObject advertisingIdObject) {
        boolean bl = false;
        if (advertisingIdObject != null && advertisingIdObject.getAdvertisingId() != null) {
            Boolean bl2 = advertisingIdObject.isLimitAdTracking();
            boolean bl3 = bl = bl2 == null || bl2 == false;
        }
        if (bl) {
            return new HashMap<String, Object>(advertisingIdObject){
                private /* synthetic */ AdvertisingIdObject \u03b9;
                {
                    this.\u03b9 = advertisingIdObject;
                    ((AbstractMap)this).put("type", "unhashed");
                    ((AbstractMap)this).put("value", this.\u03b9.getAdvertisingId());
                }
            };
        }
        return null;
    }

    private boolean \u0131() {
        List list = (List)this.params.get("referrers");
        int n2 = 0;
        if (list != null) {
            n2 = list.size();
        }
        return n2 < this.\u0140 && !this.params.containsKey("referrers");
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void \u03b9(Context var1_1) throws NoSuchAlgorithmException, InvalidKeyException {
        ++this.\u027e;
        AFLogger.afDebugLog("[DDL] Preparing request " + this.\u027e);
        if (this.\u027e == 1) {
            var2_2 = AppsFlyerLibCore.getInstance();
            this.params.put("is_first", var2_2.isAppsFlyerFirstLaunch(var1_1));
            this.params.put("lang", Locale.getDefault().getLanguage() + "-" + Locale.getDefault().getCountry());
            this.params.put("os", Build.VERSION.RELEASE);
            this.params.put("type", Build.MODEL);
            this.params.put("request_id", var2_2.getAppsFlyerUID(var1_1));
            var3_3 = var2_2.sharingFilter;
            if (var2_2.sharingFilter != null) {
                this.params.put("sharing_filter", var3_3);
            }
            var4_4 = DdlEvent.\u03b9(AdvertisingIdUtil.getGaid(var1_1, new HashMap<String, Object>()));
            var5_5 = DdlEvent.\u03b9(AdvertisingIdUtil.getOaid(var1_1));
            if (var4_4 != null) {
                this.params.put("gaid", var4_4);
            }
            if (var5_5 != null) {
                this.params.put("oaid", var5_5);
            }
        }
        this.params.put("timestamp", AFDateFormat.dateFormatUTC(AFDateFormat.getDataFormatter("yyyy-MM-dd'T'HH:mm:ss.SSS"), System.currentTimeMillis()));
        this.params.put("request_count", this.\u027e);
        var2_2 = new ArrayList<E>();
        for (Object var6_6 : this.\u0196) {
            if (var6_6.getState() != Referrer.State.FINISHED) ** GOTO lbl-1000
            var7_7 = new HashMap<K, V>();
            var8_8 = (String)var6_6.map.get("referrer");
            if (var8_8 != null) {
                var7_7.put("source", (String)var6_6.map.get("source"));
                var7_7.put("value", var8_8);
                v0 = var7_7;
            } else lbl-1000:
            // 2 sources

            {
                v0 = var5_5 = null;
            }
            if (v0 == null) continue;
            var2_2.add(var5_5);
        }
        if (!var2_2.isEmpty()) {
            this.params.put("referrers", var2_2);
        }
        var7_7 = var1_1;
        var6_6 = this;
        v1 = Uri.parse((String)ServerConfigHandler.getUrl(DdlEvent.URL)).buildUpon().appendPath(var7_7.getPackageName());
        var8_8 = (String)var6_6.params.get("timestamp");
        var9_9 = AppsFlyerProperties.getInstance().getString("AppsFlyerKey").getBytes();
        var10_10 = Mac.getInstance("HmacSHA256");
        var10_10.init(new SecretKeySpec(var9_9, "HmacSHA256"));
        var11_11 = var8_8 + AppsFlyerProperties.getInstance().getString("AppsFlyerKey");
        var6_6.urlString(v1.appendQueryParameter("af_sig", HashUtils.bytesToHex(var10_10.doFinal(var11_11.getBytes())).toLowerCase()).appendQueryParameter("sdk_version", AppsFlyerLibCore.SERVER_BUILD_NUMBER).build().toString());
    }

    private void \u01c3(Referrer referrer) {
        if (DdlEvent.\u0131(referrer)) {
            this.\u0196.add(referrer);
            this.\u0456.countDown();
            AFLogger.afDebugLog("[DDL] Added non-organic " + referrer.getClass().getSimpleName());
            return;
        }
        if (++this.\u026a == this.\u0140) {
            this.\u0456.countDown();
        }
    }

    private static boolean \u0131(Referrer referrer) {
        Long l2 = (Long)referrer.map.get("click_ts");
        if (l2 == null) {
            return false;
        }
        return System.currentTimeMillis() - TimeUnit.SECONDS.toMillis(l2) < TimeUnit.DAYS.toMillis(1L);
    }

    static /* synthetic */ void \u01c3(DdlEvent ddlEvent) {
        DdlEvent ddlEvent2 = ddlEvent;
        ArrayList<Referrer> arrayList = new ArrayList<Referrer>();
        AppsFlyerLibCore appsFlyerLibCore = AppsFlyerLibCore.getInstance();
        arrayList.add(appsFlyerLibCore.googleReferrer);
        arrayList.add(appsFlyerLibCore.huaweiReferrer);
        arrayList.add(appsFlyerLibCore.samsungReferrer);
        ArrayList<Referrer> arrayList2 = new ArrayList<Referrer>();
        for (Referrer referrer : arrayList) {
            if (referrer == null || referrer.getState() == Referrer.State.NOT_STARTED) continue;
            arrayList2.add(referrer);
        }
        ddlEvent2.\u0140 = arrayList2.size();
        for (Referrer referrer : arrayList2) {
            switch (referrer.getState()) {
                case FINISHED: {
                    AFLogger.afDebugLog("[DDL] " + referrer.map.get("source") + " referrer collected earlier");
                    ddlEvent2.\u01c3(referrer);
                    break;
                }
                case STARTED: {
                    referrer.addObserver(new Observer(ddlEvent2, referrer){
                        private /* synthetic */ Referrer \u01c3;
                        private /* synthetic */ DdlEvent \u0399;
                        {
                            this.\u0399 = ddlEvent;
                            this.\u01c3 = referrer;
                        }

                        @Override
                        public final void update(Observable observable, Object object) {
                            AFLogger.afDebugLog("[DDL] " + this.\u01c3.map.get("source") + " referrer collected via observer");
                            this.\u0399.\u01c3((Referrer)observable);
                        }
                    });
                }
            }
        }
    }

    static /* synthetic */ DeepLinkResult \u03b9(DdlEvent ddlEvent, Context context) throws IOException, JSONException, InterruptedException, NoSuchAlgorithmException, InvalidKeyException {
        HttpURLConnection httpURLConnection;
        block7: {
            Object object = context;
            DdlEvent ddlEvent2 = ddlEvent;
            while (true) {
                DeepLink deepLink;
                DeepLink deepLink2;
                long l2 = System.currentTimeMillis();
                if (ddlEvent2.\u027e == 1) {
                    ddlEvent2.\u0237.put("from_fg", l2 - ddlEvent2.\u04cf.getLong("fg_ts"));
                }
                httpURLConnection = new BackgroundHttpTask(ddlEvent2).doInBackground();
                JSONArray jSONArray = ddlEvent2.\u0237.optJSONArray("net");
                if (jSONArray == null) {
                    jSONArray = new JSONArray();
                }
                jSONArray.put(ddlEvent2.\u027e - 1, System.currentTimeMillis() - l2);
                ddlEvent2.\u0237.put("net", (Object)jSONArray);
                if (httpURLConnection.getResponseCode() != 200) break block7;
                HttpURLConnection httpURLConnection2 = httpURLConnection;
                DdlEvent ddlEvent3 = ddlEvent2;
                String string = AppsFlyerLibCore.getInstance().readServerResponse(httpURLConnection2);
                JSONObject jSONObject = new JSONObject(string);
                ddlEvent3.\u0268 = jSONObject.optBoolean("is_second_ping", true);
                if (!jSONObject.optBoolean("found")) {
                    deepLink2 = null;
                } else {
                    DeepLink deepLink3 = DeepLink.\u03b9(jSONObject.optJSONObject("click_event"));
                    deepLink3.\u0269.put("is_deferred", true);
                    deepLink2 = deepLink = deepLink3;
                }
                if (deepLink2 != null) {
                    return new DeepLinkResult(deepLink, null);
                }
                if (ddlEvent2.\u027e > 1 || !ddlEvent2.\u0131() || !ddlEvent2.\u0268) break;
                httpURLConnection2 = object;
                ddlEvent3 = ddlEvent2;
                AFLogger.afDebugLog("[DDL] Waiting for referrers...");
                ddlEvent3.\u0456.await();
                if (ddlEvent3.\u026a == ddlEvent3.\u0140) {
                    return new DeepLinkResult(null, null);
                }
                ddlEvent3.\u03b9((Context)httpURLConnection2);
                object = httpURLConnection2;
                ddlEvent2 = ddlEvent3;
            }
            return new DeepLinkResult(null, null);
        }
        AFLogger.afDebugLog("[DDL] Error occurred. Server response code = " + httpURLConnection.getResponseCode());
        return new DeepLinkResult(null, DeepLinkResult.Error.HTTP_STATUS_CODE);
    }
}

