/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.net.Uri;
import android.os.Build;
import android.os.Process;
import com.appsflyer.AFLogger;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class AndroidUtils {
    public static boolean \u0131(Context context, Intent intent) {
        return context.getPackageManager().queryIntentServices(intent, 0).size() > 0;
    }

    public static boolean isPermissionAvailable(Context context, String string) {
        if (string == null) {
            throw new IllegalArgumentException("permission is null");
        }
        int n2 = context.checkPermission(string, Process.myPid(), Process.myUid());
        AFLogger.afRDLog("is Permission Available: " + string + "; res: " + n2);
        return n2 == 0;
    }

    static boolean \u0399() {
        return Build.BRAND.equals("OPPO");
    }

    static Map<String, String> \u01c3(Context context, Map<String, String> map, Uri uri) {
        Map<String, String> map2;
        boolean bl = false;
        if (uri.getEncodedQuery() != null) {
            for (String string : uri.getEncodedQuery().split("&")) {
                String string2;
                int n2 = string.indexOf("=");
                String string3 = string2 = n2 > 0 ? string.substring(0, n2) : string;
                if (!map.containsKey(string2)) {
                    if (string2.equals("c")) {
                        string2 = "campaign";
                    } else if (string2.equals("pid")) {
                        string2 = "media_source";
                    } else if (string2.equals("af_prt")) {
                        bl = true;
                        string2 = "agency";
                    }
                    map.put(string2, "");
                }
                String string4 = n2 > 0 && string.length() > n2 + 1 ? string.substring(n2 + 1) : null;
                map.put(string2, string4);
            }
        }
        try {
            if (!map.containsKey("install_time")) {
                PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
                map2 = "yyyy-MM-dd HH:mm:ss";
                long l = packageInfo.firstInstallTime;
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat((String)((Object)map2), Locale.US);
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                map.put("install_time", simpleDateFormat.format(new Date(l)));
            }
        }
        catch (Exception exception) {
            AFLogger.afErrorLog("Could not fetch install time. ", exception);
        }
        if (uri.getQueryParameter("af_deeplink") != null && !map.containsKey("af_status")) {
            map.put("af_status", "Non-organic");
        }
        if (bl) {
            map.remove("media_source");
        }
        String string = uri.getPath();
        String string5 = "path";
        map2 = map;
        if (string != null) {
            map2.put(string5, string);
        }
        string = uri.getScheme();
        string5 = "scheme";
        map2 = map;
        if (string != null) {
            map2.put(string5, string);
        }
        string = uri.getHost();
        string5 = "host";
        map2 = map;
        if (string != null) {
            map2.put(string5, string);
        }
        return map;
    }

    public static String signature(PackageManager packageManager, String string) throws PackageManager.NameNotFoundException, CertificateException, NoSuchAlgorithmException {
        Signature[] signatureArray = packageManager.getPackageInfo((String)string, (int)64).signatures;
        if (packageManager.getPackageInfo((String)string, (int)64).signatures == null) {
            return null;
        }
        X509Certificate x509Certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(signatureArray[0].toByteArray()));
        MessageDigest messageDigest = MessageDigest.getInstance("SHA256");
        messageDigest.update(x509Certificate.getEncoded());
        return String.format("%032X", new BigInteger(1, messageDigest.digest()));
    }

    public static long getVersionCode(Context context, String string) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(string, 0);
            if (Build.VERSION.SDK_INT >= 28) {
                return packageInfo.getLongVersionCode();
            }
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            PackageManager.NameNotFoundException nameNotFoundException2 = nameNotFoundException;
            AFLogger.afErrorLog(nameNotFoundException.getMessage(), nameNotFoundException2);
            return 0L;
        }
    }

    public static String getVersionName(Context context, String string) {
        try {
            return context.getPackageManager().getPackageInfo((String)string, (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            PackageManager.NameNotFoundException nameNotFoundException2 = nameNotFoundException;
            AFLogger.afErrorLog(nameNotFoundException.getMessage(), nameNotFoundException2);
            return "";
        }
    }
}

