/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal.referrer;

import android.content.Context;
import android.support.annotation.NonNull;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.android.installreferrer.api.ReferrerDetails;
import com.appsflyer.AFLogger;
import com.appsflyer.AndroidUtils;
import com.appsflyer.AppsFlyerLibCore;
import com.appsflyer.internal.referrer.MandatoryFields;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;

public class GoogleReferrer {
    public final Map<String, Object> oldMap = new HashMap<String, Object>();
    public final Map<String, Object> newMap = new HashMap<String, Object>();

    public static boolean allow(@NonNull AppsFlyerLibCore appsFlyerLibCore, @NonNull Context context) {
        if (appsFlyerLibCore.getLaunchCounter(AppsFlyerLibCore.getSharedPreferences(context), false) > 2) {
            AFLogger.afRDLog("Install referrer will not load, the counter > 2, ");
            return false;
        }
        String string = "com.android.installreferrer.api.InstallReferrerClient";
        try {
            Class.forName(string);
            if (AndroidUtils.isPermissionAvailable(context, "com.google.android.finsky.permission.BIND_GET_INSTALL_REFERRER_SERVICE")) {
                AFLogger.afDebugLog("Install referrer is allowed");
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            AFLogger.afRDLog("Class " + string + " not found");
            return false;
        }
        catch (Throwable throwable) {
            AFLogger.afErrorLog("An error occurred while trying to verify manifest : ".concat(String.valueOf(string)), throwable);
            return false;
        }
        AFLogger.afDebugLog("Install referrer is not allowed");
        return false;
    }

    public void start(Context context, @NonNull Runnable runnable) {
        try {
            InstallReferrerClient installReferrerClient = InstallReferrerClient.newBuilder((Context)context).build();
            AFLogger.afDebugLog("Connecting to Install Referrer Library...");
            installReferrerClient.startConnection(new InstallReferrerStateListener(this, context, installReferrerClient, runnable){
                private /* synthetic */ Context \u01c3;
                private /* synthetic */ InstallReferrerClient \u0269;
                private /* synthetic */ Runnable \u0131;
                private /* synthetic */ GoogleReferrer \u0399;
                {
                    this.\u0399 = googleReferrer;
                    this.\u01c3 = context;
                    this.\u0269 = installReferrerClient;
                    this.\u0131 = runnable;
                }

                public final void onInstallReferrerSetupFinished(int n2) {
                    this.\u0399.oldMap.put("code", String.valueOf(n2));
                    this.\u0399.newMap.put("source", "google");
                    String string = "com.android.vending";
                    this.\u0399.newMap.put("api_ver", AndroidUtils.getVersionCode(this.\u01c3, string));
                    this.\u0399.newMap.put("api_ver_name", AndroidUtils.getVersionName(this.\u01c3, string));
                    this.\u0399.newMap.putAll(new MandatoryFields());
                    switch (n2) {
                        case 0: {
                            this.\u0399.newMap.put("response", "OK");
                            try {
                                AFLogger.afDebugLog("InstallReferrer connected");
                                if (this.\u0269.isReady()) {
                                    ReferrerDetails referrerDetails = this.\u0269.getInstallReferrer();
                                    String string2 = referrerDetails.getInstallReferrer();
                                    if (string2 != null) {
                                        this.\u0399.oldMap.put("val", string2);
                                        this.\u0399.newMap.put("referrer", string2);
                                    }
                                    long l = referrerDetails.getReferrerClickTimestampSeconds();
                                    this.\u0399.oldMap.put("clk", Long.toString(l));
                                    this.\u0399.newMap.put("click_ts", l);
                                    long l2 = referrerDetails.getInstallBeginTimestampSeconds();
                                    this.\u0399.oldMap.put("install", Long.toString(l2));
                                    this.\u0399.newMap.put("install_begin_ts", l2);
                                    try {
                                        boolean bl = referrerDetails.getGooglePlayInstantParam();
                                        this.\u0399.oldMap.put("instant", bl);
                                        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
                                        ((AbstractMap)hashMap).put("instant", bl);
                                        this.\u0399.newMap.put("google_custom", hashMap);
                                    }
                                    catch (NoSuchMethodError noSuchMethodError) {}
                                    break;
                                }
                                AFLogger.afWarnLog("ReferrerClient: InstallReferrer is not ready");
                                this.\u0399.oldMap.put("err", "ReferrerClient: InstallReferrer is not ready");
                            }
                            catch (Throwable throwable) {
                                AFLogger.afWarnLog("Failed to get install referrer: " + throwable.getMessage());
                                this.\u0399.oldMap.put("err", throwable.getMessage());
                            }
                            break;
                        }
                        case 2: {
                            AFLogger.afWarnLog("InstallReferrer FEATURE_NOT_SUPPORTED");
                            this.\u0399.newMap.put("response", "FEATURE_NOT_SUPPORTED");
                            break;
                        }
                        case 1: {
                            this.\u0399.newMap.put("response", "SERVICE_UNAVAILABLE");
                            AFLogger.afWarnLog("InstallReferrer not supported");
                            break;
                        }
                        case 3: {
                            AFLogger.afWarnLog("InstallReferrer DEVELOPER_ERROR");
                            this.\u0399.newMap.put("response", "DEVELOPER_ERROR");
                            break;
                        }
                        case -1: {
                            AFLogger.afWarnLog("InstallReferrer SERVICE_DISCONNECTED");
                            this.\u0399.newMap.put("response", "SERVICE_DISCONNECTED");
                            break;
                        }
                        default: {
                            AFLogger.afWarnLog("responseCode not found.");
                        }
                    }
                    AFLogger.afDebugLog("Install Referrer collected locally");
                    this.\u0131.run();
                    this.\u0269.endConnection();
                }

                public final void onInstallReferrerServiceDisconnected() {
                    AFLogger.afDebugLog("Install Referrer service disconnected");
                }
            });
            return;
        }
        catch (Throwable throwable) {
            AFLogger.afErrorLog("referrerClient -> startConnection", throwable);
            return;
        }
    }
}

