/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import com.appsflyer.AFLogger;
import com.appsflyer.AppsFlyerLib;
import com.appsflyer.AppsFlyerProperties;
import com.appsflyer.OneLinkHttpTask;
import com.appsflyer.ServerConfigHandler;
import com.appsflyer.share.LinkGenerator;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class CreateOneLinkHttpTask
extends OneLinkHttpTask {
    private ResponseListener responseListener;
    private Map<String, String> data;
    private String ttl;
    private String packageName = "";
    private Context context;

    /*
     * WARNING - void declaration
     */
    public CreateOneLinkHttpTask(@NonNull String oneLinkId, @NonNull Map<String, String> data, AppsFlyerLib afLib, @NonNull Context context) {
        super((AppsFlyerLib)var3_3);
        void var2_2;
        void var1_1;
        void var3_3;
        this.context = context;
        if (this.context != null) {
            this.packageName = context.getPackageName();
        } else {
            AFLogger.afWarnLog("CreateOneLinkHttpTask: context can't be null");
        }
        this.oneLinkId = var1_1;
        this.ttl = "-1";
        this.data = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void setListener(@NonNull ResponseListener responseListener) {
        void var1_1;
        this.responseListener = var1_1;
    }

    @Override
    void initRequest(HttpsURLConnection conn) throws JSONException, IOException {
        DataOutputStream dataOutputStream;
        conn.setRequestMethod("POST");
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = new JSONObject(this.data);
        jSONObject.put("ttl", (Object)this.ttl);
        jSONObject.put("data", (Object)jSONObject2);
        conn.connect();
        dataOutputStream = new DataOutputStream(((URLConnection)((Object)dataOutputStream)).getOutputStream());
        dataOutputStream.writeBytes(jSONObject.toString());
        dataOutputStream.flush();
        dataOutputStream.close();
    }

    @Override
    String getOneLinkUrl() {
        return ServerConfigHandler.getUrl("https://onelink.%s/shortlink-sdk/v1") + "/" + this.oneLinkId;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void handleResponse(String content) {
        try {
            JSONObject jSONObject = new JSONObject(content);
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.responseListener.onResponse(jSONObject.optString(string));
            }
            return;
        }
        catch (JSONException jSONException) {
            void var1_1;
            this.responseListener.onResponseError("Can't parse one link data");
            AFLogger.afErrorLog("Error while parsing to json " + (String)var1_1, jSONException);
            return;
        }
    }

    @Override
    void onErrorResponse() {
        String string = AppsFlyerProperties.getInstance().getString("onelinkDomain");
        string = new LinkGenerator("af_app_invites").setBaseURL(this.oneLinkId, string, this.packageName).addParameter("af_siteid", this.packageName).addParameters(this.data).generateLink();
        this.responseListener.onResponse(string);
    }

    public static interface ResponseListener {
        @WorkerThread
        public void onResponse(String var1);

        @WorkerThread
        public void onResponseError(String var1);
    }
}

