/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.cache;

import android.content.Context;
import android.util.Log;
import com.appsflyer.cache.RequestCacheData;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class CacheManager {
    public static final int CACHE_MAX_SIZE = 40;
    public static final String AF_CACHE_DIR = "AFRequestCache";
    private static CacheManager ourInstance = new CacheManager();

    public static CacheManager getInstance() {
        return ourInstance;
    }

    private CacheManager() {
    }

    /*
     * WARNING - void declaration
     */
    private File getCacheDir(Context context) {
        void var1_1;
        return new File(var1_1.getFilesDir(), AF_CACHE_DIR);
    }

    /*
     * WARNING - void declaration
     */
    public void init(Context context) {
        try {
            if (!this.getCacheDir(context).exists()) {
                void var1_1;
                this.getCacheDir((Context)var1_1).mkdir();
            }
            return;
        }
        catch (Exception exception) {
            Log.i((String)"AppsFlyer_4.7.3", (String)"Could not create cache directory");
            return;
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public void cacheRequest(RequestCacheData data, Context context) {
        void var1_1;
        File file;
        OutputStreamWriter outputStreamWriter = null;
        File[] fileArray = this.getCacheDir(context);
        if (!fileArray.exists()) {
            fileArray.mkdir();
            return;
        }
        if ((fileArray = fileArray.listFiles()) != null && fileArray.length > 40) {
            Log.i((String)"AppsFlyer_4.7.3", (String)"reached cache limit, not caching request");
            return;
        }
        Log.i((String)"AppsFlyer_4.7.3", (String)"caching request...");
        file = new File(this.getCacheDir((Context)file), Long.toString(System.currentTimeMillis()));
        file.createNewFile();
        outputStreamWriter = new OutputStreamWriter(new FileOutputStream(file.getPath(), true));
        outputStreamWriter.write("version=");
        outputStreamWriter.write(data.getVersion());
        outputStreamWriter.write(10);
        outputStreamWriter.write("url=");
        outputStreamWriter.write(data.getRequestURL());
        outputStreamWriter.write(10);
        outputStreamWriter.write("data=");
        outputStreamWriter.write(var1_1.getPostData());
        outputStreamWriter.write(10);
        outputStreamWriter.flush();
        try {
            outputStreamWriter.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
        catch (Exception exception) {
            try {
                Log.i((String)"AppsFlyer_4.7.3", (String)"Could not cache request");
            }
            catch (Throwable throwable) {
                try {
                    if (outputStreamWriter != null) {
                        outputStreamWriter.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    public List<RequestCacheData> getCachedRequests(Context context) {
        ArrayList<RequestCacheData> arrayList = new ArrayList<RequestCacheData>();
        try {
            File[] fileArray;
            fileArray = this.getCacheDir((Context)fileArray);
            if (!fileArray.exists()) {
                fileArray.mkdir();
            } else {
                File[] fileArray2 = fileArray.listFiles();
                fileArray = fileArray2;
                fileArray = fileArray2;
                int n = fileArray2.length;
                for (int i2 = 0; i2 < n; ++i2) {
                    File file = fileArray[i2];
                    Log.i((String)"AppsFlyer_4.7.3", (String)("Found cached request" + file.getName()));
                    arrayList.add(this.loadRequestData(file));
                }
            }
        }
        catch (Exception exception) {
            Log.i((String)"AppsFlyer_4.7.3", (String)"Could not cache request");
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RequestCacheData loadRequestData(File file) {
        Object object;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            Object object2 = new char[(int)file.length()];
            fileReader.read((char[])object2);
            RequestCacheData requestCacheData = new RequestCacheData((char[])object2);
            object2 = requestCacheData;
            requestCacheData.setCacheKey(object.getName());
            object = object2;
        }
        catch (Exception exception) {
            try {
                if (fileReader == null) return null;
                fileReader.close();
                return null;
            }
            catch (IOException iOException) {}
            return null;
        }
        catch (Throwable throwable) {
            try {
                if (fileReader == null) throw throwable;
                fileReader.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            fileReader.close();
            return object;
        }
        catch (IOException iOException) {}
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public void deleteRequest(String cacheKey, Context context) {
        File file;
        file = this.getCacheDir((Context)file);
        file = new File(file, cacheKey);
        Log.i((String)"AppsFlyer_4.7.3", (String)("Deleting " + cacheKey + " from cache"));
        if (file.exists()) {
            try {
                file.delete();
                return;
            }
            catch (Exception exception) {
                void var1_1;
                Log.i((String)"AppsFlyer_4.7.3", (String)("Could not delete " + (String)var1_1 + " from cache"), (Throwable)exception);
            }
        }
    }
}

