/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.content.Context;
import com.appsflyer.AFLogger;
import com.appsflyer.AFUninstallToken;
import com.appsflyer.AppsFlyerProperties;
import com.appsflyer.UninstallUtils;
import com.google.android.gms.iid.InstanceID;
import com.google.android.gms.iid.InstanceIDListenerService;

public class GcmInstanceIdListener
extends InstanceIDListenerService {
    public void onTokenRefresh() {
        super.onTokenRefresh();
        String gcmProjectNumber = AppsFlyerProperties.getInstance().getString("gcmProjectNumber");
        String refreshedToken = null;
        long tokenTimestamp = System.currentTimeMillis();
        try {
            refreshedToken = InstanceID.getInstance((Context)this.getApplicationContext()).getToken(gcmProjectNumber, "GCM", null);
        }
        catch (Throwable t) {
            AFLogger.afLogE("Error registering for uninstall tracking", t);
        }
        if (refreshedToken != null) {
            AFLogger.afLog("GCM Refreshed Token = " + refreshedToken);
            String tokenString = AppsFlyerProperties.getInstance().getString("afUninstallToken");
            AFUninstallToken existingAFUninstallToken = AFUninstallToken.parse(tokenString);
            AFUninstallToken newGcmToken = new AFUninstallToken(tokenTimestamp, refreshedToken);
            if (existingAFUninstallToken != null && existingAFUninstallToken.testAndUpdate(newGcmToken)) {
                UninstallUtils.updateServerUninstallToken(this.getApplicationContext(), newGcmToken);
            }
        }
    }
}

