/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.content.Context;
import android.os.AsyncTask;
import com.appsflyer.AFLogger;
import com.appsflyer.AppsFlyerLib;
import com.appsflyer.LogMessages;
import com.appsflyer.RemoteDebuggingManager;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONObject;

class BackgroundHttpTask
extends AsyncTask<String, Void, String> {
    private static final int WAIT_TIMEOUT = 30000;
    private String content = "";
    private boolean error = false;
    Map<String, String> bodyParameters;
    String bodyAsString;
    private Context mContext;
    private URL url;
    private boolean remoteDebugMode;
    private HttpURLConnection conn;
    private boolean shouldReadResponse;

    public BackgroundHttpTask(Context context) {
        this.mContext = context;
        this.remoteDebugMode = true;
        this.shouldReadResponse = true;
    }

    protected void onPreExecute() {
        JSONObject jsonObject;
        if (this.bodyAsString == null && (jsonObject = new JSONObject(this.bodyParameters)) != null) {
            this.bodyAsString = jsonObject.toString();
        }
    }

    protected String doInBackground(String ... urls) {
        try {
            this.url = new URL(urls[0]);
            if (this.remoteDebugMode) {
                RemoteDebuggingManager.getInstance().addServerRequestEvent(this.url.toString(), this.bodyAsString);
            }
            int sizeOfBody = this.bodyAsString.getBytes("UTF-8").length;
            LogMessages.logMessageMaskKey("call = " + this.url + "; size = " + sizeOfBody + " byte" + (sizeOfBody > 1 ? "s" : "") + "; body = " + this.bodyAsString);
            this.conn = (HttpsURLConnection)this.url.openConnection();
            this.conn.setReadTimeout(30000);
            this.conn.setConnectTimeout(30000);
            this.conn.setRequestMethod("POST");
            this.conn.setDoInput(true);
            this.conn.setDoOutput(true);
            this.conn.setRequestProperty("Content-Type", "application/json");
            OutputStream os = this.conn.getOutputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
            writer.write(this.bodyAsString);
            writer.flush();
            writer.close();
            os.close();
            this.conn.connect();
            int responseCode = this.conn.getResponseCode();
            if (this.shouldReadResponse) {
                this.content = AppsFlyerLib.getInstance().readServerResponse(this.conn);
            }
            if (this.remoteDebugMode) {
                RemoteDebuggingManager.getInstance().addServerResponseEvent(this.url.toString(), responseCode, this.content);
            }
            if (responseCode == 200) {
                AFLogger.afLog("Status 200 ok");
            } else {
                this.error = true;
            }
        }
        catch (Throwable t) {
            AFLogger.afLogE("Error while calling " + this.url.toString(), t);
            this.error = true;
        }
        return this.content;
    }

    protected void onCancelled() {
    }

    protected void onPostExecute(String response) {
        if (this.error) {
            AFLogger.afLog("Connection error: " + response);
            return;
        }
        AFLogger.afLog("Connection call succeeded: " + response);
    }

    public void setRemoteDebugMode(boolean remoteDebugMode) {
        this.remoteDebugMode = remoteDebugMode;
    }

    public HttpURLConnection getConnection() {
        return this.conn;
    }

    public void setShouldReadResponse(boolean shouldReadResponse) {
        this.shouldReadResponse = shouldReadResponse;
    }
}

