/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.os.Process;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import com.appsflyer.AFKeystoreWrapper;
import com.appsflyer.AFLogger;
import com.appsflyer.AFUninstallToken;
import com.appsflyer.AFValidateInAppPurchase;
import com.appsflyer.AdvertisingIdObject;
import com.appsflyer.AdvertisingIdUtil;
import com.appsflyer.AppsFlyerConversionListener;
import com.appsflyer.AppsFlyerInAppPurchaseValidatorListener;
import com.appsflyer.AppsFlyerProperties;
import com.appsflyer.AttributionIDNotReady;
import com.appsflyer.BackgroundHttpTask;
import com.appsflyer.ConversionDataListener;
import com.appsflyer.DebugLogQueue;
import com.appsflyer.Foreground;
import com.appsflyer.HashUtils;
import com.appsflyer.Installation;
import com.appsflyer.LogMessages;
import com.appsflyer.RemoteDebuggingManager;
import com.appsflyer.UninstallUtils;
import com.appsflyer.cache.CacheManager;
import com.appsflyer.cache.RequestCacheData;
import com.google.android.gms.common.GoogleApiAvailability;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AppsFlyerLib {
    static final String JENKINS_BUILD_NUMBER = "314";
    static final String BUILD_NUMBER = "4.7.1";
    private static final String SERVER_BUILD_NUMBER = "4.7.1".substring(0, "4.7.1".indexOf("."));
    public static final String LOG_TAG = "AppsFlyer_4.7.1";
    public static final String APPS_TRACKING_URL = "https://t.appsflyer.com/api/v" + SERVER_BUILD_NUMBER + "/androidevent?buildnumber=" + "4.7.1" + "&app_id=";
    public static final String EVENTS_TRACKING_URL = "https://events.appsflyer.com/api/v" + SERVER_BUILD_NUMBER + "/androidevent?buildnumber=" + "4.7.1" + "&app_id=";
    private static final String REGISTER_URL = "https://register.appsflyer.com/api/v" + SERVER_BUILD_NUMBER + "/androidevent?buildnumber=" + "4.7.1" + "&app_id=";
    private static final String STATS_URL = "https://stats.appsflyer.com/stats";
    static final String RD_BACKEND_URL = "https://monitorsdk.appsflyer.com/remote-debug?app_id=";
    static final String VALIDATE_URL = "https://sdk-services.appsflyer.com/validate-android-signature";
    static final String VALIDATE_WH_URL = "https://validate.appsflyer.com/api/v" + SERVER_BUILD_NUMBER + "/androidevent?buildnumber=" + "4.7.1" + "&app_id=";
    private static final String CONVERSION_DATA_URL = "https://api.appsflyer.com/install_data/v3/";
    static final String INSTALL_UPDATE_DATE_FORMAT = "yyyy-MM-dd_HHmmssZ";
    static final String AF_SHARED_PREF = "appsflyer-data";
    static final String SENT_SUCCESSFULLY_PREF = "sentSuccessfully";
    static final String AF_COUNTER_PREF = "appsFlyerCount";
    static final String AF_EVENT_COUNTER_PREF = "appsFlyerInAppEventCount";
    static final String AF_TIME_PASSED_SINCE_LAST_LAUNCH = "AppsFlyerTimePassedSincePrevLaunch";
    static final String FIRST_INSTALL_PREF = "appsFlyerFirstInstall";
    static final String REFERRER_PREF = "referrer";
    static final String EXTRA_REFERRERS_PREF = "extraReferrers";
    static final String ATTRIBUTION_ID_PREF = "attributionId";
    private static final String PREPARE_DATA_ACTION = "collect data for server";
    private static final String CALL_SERVER_ACTION = "call server.";
    private static final String SERVER_RESPONDED_ACTION = "response from server. status=";
    public static final String ATTRIBUTION_ID_CONTENT_URI = "content://com.facebook.katana.provider.AttributionIdProvider";
    public static final String ATTRIBUTION_ID_COLUMN_NAME = "aid";
    private static final String CACHED_CHANNEL_PREF = "CACHED_CHANNEL";
    private static final String CACHED_URL_PARAMETER = "&isCachedRequest=true&timeincache=";
    private static final String INSTALL_STORE_PREF = "INSTALL_STORE";
    private static final List<String> IGNORABLE_KEYS = Arrays.asList("is_cache");
    private static final String DEEPLINK_ATTR_PREF = "deeplinkAttribution";
    static final String PRE_INSTALL_PREF = "preInstallName";
    private static final String IMEI_CACHED_PREF = "imeiCached";
    private static final String PREV_EVENT_TIMESTAMP = "prev_event_timestamp";
    private static final String PREV_EVENT_VALUE = "prev_event_value";
    private static final String PREV_EVENT_NAME = "prev_event_name";
    private static final String PREV_EVENT = "prev_event";
    private static final long TEST_MODE_MAX_DURATION = 30000L;
    private static final long PUSH_PAYLOAD_MAX_AGING_DEFAULT_VALUE = 1800000L;
    private static final int PUSH_PAYLOAD_HISTORY_SIZE_DEFAULT_VALUE = 2;
    private static final String ANDROID_ID_CACHED_PREF = "androidIdCached";
    private static final String IN_APP_EVENTS_API = "1";
    public static final String PRE_INSTALL_SYSTEM_RO_PROP = "ro.appsflyer.preinstall.path";
    public static final String PRE_INSTALL_SYSTEM_DEFAULT = "/data/local/tmp/pre_install.appsflyer";
    public static final String PRE_INSTALL_SYSTEM_DEFAULT_ETC = "/etc/pre_install.appsflyer";
    public static final String AF_PRE_INSTALL_PATH = "AF_PRE_INSTALL_PATH";
    static final String RESPONSE_NOT_JSON = "response_not_json";
    private static AppsFlyerConversionListener conversionDataListener = null;
    static AppsFlyerInAppPurchaseValidatorListener validatorListener = null;
    private static boolean isDuringCheckCache = false;
    private static long lastCacheCheck;
    private static ScheduledExecutorService cacheScheduler;
    private static long timeEnteredForeground;
    private static long timeWentToBackground;
    private static final String CONVERSION_REQUEST_RETRIES = "appsflyerConversionDataRequestRetries";
    private static final int NUMBER_OF_CONVERSION_DATA_RETRIES = 5;
    private static final String CONVERSION_DATA_CACHE_EXPIRATION = "appsflyerConversionDataCacheExpiration";
    private static final String GET_CONVERSION_DATA_TIME = "appsflyerGetConversionDataTiming";
    private static final long SIXTY_DAYS = 5184000000L;
    private static final String VERSION_CODE = "versionCode";
    private static AppsFlyerLib instance;
    private Foreground.Listener listener;
    String userCustomImei;
    String userCustomAndroidId;
    private long timeInApp;
    private Uri latestDeepLink = null;
    private long testModeStartTime;
    private boolean isRetargetingTestMode = false;
    private String pushPayload;
    private Map<Long, String> pushPayloadHistory;
    private boolean isTokenRefreshServiceConfigured;

    void onReceive(Context context, Intent intent) {
        String shouldMonitor = intent.getStringExtra("shouldMonitor");
        if (shouldMonitor != null) {
            AFLogger.afLog("Turning on monitoring.");
            AppsFlyerProperties.getInstance().set("shouldMonitor", shouldMonitor.equals("true"));
            this.monitor(context, null, "START_TRACKING", context.getPackageName());
            return;
        }
        AFLogger.afLog("****** onReceive called *******");
        this.debugAction("******* onReceive: ", "", context);
        AppsFlyerProperties.getInstance().setOnReceiveCalled();
        String referrer = intent.getStringExtra(REFERRER_PREF);
        AFLogger.afLog("Play store referrer: " + referrer);
        if (referrer != null) {
            String testIntegration = intent.getStringExtra("TestIntegrationMode");
            if (testIntegration != null && testIntegration.equals("AppsFlyer_Test")) {
                SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
                SharedPreferences.Editor editor = sharedPreferences.edit();
                editor.clear();
                this.editorCommit(editor);
                AppsFlyerProperties.getInstance().setFirstLaunchCalled(false);
                this.startTestMode();
            }
            this.debugAction("onReceive called. referrer: ", referrer, context);
            this.saveDataToSharedPreferences(context, REFERRER_PREF, referrer);
            AppsFlyerProperties.getInstance().setReferrer(referrer);
            if (AppsFlyerProperties.getInstance().isFirstLaunchCalled()) {
                AFLogger.afLog("onReceive: isLaunchCalled");
                this.backgroundReferrerLaunch(context, referrer);
            }
        }
    }

    void addReferrer(Context context, String referrer) {
        AFLogger.afDebugLog("received a new (extra) referrer: " + referrer);
        try {
            JSONObject referrers = null;
            JSONArray occurrencesTimestamps = null;
            long now = System.currentTimeMillis();
            SharedPreferences sp = context.getSharedPreferences(AF_SHARED_PREF, 0);
            String referrersString = sp.getString(EXTRA_REFERRERS_PREF, null);
            if (referrersString == null) {
                referrers = new JSONObject();
                occurrencesTimestamps = new JSONArray();
            } else {
                referrers = new JSONObject(referrersString);
                occurrencesTimestamps = referrers.has(referrer) ? new JSONArray((String)referrers.get(referrer)) : new JSONArray();
            }
            if (occurrencesTimestamps.length() <= 4) {
                occurrencesTimestamps.put(now);
            }
            referrers.put(referrer, (Object)occurrencesTimestamps.toString());
            this.saveDataToSharedPreferences(context, EXTRA_REFERRERS_PREF, referrers.toString());
        }
        catch (JSONException referrers) {
        }
        catch (Throwable t) {
            AFLogger.afLogE("Couldn't save referrer - " + referrer + ": ", t);
        }
    }

    @SuppressLint(value={"CommitPrefEdits"})
    void editorCommit(SharedPreferences.Editor editor) {
        if (Build.VERSION.SDK_INT >= 9) {
            editor.apply();
        } else {
            editor.commit();
        }
    }

    private void startTestMode() {
        AFLogger.afLog("Test mode started..");
        this.testModeStartTime = System.currentTimeMillis();
    }

    private void endTestMode() {
        AFLogger.afLog("Test mode ended!");
        this.testModeStartTime = 0L;
    }

    private boolean isInTestMode(Context context) {
        long interval = System.currentTimeMillis() - this.testModeStartTime;
        String referrer = AppsFlyerProperties.getInstance().getReferrer(context);
        return interval <= 30000L && referrer != null && referrer.contains("AppsFlyer_Test");
    }

    private AppsFlyerLib() {
    }

    public static AppsFlyerLib getInstance() {
        return instance;
    }

    public String getSdkVersion() {
        RemoteDebuggingManager.getInstance().addApiEvent("getSdkVersion", new String[0]);
        return "version: 4.7.1 (build 314)";
    }

    private void registerForAppEvents(Application application) {
        if (this.listener == null) {
            AppsFlyerProperties.getInstance().loadProperties(application.getApplicationContext());
            if (Build.VERSION.SDK_INT >= 14) {
                Foreground.init(application);
                this.listener = new Foreground.Listener(){

                    @Override
                    public void onBecameForeground(Activity currentActivity) {
                        AFLogger.afLog("onBecameForeground");
                        timeEnteredForeground = System.currentTimeMillis();
                        AppsFlyerLib.this.trackEventInternal((Context)currentActivity, null, null);
                    }

                    @Override
                    public void onBecameBackground(WeakReference<Activity> currentActivity) {
                        AFLogger.afLog("onBecameBackground");
                        timeWentToBackground = System.currentTimeMillis();
                        AFLogger.afLog("callStatsBackground background call");
                        WeakReference<Context> weakContext = new WeakReference<Context>(((Activity)currentActivity.get()).getApplicationContext());
                        AppsFlyerLib.this.callStatsBackground(weakContext);
                        RemoteDebuggingManager rdInstance = RemoteDebuggingManager.getInstance();
                        if (rdInstance.isRemoteDebuggingEnabledFromServer()) {
                            rdInstance.stopRemoteDebuggingMode();
                            if (weakContext.get() != null) {
                                String packageName = ((Context)weakContext.get()).getPackageName();
                                PackageManager packageManager = ((Context)weakContext.get()).getPackageManager();
                                rdInstance.sendRemoteDebuggingData(packageName, packageManager);
                            }
                            rdInstance.releaseRemoteDebugging();
                        } else {
                            AFLogger.afDebugLog("RD status is OFF");
                        }
                    }
                };
                Foreground.getInstance().registerListener(this.listener);
            } else {
                AFLogger.afLog("SDK<14 call trackAppLaunch manually");
                this.trackEventInternal(application.getApplicationContext(), null, null);
            }
        }
    }

    @Deprecated
    public void setGCMProjectID(String projectNumber) {
        RemoteDebuggingManager.getInstance().addApiEvent("setGCMProjectID", projectNumber);
        AFLogger.afWarnLog("Method 'setGCMProjectNumber' is deprecated. Please follow the documentation.");
        this.enableUninstallTracking(projectNumber);
    }

    @Deprecated
    public void setGCMProjectNumber(String projectNumber) {
        RemoteDebuggingManager.getInstance().addApiEvent("setGCMProjectNumber", projectNumber);
        AFLogger.afWarnLog("Method 'setGCMProjectNumber' is deprecated. Please follow the documentation.");
        this.enableUninstallTracking(projectNumber);
    }

    @Deprecated
    public void setGCMProjectNumber(Context context, String projectNumber) {
        RemoteDebuggingManager.getInstance().addApiEvent("setGCMProjectNumber", projectNumber);
        AFLogger.afWarnLog("Method 'setGCMProjectNumber' is deprecated. Please use 'enableUninstallTracking'.");
        this.enableUninstallTracking(projectNumber);
    }

    public void enableUninstallTracking(String senderId) {
        RemoteDebuggingManager.getInstance().addApiEvent("enableUninstallTracking", senderId);
        this.setProperty("gcmProjectNumber", senderId);
    }

    public void updateServerUninstallToken(Context context, String token) {
        if (token != null) {
            AFUninstallToken afToken = new AFUninstallToken(token);
            UninstallUtils.updateServerUninstallToken(context, afToken);
        }
    }

    public void setDebugLog(boolean shouldEnable) {
        RemoteDebuggingManager.getInstance().addApiEvent("setDebugLog", String.valueOf(shouldEnable));
        AppsFlyerProperties.getInstance().enableLogOutput(shouldEnable);
    }

    public void setImeiData(String aImei) {
        RemoteDebuggingManager.getInstance().addApiEvent("setImeiData", aImei);
        this.userCustomImei = aImei;
    }

    public void setAndroidIdData(String aAndroidId) {
        RemoteDebuggingManager.getInstance().addApiEvent("setAndroidIdData", aAndroidId);
        this.userCustomAndroidId = aAndroidId;
    }

    private void debugAction(String actionMsg, String parameter, Context context) {
        try {
            if (this.isAppsFlyerPackage(context)) {
                DebugLogQueue.getInstance().push(actionMsg + parameter);
            }
        }
        catch (Exception e) {
            AFLogger.afLogE("Exception in AppsFlyerLib.debugAction(...):", e);
        }
    }

    private boolean isAppsFlyerPackage(Context context) {
        return context != null && context.getPackageName().length() > 12 && "com.appsflyer".equals(context.getPackageName().toLowerCase().substring(0, 13));
    }

    private void saveDataToSharedPreferences(Context context, String key, String value) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(key, value);
        this.editorCommit(editor);
    }

    private void saveIntegerToSharedPreferences(Context context, String key, int value) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putInt(key, value);
        this.editorCommit(editor);
    }

    private void saveLongToSharedPreferences(Context context, String key, long value) {
        this.saveLongToSharedPreferences(context.getSharedPreferences(AF_SHARED_PREF, 0), key, value);
    }

    private void saveLongToSharedPreferences(SharedPreferences sharedPreferences, String key, long value) {
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong(key, value);
        this.editorCommit(editor);
    }

    private boolean checkWriteExternalPermission(Context context) {
        String permission = "android.permission.ACCESS_FINE_LOCATION";
        int res = context.checkCallingOrSelfPermission(permission);
        return res == 0;
    }

    private void setProperty(String key, String value) {
        AppsFlyerProperties.getInstance().set(key, value);
    }

    private void setProperty(String key, int value) {
        AppsFlyerProperties.getInstance().set(key, value);
    }

    void setProperty(String key, boolean value) {
        AppsFlyerProperties.getInstance().set(key, value);
    }

    void setProperty(String key, long value) {
        AppsFlyerProperties.getInstance().set(key, value);
    }

    private String getProperty(String key) {
        return AppsFlyerProperties.getInstance().getString(key);
    }

    private int getProperty(String key, int defaultValue) {
        return AppsFlyerProperties.getInstance().getInt(key, defaultValue);
    }

    boolean getProperty(String key, boolean defaultValue) {
        return AppsFlyerProperties.getInstance().getBoolean(key, defaultValue);
    }

    long getProperty(String key, long defaultValue) {
        return AppsFlyerProperties.getInstance().getLong(key, defaultValue);
    }

    @Deprecated
    public void setAppUserId(String id) {
        RemoteDebuggingManager.getInstance().addApiEvent("setAppUserId", id);
        this.setCustomerUserId(id);
    }

    public void setCustomerUserId(String id) {
        RemoteDebuggingManager.getInstance().addApiEvent("setCustomerUserId", id);
        AFLogger.afLog("setCustomerUserId = " + id);
        this.setProperty("AppUserId", id);
    }

    public void setAdditionalData(HashMap<String, Object> customData) {
        if (customData != null) {
            RemoteDebuggingManager.getInstance().addApiEvent("setAdditionalData", customData.toString());
            JSONObject jsonObject = new JSONObject(customData);
            AppsFlyerProperties.getInstance().setCustomData(jsonObject.toString());
        }
    }

    public void sendDeepLinkData(Activity activity) {
        if (activity != null && activity.getIntent() != null) {
            RemoteDebuggingManager.getInstance().addApiEvent("sendDeepLinkData", activity.getLocalClassName(), "activity_intent_" + activity.getIntent().toString());
        } else if (activity != null) {
            RemoteDebuggingManager.getInstance().addApiEvent("sendDeepLinkData", activity.getLocalClassName(), "activity_intent_null");
        } else {
            RemoteDebuggingManager.getInstance().addApiEvent("sendDeepLinkData", "activity_null");
        }
        AFLogger.afLog("getDeepLinkData with activity " + activity.getIntent().getDataString());
        this.registerForAppEvents(activity.getApplication());
    }

    public void sendPushNotificationData(Activity activity) {
        if (activity != null && activity.getIntent() != null) {
            RemoteDebuggingManager.getInstance().addApiEvent("sendPushNotificationData", activity.getLocalClassName(), "activity_intent_" + activity.getIntent().toString());
        } else if (activity != null) {
            RemoteDebuggingManager.getInstance().addApiEvent("sendPushNotificationData", activity.getLocalClassName(), "activity_intent_null");
        } else {
            RemoteDebuggingManager.getInstance().addApiEvent("sendPushNotificationData", "activity_null");
        }
        this.pushPayload = this.getPushPayloadFromIntent((Context)activity);
        if (this.pushPayload != null) {
            long now;
            long oldestPayloadTimestamp = now = System.currentTimeMillis();
            if (this.pushPayloadHistory == null) {
                AFLogger.afLog("pushes: initializing pushes history..");
                this.pushPayloadHistory = new ConcurrentHashMap<Long, String>();
            } else {
                try {
                    long pushPayloadMaxAging = AppsFlyerProperties.getInstance().getLong("pushPayloadMaxAging", 1800000L);
                    for (Long age : this.pushPayloadHistory.keySet()) {
                        JSONObject newPush = new JSONObject(this.pushPayload);
                        JSONObject oldPush = new JSONObject(this.pushPayloadHistory.get(age));
                        if (newPush.get("pid").equals(oldPush.get("pid"))) {
                            AFLogger.afLog("PushNotificationMeasurement: A previous payload with same PID was already acknowledged! (old: " + oldPush + ", new: " + newPush + ")");
                            this.pushPayload = null;
                            return;
                        }
                        if (now - age > pushPayloadMaxAging) {
                            this.pushPayloadHistory.remove(age);
                        }
                        if (age > oldestPayloadTimestamp) continue;
                        oldestPayloadTimestamp = age;
                    }
                }
                catch (Throwable t) {
                    AFLogger.afLogE("Error while handling push notification measurement: " + t.getClass().getSimpleName(), t);
                }
            }
            int pushPayloadHistorySize = AppsFlyerProperties.getInstance().getInt("pushPayloadHistorySize", 2);
            if (this.pushPayloadHistory.size() == pushPayloadHistorySize) {
                AFLogger.afLog("pushes: removing oldest overflowing push (oldest push:" + oldestPayloadTimestamp + ")");
                this.pushPayloadHistory.remove(oldestPayloadTimestamp);
            }
            this.pushPayloadHistory.put(now, this.pushPayload);
            this.registerForAppEvents(activity.getApplication());
        }
    }

    @Deprecated
    public void setUserEmail(String email) {
        RemoteDebuggingManager.getInstance().addApiEvent("setUserEmail", email);
        this.setProperty("userEmail", email);
    }

    public void setUserEmails(String ... emails) {
        RemoteDebuggingManager.getInstance().addApiEvent("setUserEmails", emails);
        this.setUserEmails(AppsFlyerProperties.EmailsCryptType.NONE, emails);
    }

    public void setUserEmails(AppsFlyerProperties.EmailsCryptType cryptMethod, String ... emails) {
        ArrayList<String> args = new ArrayList<String>(emails.length + 1);
        args.add(cryptMethod.toString());
        args.addAll(Arrays.asList(emails));
        RemoteDebuggingManager.getInstance().addApiEvent("setUserEmails", args.toArray(new String[emails.length + 1]));
        AppsFlyerProperties.getInstance().set("userEmailsCryptType", cryptMethod.getValue());
        HashMap emailData = new HashMap();
        String cryptKey = null;
        ArrayList<String> hashedEmailList = new ArrayList<String>();
        block5: for (String email : emails) {
            switch (cryptMethod) {
                default: {
                    cryptKey = "sha1_el_arr";
                    hashedEmailList.add(HashUtils.toSHA1(email));
                    continue block5;
                }
                case MD5: {
                    cryptKey = "md5_el_arr";
                    hashedEmailList.add(HashUtils.toMD5(email));
                    continue block5;
                }
                case SHA256: {
                    cryptKey = "sha256_el_arr";
                    hashedEmailList.add(HashUtils.toSha256(email));
                    continue block5;
                }
                case NONE: {
                    cryptKey = "plain_el_arr";
                    hashedEmailList.add(email);
                }
            }
        }
        emailData.put(cryptKey, hashedEmailList);
        JSONObject jObj = new JSONObject(emailData);
        AppsFlyerProperties.getInstance().setUserEmails(jObj.toString());
    }

    public void setCollectAndroidID(boolean isCollect) {
        RemoteDebuggingManager.getInstance().addApiEvent("setCollectAndroidID", String.valueOf(isCollect));
        this.setProperty("collectAndroidId", Boolean.toString(isCollect));
    }

    public void setCollectIMEI(boolean isCollect) {
        RemoteDebuggingManager.getInstance().addApiEvent("setCollectIMEI", String.valueOf(isCollect));
        this.setProperty("collectIMEI", Boolean.toString(isCollect));
    }

    @Deprecated
    public void setCollectFingerPrint(boolean isCollect) {
        RemoteDebuggingManager.getInstance().addApiEvent("setCollectFingerPrint", String.valueOf(isCollect));
        this.setProperty("collectFingerPrint", Boolean.toString(isCollect));
    }

    public void startTracking(Application application, String key) {
        RemoteDebuggingManager.getInstance().addApiEvent("startTracking", key);
        AFLogger.afLogM("Build Number: 314");
        this.setProperty("AppsFlyerKey", key);
        LogMessages.setDevKey(key);
        this.registerForAppEvents(application);
    }

    private void getReInstallData(Context context) {
        if (Build.VERSION.SDK_INT >= 18) {
            AFKeystoreWrapper afKeystore = new AFKeystoreWrapper(context);
            if (!afKeystore.loadData()) {
                afKeystore.createFirstInstallData(Installation.id(new WeakReference<Context>(context)));
                this.setProperty("KSAppsFlyerId", afKeystore.getUid());
                this.setProperty("KSAppsFlyerRICounter", String.valueOf(afKeystore.getReInstallCounter()));
            } else {
                afKeystore.incrementReInstallCounter();
                this.setProperty("KSAppsFlyerId", afKeystore.getUid());
                this.setProperty("KSAppsFlyerRICounter", String.valueOf(afKeystore.getReInstallCounter()));
            }
        }
    }

    private String getCustomerUserId() {
        return this.getProperty("AppUserId");
    }

    public void setAppId(String id) {
        RemoteDebuggingManager.getInstance().addApiEvent("setAppId", id);
        this.setProperty("appid", id);
    }

    private String getAppId() {
        return this.getProperty("appid");
    }

    public void setExtension(String extension) {
        RemoteDebuggingManager.getInstance().addApiEvent("setExtension", extension);
        AppsFlyerProperties.getInstance().set("sdkExtension", extension);
    }

    public void setIsUpdate(boolean isUpdate) {
        RemoteDebuggingManager.getInstance().addApiEvent("setIsUpdate", String.valueOf(isUpdate));
        AppsFlyerProperties.getInstance().set("IS_UPDATE", isUpdate);
    }

    public void setCurrencyCode(String currencyCode) {
        RemoteDebuggingManager.getInstance().addApiEvent("setCurrencyCode", currencyCode);
        AppsFlyerProperties.getInstance().set("currencyCode", currencyCode);
    }

    public void trackLocation(Context context, double latitude, double longitude) {
        RemoteDebuggingManager.getInstance().addApiEvent("trackLocation", String.valueOf(latitude), String.valueOf(longitude));
        HashMap<String, Object> location = new HashMap<String, Object>();
        location.put("af_long", Double.toString(longitude));
        location.put("af_lat", Double.toString(latitude));
        this.trackEventInternal(context, "af_location_coordinates", location);
    }

    private void callStatsBackground(WeakReference<Context> context) {
        String customUUID;
        String advertisingId;
        AdvertisingIdObject amazonAdvIdObject;
        if (context.get() == null) {
            return;
        }
        AFLogger.afLog("app went to background");
        SharedPreferences sharedPreferences = ((Context)context.get()).getSharedPreferences(AF_SHARED_PREF, 0);
        AppsFlyerProperties.getInstance().saveProperties(sharedPreferences);
        long sessionTime = timeWentToBackground - timeEnteredForeground;
        HashMap<String, String> statsParams = new HashMap<String, String>();
        String afDevKey = this.getProperty("AppsFlyerKey");
        String originalAFUID = this.getProperty("KSAppsFlyerId");
        boolean deviceTrackingDisabled = AppsFlyerProperties.getInstance().getBoolean("deviceTrackingDisabled", false);
        if (deviceTrackingDisabled) {
            statsParams.put("deviceTrackingDisabled", "true");
        }
        if ((amazonAdvIdObject = AdvertisingIdUtil.getAmazonAID(((Context)context.get()).getContentResolver())) != null) {
            statsParams.put("amazon_aid", amazonAdvIdObject.getAdvertisingId());
            statsParams.put("amazon_aid_limit", String.valueOf(amazonAdvIdObject.isLimitAdTracking()));
        }
        if ((advertisingId = AppsFlyerProperties.getInstance().getString("advertiserId")) != null) {
            statsParams.put("advertiserId", advertisingId);
        }
        statsParams.put("app_id", ((Context)context.get()).getPackageName());
        statsParams.put("devkey", afDevKey);
        statsParams.put("uid", Installation.id(context));
        statsParams.put("time_in_app", String.valueOf(sessionTime / 1000L));
        statsParams.put("statType", "user_closed_app");
        statsParams.put("platform", "Android");
        statsParams.put("launch_counter", Integer.toString(this.getCounter(sharedPreferences, AF_COUNTER_PREF, false)));
        statsParams.put("gcd_conversion_data_timing", Long.toString(sharedPreferences.getLong(GET_CONVERSION_DATA_TIME, 0L)));
        statsParams.put("channel", this.getConfiguredChannel(context));
        statsParams.put("originalAppsflyerId", originalAFUID != null ? originalAFUID : "");
        boolean collectFingerPrint = AppsFlyerProperties.getInstance().getBoolean("collectFingerPrint", true);
        if (collectFingerPrint && (customUUID = this.getUniquePsuedoID()) != null) {
            statsParams.put("deviceFingerPrintId", customUUID);
        }
        try {
            BackgroundHttpTask statTask = new BackgroundHttpTask(null);
            statTask.bodyParameters = statsParams;
            if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
                AFLogger.afDebugLog("Main thread detected. Running callStats task in a new thread.");
                statTask.execute(new String[]{STATS_URL});
            } else {
                AFLogger.afDebugLog("Running callStats task (on current thread: " + Thread.currentThread().toString() + " )");
                statTask.onPreExecute();
                statTask.onPostExecute(statTask.doInBackground(STATS_URL));
            }
        }
        catch (Throwable t) {
            AFLogger.afLogE("Could not send callStats request", t);
        }
    }

    public void trackAppLaunch(Context ctx, String devKey) {
        this.runInBackground(ctx, devKey, null, null, "", true);
    }

    protected void setDeepLinkData(Intent intent) {
        try {
            if (intent != null && "android.intent.action.VIEW".equals(intent.getAction())) {
                this.latestDeepLink = intent.getData();
                AFLogger.afDebugLog("Unity setDeepLinkData = " + this.latestDeepLink);
            }
        }
        catch (Throwable t) {
            AFLogger.afLogE("Exception while setting deeplink data (unity). ", t);
        }
    }

    public void reportTrackSession(Context ctx) {
        RemoteDebuggingManager.getInstance().addApiEvent("reportTrackSession", new String[0]);
        RemoteDebuggingManager.getInstance().disableRemoteDebuggingForThisApp();
        this.trackEventInternal(ctx, null, null);
    }

    public void trackEvent(Context context, String eventName, Map<String, Object> eventValues) {
        JSONObject eventValuesJSON = new JSONObject((Map)(eventValues == null ? new HashMap<String, Object>() : eventValues));
        RemoteDebuggingManager.getInstance().addApiEvent("trackEvent", eventName, eventValuesJSON.toString());
        this.trackEventInternal(context, eventName, eventValues);
    }

    void trackEventInternal(Context context, String eventName, Map<String, Object> eventValues) {
        JSONObject eventValuesJSON = new JSONObject((Map)(eventValues == null ? new HashMap() : eventValues));
        String referrer = AppsFlyerProperties.getInstance().getReferrer(context);
        this.runInBackground(context, null, eventName, eventValuesJSON.toString(), referrer == null ? "" : referrer, true);
    }

    private void monitor(Context context, String eventIdentifier, String message, String value) {
        if (AppsFlyerProperties.getInstance().getBoolean("shouldMonitor", false)) {
            Intent localIntent = new Intent("com.appsflyer.MonitorBroadcast");
            localIntent.setPackage("com.appsflyer.nightvision");
            localIntent.putExtra("message", message);
            localIntent.putExtra("value", value);
            localIntent.putExtra("packageName", "true");
            localIntent.putExtra("pid", (Serializable)new Integer(Process.myPid()));
            localIntent.putExtra("eventIdentifier", eventIdentifier);
            localIntent.putExtra("sdk", BUILD_NUMBER);
            context.sendBroadcast(localIntent);
        }
    }

    void callRegisterBackground(Context context, String token) {
        String customUUID;
        String advertisingId;
        AdvertisingIdObject amazonAdvIdObject;
        HashMap<String, String> registerParams = new HashMap<String, String>();
        String afDevKey = this.getProperty("AppsFlyerKey");
        boolean deviceTrackingDisabled = AppsFlyerProperties.getInstance().getBoolean("deviceTrackingDisabled", false);
        if (deviceTrackingDisabled) {
            registerParams.put("deviceTrackingDisabled", "true");
        }
        if ((amazonAdvIdObject = AdvertisingIdUtil.getAmazonAID(context.getContentResolver())) != null) {
            registerParams.put("amazon_aid", amazonAdvIdObject.getAdvertisingId());
            registerParams.put("amazon_aid_limit", String.valueOf(amazonAdvIdObject.isLimitAdTracking()));
        }
        if ((advertisingId = AppsFlyerProperties.getInstance().getString("advertiserId")) != null) {
            registerParams.put("advertiserId", advertisingId);
        }
        registerParams.put("devkey", afDevKey);
        registerParams.put("uid", Installation.id(new WeakReference<Context>(context)));
        registerParams.put("af_gcm_token", token);
        registerParams.put("launch_counter", Integer.toString(this.getCounter(context.getSharedPreferences(AF_SHARED_PREF, 0), AF_COUNTER_PREF, false)));
        registerParams.put("sdk", Integer.toString(Build.VERSION.SDK_INT));
        registerParams.put("channel", this.getConfiguredChannel(new WeakReference<Context>(context)));
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            long firstInstallTime = packageInfo.firstInstallTime;
            SimpleDateFormat dateFormat = new SimpleDateFormat(INSTALL_UPDATE_DATE_FORMAT, Locale.US);
            registerParams.put("install_date", dateFormat.format(new Date(firstInstallTime)));
        }
        catch (Throwable e) {
            AFLogger.afLogE(e.getMessage(), e);
        }
        boolean collectFingerPrint = AppsFlyerProperties.getInstance().getBoolean("collectFingerPrint", true);
        if (collectFingerPrint && (customUUID = this.getUniquePsuedoID()) != null) {
            registerParams.put("deviceFingerPrintId", customUUID);
        }
        try {
            BackgroundHttpTask registerTask = new BackgroundHttpTask(context);
            registerTask.bodyParameters = registerParams;
            String url = REGISTER_URL + context.getPackageName();
            registerTask.execute(new String[]{url});
        }
        catch (Throwable t) {
            AFLogger.afLogE(t.getMessage(), t);
        }
    }

    private static void broadcastBacktoTestApp(Context context, String paramsString) {
        Intent localIntent = new Intent("com.appsflyer.testIntgrationBroadcast");
        localIntent.putExtra("params", paramsString);
        context.sendBroadcast(localIntent);
    }

    public void setDeviceTrackingDisabled(boolean isDisabled) {
        RemoteDebuggingManager.getInstance().addApiEvent("setDeviceTrackingDisabled", String.valueOf(isDisabled));
        AppsFlyerProperties.getInstance().set("deviceTrackingDisabled", isDisabled);
    }

    private Map<String, String> getConversionData(Context context) throws AttributionIDNotReady {
        SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
        String referrer = AppsFlyerProperties.getInstance().getReferrer(context);
        if (referrer != null && referrer.length() > 0 && referrer.contains("af_tranid")) {
            return this.referrerStringToMap(context, referrer);
        }
        String attributionString = sharedPreferences.getString(ATTRIBUTION_ID_PREF, null);
        if (attributionString != null && attributionString.length() > 0) {
            return this.attributionStringToMap(attributionString);
        }
        throw new AttributionIDNotReady();
    }

    public void registerConversionListener(Context context, AppsFlyerConversionListener conversionDataListener) {
        RemoteDebuggingManager.getInstance().addApiEvent("registerConversionListener", new String[0]);
        this.registerConversionListenerInternal(context, conversionDataListener);
    }

    private void registerConversionListenerInternal(Context context, AppsFlyerConversionListener conversionDataListener) {
        if (conversionDataListener == null) {
            return;
        }
        AppsFlyerLib.conversionDataListener = conversionDataListener;
    }

    public void unregisterConversionListener() {
        RemoteDebuggingManager.getInstance().addApiEvent("unregisterConversionListener", new String[0]);
        conversionDataListener = null;
    }

    public void registerValidatorListener(Context context, AppsFlyerInAppPurchaseValidatorListener validationListener) {
        RemoteDebuggingManager.getInstance().addApiEvent("registerValidatorListener", new String[0]);
        AFLogger.afDebugLog("registerValidatorListener called");
        if (validationListener == null) {
            AFLogger.afDebugLog("registerValidatorListener null listener");
            return;
        }
        validatorListener = validationListener;
    }

    protected void getConversionData(Context context, final ConversionDataListener conversionDataListener) {
        this.registerConversionListenerInternal(context, new AppsFlyerConversionListener(){

            @Override
            public void onInstallConversionDataLoaded(Map<String, String> conversionData) {
                conversionDataListener.onConversionDataLoaded(conversionData);
            }

            @Override
            public void onInstallConversionFailure(String errorMessage) {
                conversionDataListener.onConversionFailure(errorMessage);
            }

            @Override
            public void onAppOpenAttribution(Map<String, String> attributionData) {
            }

            @Override
            public void onAttributionFailure(String errorMessage) {
            }
        });
    }

    private Map<String, String> referrerStringToMap(Context context, String referrer) {
        LinkedHashMap<String, String> conversionData = new LinkedHashMap<String, String>();
        String[] pairs = referrer.split("&");
        boolean didFindPrt = false;
        for (String pair : pairs) {
            String name;
            int idx = pair.indexOf("=");
            String string = name = idx > 0 ? pair.substring(0, idx) : pair;
            if (!conversionData.containsKey(name)) {
                if (name.equals("c")) {
                    name = "campaign";
                } else if (name.equals("pid")) {
                    name = "media_source";
                } else if (name.equals("af_prt")) {
                    didFindPrt = true;
                    name = "agency";
                }
                conversionData.put(name, new String());
            }
            String value = idx > 0 && pair.length() > idx + 1 ? pair.substring(idx + 1) : null;
            conversionData.put(name, value);
        }
        try {
            if (!conversionData.containsKey("install_time")) {
                PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
                long firstInstallTime = packageInfo.firstInstallTime;
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                conversionData.put("install_time", dateFormat.format(new Date(firstInstallTime)));
            }
        }
        catch (Exception e) {
            AFLogger.afLogE("Could not fetch install time. ", e);
        }
        if (!conversionData.containsKey("af_status")) {
            conversionData.put("af_status", "Non-organic");
        }
        if (didFindPrt) {
            conversionData.remove("media_source");
        }
        return conversionData;
    }

    private Map<String, String> attributionStringToMap(String inputString) {
        HashMap<String, String> conversionData = new HashMap<String, String>();
        try {
            JSONObject jsonObject = new JSONObject(inputString);
            Iterator iterator = jsonObject.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                if (IGNORABLE_KEYS.contains(key)) continue;
                conversionData.put(key, jsonObject.getString(key));
            }
        }
        catch (JSONException e) {
            AFLogger.afLogE(e.getMessage(), e);
            return null;
        }
        return conversionData;
    }

    private void runInBackground(Context context, String appsFlyerKey, String eventName, String eventValue, String referrer, boolean isNewAPI) {
        long timeSinceLastLaunch = timeEnteredForeground - timeWentToBackground;
        if (eventName == null && timeSinceLastLaunch < 5000L) {
            AFLogger.afLog("Time passed since last Launch: " + (double)timeSinceLastLaunch / 1000.0 + " seconds -> NOT sending 'Launch' event");
            return;
        }
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        scheduler.schedule(new DataCollector(new WeakReference<Context>(context), appsFlyerKey, eventName, eventValue, referrer, isNewAPI, scheduler), 150L, TimeUnit.MILLISECONDS);
    }

    private void backgroundReferrerLaunch(Context context, String referrer) {
        if (referrer != null && referrer.length() > 5) {
            ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
            scheduler.schedule(new DataCollector(new WeakReference<Context>(context), null, null, null, referrer, true, scheduler), 5L, TimeUnit.MILLISECONDS);
        }
    }

    private void sendTrackingWithEvent(Context context, String appsFlyerKey, String eventName, String eventValue, String referrer, boolean isUseNewAPI) {
        if (context == null) {
            return;
        }
        SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
        AppsFlyerProperties.getInstance().saveProperties(sharedPreferences);
        AFLogger.afLog("sendTrackingWithEvent from activity: " + context.getClass().getName());
        boolean isLaunchEvent = eventName == null;
        Map<String, Object> params = this.getEventParameters(context, appsFlyerKey, eventName, eventValue, referrer, isUseNewAPI, sharedPreferences, isLaunchEvent);
        String afDevKey = (String)params.get("appsflyerKey");
        if (afDevKey == null || afDevKey.length() == 0) {
            AFLogger.afDebugLog("Not sending data yet, waiting for dev key");
            return;
        }
        AFLogger.afLog("AppsFlyerLib.sendTrackingWithEvent");
        String urlString = (isLaunchEvent ? APPS_TRACKING_URL : EVENTS_TRACKING_URL) + context.getPackageName();
        new SendToServerRunnable(urlString, params, context.getApplicationContext(), isLaunchEvent).run();
    }

    Map<String, Object> getEventParameters(Context context, String appsFlyerKey, String eventName, String eventValue, String referrer, boolean isUseNewAPI, SharedPreferences sharedPreferences, boolean isLaunchEvent) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        AdvertisingIdUtil.addGoogleAID(context, params);
        params.put("af_timestamp", Long.toString(new Date().getTime()));
        try {
            AdvertisingIdObject amazonAdvIdObject;
            JSONObject paramsJSON;
            AFUninstallToken tokenObject;
            String uninstallToken;
            String referrersString;
            String attributionString;
            String customUUID;
            String isUpdate;
            String currencyCode;
            String emailData;
            String currentStore;
            String preInstallName;
            String installStore;
            String currentChannel;
            String originalChannel;
            String customData;
            this.debugAction(PREPARE_DATA_ACTION, "", context);
            AFLogger.afLog("******* sendTrackingWithEvent: " + (isLaunchEvent ? "Launch" : eventName));
            this.debugAction("********* sendTrackingWithEvent: ", isLaunchEvent ? "Launch" : eventName, context);
            this.monitor(context, LOG_TAG, "EVENT_CREATED_WITH_NAME", isLaunchEvent ? "Launch" : eventName);
            CacheManager.getInstance().init(context);
            try {
                PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 4096);
                List<String> requestedPermissions = Arrays.asList(packageInfo.requestedPermissions);
                if (!requestedPermissions.contains("android.permission.INTERNET")) {
                    AFLogger.afWarnLog("Permission android.permission.INTERNET is missing in the AndroidManifest.xml");
                    this.monitor(context, null, "PERMISSION_INTERNET_MISSING", null);
                }
                if (!requestedPermissions.contains("android.permission.ACCESS_NETWORK_STATE")) {
                    AFLogger.afWarnLog("Permission android.permission.ACCESS_NETWORK_STATE is missing in the AndroidManifest.xml");
                }
                if (!requestedPermissions.contains("android.permission.ACCESS_WIFI_STATE")) {
                    AFLogger.afWarnLog("Permission android.permission.ACCESS_WIFI_STATE is missing in the AndroidManifest.xml");
                }
            }
            catch (Exception e) {
                AFLogger.afLogE("Exception while validation permissions. ", e);
            }
            if (isUseNewAPI) {
                params.put("af_events_api", IN_APP_EVENTS_API);
            }
            params.put("brand", Build.BRAND);
            params.put("device", Build.DEVICE);
            params.put("product", Build.PRODUCT);
            params.put("sdk", Integer.toString(Build.VERSION.SDK_INT));
            params.put("model", Build.MODEL);
            params.put("deviceType", Build.TYPE);
            if (isLaunchEvent) {
                if (this.isAppsFlyerFirstLaunch(context)) {
                    if (!AppsFlyerProperties.getInstance().isOtherSdkStringDisabled()) {
                        params.put("af_sdks", this.generateOtherSDKsString());
                        float batteryLevel = this.getBatteryLevel(context);
                        params.put("batteryLevel", String.valueOf(batteryLevel));
                    }
                    this.getReInstallData(context);
                }
            } else {
                this.lastEventsProcessing(context, params, eventName, eventValue);
            }
            String originalAFUID = this.getProperty("KSAppsFlyerId");
            String reInstallCounter = this.getProperty("KSAppsFlyerRICounter");
            if (originalAFUID != null && reInstallCounter != null && Integer.valueOf(reInstallCounter) > 0) {
                params.put("reinstallCounter", reInstallCounter);
                params.put("originalAppsflyerId", originalAFUID);
            }
            if ((customData = this.getProperty("additionalCustomData")) != null) {
                params.put("customData", customData);
            }
            try {
                String installerPackage = context.getPackageManager().getInstallerPackageName(context.getPackageName());
                if (installerPackage != null) {
                    params.put("installer_package", installerPackage);
                }
            }
            catch (Exception e) {
                AFLogger.afLogE("Exception while getting the app's installer package. ", e);
            }
            String sdkExtension = AppsFlyerProperties.getInstance().getString("sdkExtension");
            if (sdkExtension != null && sdkExtension.length() > 0) {
                params.put("sdkExtension", sdkExtension);
            }
            if ((originalChannel = this.getCachedChannel(context, currentChannel = this.getConfiguredChannel(new WeakReference<Context>(context)))) != null) {
                params.put("channel", originalChannel);
            }
            if (originalChannel != null && !originalChannel.equals(currentChannel) || originalChannel == null && currentChannel != null) {
                params.put("af_latestchannel", currentChannel);
            }
            if ((installStore = this.getCachedStore(context)) != null) {
                params.put("af_installstore", installStore.toLowerCase());
            }
            if ((preInstallName = this.getPreInstallName(context)) != null) {
                params.put("af_preinstall_name", preInstallName.toLowerCase());
            }
            if ((currentStore = this.getCurrentStore(context)) != null) {
                params.put("af_currentstore", currentStore.toLowerCase());
            }
            if (appsFlyerKey != null && appsFlyerKey.length() >= 0) {
                params.put("appsflyerKey", appsFlyerKey);
            } else {
                String afKeyFromProperties = this.getProperty("AppsFlyerKey");
                if (afKeyFromProperties != null && afKeyFromProperties.length() >= 0) {
                    params.put("appsflyerKey", afKeyFromProperties);
                } else {
                    AFLogger.afLog("AppsFlyer dev key is missing!!! Please use  AppsFlyerLib.getInstance().setAppsFlyerKey(...) to set it. ");
                    this.monitor(context, LOG_TAG, "DEV_KEY_MISSING", null);
                    AFLogger.afLog("AppsFlyer will not track this event.");
                    return null;
                }
            }
            String appUserId = this.getCustomerUserId();
            if (appUserId != null) {
                params.put("appUserId", appUserId);
            }
            if ((emailData = AppsFlyerProperties.getInstance().getString("userEmails")) != null) {
                params.put("user_emails", emailData);
            } else {
                String userEmail = this.getProperty("userEmail");
                if (userEmail != null) {
                    params.put("sha1_el", HashUtils.toSHA1(userEmail));
                }
            }
            if (eventName != null) {
                params.put("eventName", eventName);
                if (eventValue != null) {
                    params.put("eventValue", eventValue);
                }
            }
            if (this.getAppId() != null) {
                params.put("appid", this.getProperty("appid"));
            }
            if ((currencyCode = this.getProperty("currencyCode")) != null) {
                if (currencyCode.length() != 3) {
                    AFLogger.afWarnLog("WARNING: currency code should be 3 characters!!! '" + currencyCode + "' is not a legal value.");
                }
                params.put("currency", currencyCode);
            }
            if ((isUpdate = this.getProperty("IS_UPDATE")) != null) {
                params.put("isUpdate", isUpdate);
            }
            boolean isPreInstall = this.isPreInstalledApp(context);
            params.put("af_preinstalled", Boolean.toString(isPreInstall));
            boolean shouldCollectFBId = AppsFlyerProperties.getInstance().getBoolean("collectFacebookAttrId", true);
            if (shouldCollectFBId) {
                String facebookAttributeId;
                try {
                    context.getPackageManager().getApplicationInfo("com.facebook.katana", 0);
                    facebookAttributeId = this.getAttributionId(context.getContentResolver());
                }
                catch (PackageManager.NameNotFoundException ignored) {
                    facebookAttributeId = null;
                    AFLogger.afWarnLog("Exception while collecting facebook's attribution ID. ");
                }
                catch (Throwable t) {
                    facebookAttributeId = null;
                    AFLogger.afLogE("Exception while collecting facebook's attribution ID. ", t);
                }
                if (facebookAttributeId != null) {
                    params.put("fb", facebookAttributeId);
                }
            }
            this.addDeviceTracking(context, params);
            try {
                String uid = Installation.id(new WeakReference<Context>(context));
                if (uid != null) {
                    params.put("uid", uid);
                }
            }
            catch (Exception e) {
                AFLogger.afLogE("ERROR: " + "could not get uid " + e.getMessage(), e);
            }
            try {
                params.put("lang", Locale.getDefault().getDisplayLanguage());
            }
            catch (Exception e) {
                AFLogger.afLogE("Exception while collecting display language name. ", e);
            }
            try {
                params.put("lang_code", Locale.getDefault().getLanguage());
            }
            catch (Exception e) {
                AFLogger.afLogE("Exception while collecting display language code. ", e);
            }
            try {
                params.put("country", Locale.getDefault().getCountry());
            }
            catch (Exception e) {
                AFLogger.afLogE("Exception while collecting country name. ", e);
            }
            try {
                TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
                params.put("operator", manager.getSimOperatorName());
                params.put("carrier", manager.getNetworkOperatorName());
            }
            catch (Exception e) {
                AFLogger.afLogE("Exception while collecting network operator/carrier.  ", e);
            }
            try {
                params.put("network", this.getNetwork(context));
            }
            catch (Throwable e) {
                AFLogger.afLogE("Exception while collecting network info. ", e);
            }
            boolean collectFingerPrint = AppsFlyerProperties.getInstance().getBoolean("collectFingerPrint", true);
            if (collectFingerPrint && (customUUID = this.getUniquePsuedoID()) != null) {
                params.put("deviceFingerPrintId", customUUID);
            }
            this.checkPlatform(context, params);
            this.getSystemInfo(params);
            SimpleDateFormat dateFormat = new SimpleDateFormat(INSTALL_UPDATE_DATE_FORMAT, Locale.US);
            if (Build.VERSION.SDK_INT >= 9) {
                try {
                    long installed = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).firstInstallTime;
                    params.put("installDate", dateFormat.format(new Date(installed)));
                }
                catch (Exception e) {
                    AFLogger.afLogE("Exception while collecting install date. ", e);
                }
            }
            try {
                PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
                int versioncode = sharedPreferences.getInt(VERSION_CODE, 0);
                if (packageInfo.versionCode > versioncode) {
                    this.saveIntegerToSharedPreferences(context, CONVERSION_REQUEST_RETRIES, 0);
                    this.saveIntegerToSharedPreferences(context, VERSION_CODE, packageInfo.versionCode);
                }
                params.put("app_version_code", Integer.toString(packageInfo.versionCode));
                params.put("app_version_name", packageInfo.versionName);
                if (Build.VERSION.SDK_INT >= 9) {
                    long firstInstallTime = packageInfo.firstInstallTime;
                    long lastUpdateTime = packageInfo.lastUpdateTime;
                    params.put("date1", dateFormat.format(new Date(firstInstallTime)));
                    params.put("date2", dateFormat.format(new Date(lastUpdateTime)));
                    String firstInstallDate = this.getFirstInstallDate(dateFormat, context);
                    params.put("firstLaunchDate", firstInstallDate);
                }
            }
            catch (Throwable t) {
                AFLogger.afLogE("Exception while collecting app version data ", t);
            }
            if (referrer.length() > 0) {
                params.put(REFERRER_PREF, referrer);
            }
            if ((attributionString = sharedPreferences.getString(ATTRIBUTION_ID_PREF, null)) != null && attributionString.length() > 0) {
                params.put("installAttribution", attributionString);
            }
            if ((referrersString = sharedPreferences.getString(EXTRA_REFERRERS_PREF, null)) != null) {
                params.put(EXTRA_REFERRERS_PREF, referrersString);
            }
            if ((uninstallToken = this.getProperty("afUninstallToken")) != null && (tokenObject = AFUninstallToken.parse(uninstallToken)) != null) {
                params.put("af_gcm_token", tokenObject.getToken());
            }
            this.isTokenRefreshServiceConfigured = UninstallUtils.didConfigureTokenRefreshService(context);
            AFLogger.afDebugLog("didConfigureTokenRefreshService=" + this.isTokenRefreshServiceConfigured);
            if (!this.isTokenRefreshServiceConfigured) {
                params.put("tokenRefreshConfigured", false);
            }
            if (isLaunchEvent) {
                if (this.pushPayload != null) {
                    JSONObject jsonPushPayload = new JSONObject(this.pushPayload);
                    jsonPushPayload.put("isPush", (Object)"true");
                    params.put("af_deeplink", jsonPushPayload.toString());
                }
                this.pushPayload = null;
            }
            if (isLaunchEvent && context instanceof Activity) {
                Uri uri = this.getDeepLinkUri(context);
                if (uri != null) {
                    this.handleDeepLinkCallback(context, params, uri);
                } else if (this.latestDeepLink != null) {
                    this.handleDeepLinkCallback(context, params, this.latestDeepLink);
                }
            }
            if (this.isRetargetingTestMode) {
                params.put("testAppMode_retargeting", "true");
                paramsJSON = new JSONObject(params);
                AppsFlyerLib.broadcastBacktoTestApp(context, paramsJSON.toString());
                AFLogger.afLog("Sent retargeting params to test app");
            }
            if (this.isInTestMode(context)) {
                params.put("testAppMode", "true");
                paramsJSON = new JSONObject(params);
                AppsFlyerLib.broadcastBacktoTestApp(context, paramsJSON.toString());
                AFLogger.afLog("Sent params to test app");
                this.endTestMode();
            }
            if (this.getProperty("advertiserId") == null) {
                AdvertisingIdUtil.addGoogleAID(context, params);
                if (this.getProperty("advertiserId") != null) {
                    params.put("GAID_retry", "true");
                } else {
                    params.put("GAID_retry", "false");
                }
            }
            if ((amazonAdvIdObject = AdvertisingIdUtil.getAmazonAID(context.getContentResolver())) != null) {
                params.put("amazon_aid", amazonAdvIdObject.getAdvertisingId());
                params.put("amazon_aid_limit", String.valueOf(amazonAdvIdObject.isLimitAdTracking()));
            }
            boolean sentSuccessfully = false;
            String referrerFromProperties = AppsFlyerProperties.getInstance().getReferrer(context);
            if (referrerFromProperties != null && referrerFromProperties.length() > 0 && params.get(REFERRER_PREF) == null) {
                params.put(REFERRER_PREF, referrerFromProperties);
            }
            sentSuccessfully = "true".equals(sharedPreferences.getString(SENT_SUCCESSFULLY_PREF, ""));
            int counter = this.getCounter(sharedPreferences, AF_COUNTER_PREF, isLaunchEvent);
            params.put("counter", Integer.toString(counter));
            params.put("iaecounter", Integer.toString(this.getCounter(sharedPreferences, AF_EVENT_COUNTER_PREF, eventName != null)));
            params.put("timepassedsincelastlaunch", Long.toString(this.getTimePassedSinceLastLaunch(context, true)));
            if (isLaunchEvent && counter == 1) {
                AppsFlyerProperties.getInstance().setFirstLaunchCalled();
            }
            params.put("isFirstCall", Boolean.toString(!sentSuccessfully));
            String hash = new HashUtils().getHashCode(params);
            params.put("af_v", hash);
            String hashV2 = new HashUtils().getHashCodeV2(params);
            params.put("af_v2", hashV2);
        }
        catch (Throwable e) {
            AFLogger.afLogE(e.getLocalizedMessage(), e);
        }
        return params;
    }

    private String getPushPayloadFromIntent(Context context) {
        Bundle bundle;
        Intent intent;
        String _pushPayload = null;
        if (context instanceof Activity && (intent = ((Activity)context).getIntent()) != null && (bundle = intent.getExtras()) != null && (_pushPayload = bundle.getString("af")) != null) {
            AFLogger.afLog("Push Notification received af payload = " + _pushPayload);
            bundle.remove("af");
            ((Activity)context).setIntent(intent.putExtras(bundle));
        }
        return _pushPayload;
    }

    private Uri getDeepLinkUri(Context context) {
        Uri res = null;
        Intent intent = ((Activity)context).getIntent();
        if (intent != null && "android.intent.action.VIEW".equals(intent.getAction())) {
            res = intent.getData();
        }
        return res;
    }

    private void handleDeepLinkCallback(Context context, Map<String, Object> params, Uri uri) {
        Map<Object, Object> attributionMap;
        params.put("af_deeplink", uri.toString());
        if (uri.getQueryParameter("af_deeplink") != null) {
            String media_source = uri.getQueryParameter("media_source");
            String is_retargeting = uri.getQueryParameter("is_retargeting");
            if (media_source != null && is_retargeting != null && media_source.equals("AppsFlyer_Test") && is_retargeting.equals("true")) {
                this.isRetargetingTestMode = true;
            }
            attributionMap = this.referrerStringToMap(context, uri.getQuery().toString());
            if (uri.getPath() != null) {
                attributionMap.put("path", uri.getPath());
            }
            if (uri.getScheme() != null) {
                attributionMap.put("scheme", uri.getScheme());
            }
            if (uri.getHost() != null) {
                attributionMap.put("host", uri.getHost());
            }
        } else {
            attributionMap = new HashMap<String, String>();
            attributionMap.put("link", uri.toString());
        }
        String json = new JSONObject(attributionMap).toString();
        this.saveDataToSharedPreferences(context, DEEPLINK_ATTR_PREF, json);
        if (conversionDataListener != null) {
            conversionDataListener.onAppOpenAttribution(attributionMap);
        }
    }

    private String generateOtherSDKsString() {
        return "" + this.numericBooleanIsClassExist("com.tune.Tune") + this.numericBooleanIsClassExist("com.adjust.sdk.Adjust") + this.numericBooleanIsClassExist("com.kochava.android.tracker.Feature") + this.numericBooleanIsClassExist("io.branch.referral.Branch") + this.numericBooleanIsClassExist("com.apsalar.sdk.Apsalar") + this.numericBooleanIsClassExist("com.localytics.android.Localytics") + this.numericBooleanIsClassExist("com.tenjin.android.TenjinSDK") + this.numericBooleanIsClassExist("com.talkingdata.sdk.TalkingDataSDK") + this.numericBooleanIsClassExist("it.partytrack.sdk.Track") + this.numericBooleanIsClassExist("jp.appAdForce.android.LtvManager");
    }

    private int numericBooleanIsClassExist(String className) {
        try {
            Class.forName(className);
            return 1;
        }
        catch (ClassNotFoundException ignored) {}
        finally {
            return 0;
        }
    }

    private void lastEventsProcessing(Context context, Map<String, Object> params, String newEventName, String newEventValue) {
        SharedPreferences sp = context.getSharedPreferences(AF_SHARED_PREF, 0);
        SharedPreferences.Editor editor = sp.edit();
        try {
            String previousEventName = sp.getString(PREV_EVENT_NAME, null);
            if (previousEventName != null) {
                JSONObject json = new JSONObject();
                json.put(PREV_EVENT_TIMESTAMP, (Object)(sp.getLong(PREV_EVENT_TIMESTAMP, -1L) + ""));
                json.put(PREV_EVENT_VALUE, (Object)sp.getString(PREV_EVENT_VALUE, null));
                json.put(PREV_EVENT_NAME, (Object)previousEventName);
                params.put(PREV_EVENT, json.toString());
            }
            editor.putString(PREV_EVENT_NAME, newEventName);
            editor.putString(PREV_EVENT_VALUE, newEventValue);
            editor.putLong(PREV_EVENT_TIMESTAMP, System.currentTimeMillis());
            this.editorCommit(editor);
        }
        catch (Exception e) {
            AFLogger.afLogE("Error while processing previous event.", e);
        }
    }

    boolean isGooglePlayServicesAvailable(Context context) {
        boolean retValue = false;
        try {
            int statusCode = GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(context);
            if (statusCode == 0) {
                retValue = true;
            }
        }
        catch (Throwable t) {
            AFLogger.afLogE("WARNING:  Google play services is unavailable. ", t);
        }
        return retValue;
    }

    private void addDeviceTracking(Context context, Map<String, Object> params) {
        boolean deviceTrackingDisabled = AppsFlyerProperties.getInstance().getBoolean("deviceTrackingDisabled", false);
        if (deviceTrackingDisabled) {
            params.put("deviceTrackingDisabled", "true");
        } else {
            SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
            boolean collectIMEI = AppsFlyerProperties.getInstance().getBoolean("collectIMEI", true);
            String cachedImei = sharedPreferences.getString(IMEI_CACHED_PREF, null);
            String imei = null;
            if (collectIMEI) {
                if (this.isIdCollectionAllowed(context)) {
                    try {
                        TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
                        String deviceImei = (String)manager.getClass().getMethod("getDeviceId", new Class[0]).invoke((Object)manager, new Object[0]);
                        if (deviceImei != null) {
                            imei = deviceImei;
                        } else if (this.userCustomImei != null) {
                            imei = this.userCustomImei;
                        } else if (cachedImei != null) {
                            imei = cachedImei;
                        }
                    }
                    catch (InvocationTargetException ignored) {
                        AFLogger.afWarnLog("WARNING: READ_PHONE_STATE is missing.");
                    }
                    catch (Exception e) {
                        AFLogger.afLogE("WARNING: READ_PHONE_STATE is missing. ", e);
                    }
                } else if (this.userCustomImei != null) {
                    imei = this.userCustomImei;
                }
            } else if (this.userCustomImei != null) {
                imei = this.userCustomImei;
            }
            if (imei != null) {
                this.saveDataToSharedPreferences(context, IMEI_CACHED_PREF, imei);
                params.put("imei", imei);
            } else {
                AFLogger.afLog("IMEI was not collected.");
            }
            boolean collectAndroidId = AppsFlyerProperties.getInstance().getBoolean("collectAndroidId", true);
            String cachedAndroidId = sharedPreferences.getString(ANDROID_ID_CACHED_PREF, null);
            String androidId = null;
            if (collectAndroidId) {
                if (this.isIdCollectionAllowed(context)) {
                    try {
                        String deviceAndroidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
                        if (deviceAndroidId != null) {
                            androidId = deviceAndroidId;
                        } else if (this.userCustomAndroidId != null) {
                            androidId = this.userCustomAndroidId;
                        } else if (cachedAndroidId != null) {
                            androidId = cachedAndroidId;
                        }
                    }
                    catch (Exception e) {
                        AFLogger.afLogE(e.getMessage(), e);
                    }
                } else if (this.userCustomAndroidId != null) {
                    androidId = this.userCustomAndroidId;
                }
            } else if (this.userCustomAndroidId != null) {
                androidId = this.userCustomAndroidId;
            }
            if (androidId != null) {
                this.saveDataToSharedPreferences(context, ANDROID_ID_CACHED_PREF, androidId);
                params.put("android_id", androidId);
            } else {
                AFLogger.afLog("Android ID was not collected.");
            }
        }
    }

    private boolean isIdCollectionAllowed(Context context) {
        return Build.VERSION.SDK_INT < 19 || !this.isGooglePlayServicesAvailable(context);
    }

    private boolean isAppsFlyerFirstLaunch(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
        return !sharedPreferences.contains(AF_COUNTER_PREF);
    }

    private String getCachedStore(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
        if (sharedPreferences.contains(INSTALL_STORE_PREF)) {
            return sharedPreferences.getString(INSTALL_STORE_PREF, null);
        }
        boolean isFirstLaunch = this.isAppsFlyerFirstLaunch(context);
        String store = isFirstLaunch ? this.getCurrentStore(context) : null;
        this.saveDataToSharedPreferences(context, INSTALL_STORE_PREF, store);
        return store;
    }

    private String getCurrentStore(Context context) {
        return this.getManifestMetaData(new WeakReference<Context>(context), "AF_STORE");
    }

    String getSystemProperty(String key) {
        String value = null;
        try {
            value = (String)Class.forName("android.os.SystemProperties").getMethod("get", String.class).invoke(null, key);
        }
        catch (Throwable e) {
            AFLogger.afLogE(e.getMessage(), e);
        }
        return value;
    }

    private String getManifestMetaData(WeakReference<Context> context, String key) {
        if (context.get() == null) {
            return null;
        }
        return this.getManifestMetaData(key, ((Context)context.get()).getPackageManager(), ((Context)context.get()).getPackageName());
    }

    private String getManifestMetaData(String key, PackageManager packageManager, String packageName) {
        String res = null;
        try {
            Object storeObj;
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(packageName, 128);
            Bundle bundle = applicationInfo.metaData;
            if (bundle != null && (storeObj = bundle.get(key)) != null) {
                res = storeObj.toString();
            }
        }
        catch (Throwable e) {
            AFLogger.afLogE("Could not find " + key + " value in the manifest", e);
        }
        return res;
    }

    private String preInstallValueFromFile(Context context) {
        String preInstallFilePathFromSysProp = this.getSystemProperty(PRE_INSTALL_SYSTEM_RO_PROP);
        File preInstallFile = this.getFileFromString(preInstallFilePathFromSysProp);
        if (this.isPreInstallFileInvalid(preInstallFile)) {
            String preInstallFilePathFromManifest = this.getManifestMetaData(AF_PRE_INSTALL_PATH, context.getPackageManager(), context.getPackageName());
            preInstallFile = this.getFileFromString(preInstallFilePathFromManifest);
        }
        if (this.isPreInstallFileInvalid(preInstallFile)) {
            preInstallFile = this.getFileFromString(PRE_INSTALL_SYSTEM_DEFAULT);
        }
        if (this.isPreInstallFileInvalid(preInstallFile)) {
            preInstallFile = this.getFileFromString(PRE_INSTALL_SYSTEM_DEFAULT_ETC);
        }
        if (this.isPreInstallFileInvalid(preInstallFile)) {
            return null;
        }
        String preInstallValue = this.extractPropertyFromFile(preInstallFile, context.getPackageName());
        if (preInstallValue != null) {
            return preInstallValue;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String extractPropertyFromFile(File preInstallFile, String propertyKey) {
        InputStreamReader reader = null;
        try {
            Properties props = new Properties();
            reader = new FileReader(preInstallFile);
            props.load(reader);
            AFLogger.afLog("Found PreInstall property!");
            String string = props.getProperty(propertyKey);
            return string;
        }
        catch (FileNotFoundException ignored) {
            AFLogger.afDebugLog("PreInstall file wasn't found: " + preInstallFile.getAbsolutePath());
        }
        catch (Throwable t) {
            AFLogger.afLogE(t.getMessage(), t);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Throwable t) {
                AFLogger.afLogE(t.getMessage(), t);
            }
        }
        return null;
    }

    private boolean isPreInstallFileInvalid(File preInstallFile) {
        return preInstallFile == null || !preInstallFile.exists();
    }

    private File getFileFromString(String filePath) {
        try {
            if (filePath != null && filePath.trim().length() > 0) {
                return new File(filePath.trim());
            }
        }
        catch (Throwable t) {
            AFLogger.afLogE(t.getMessage(), t);
        }
        return null;
    }

    private String getPreInstallName(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
        String result = this.getProperty(PRE_INSTALL_PREF);
        if (result != null) {
            return result;
        }
        if (sharedPreferences.contains(PRE_INSTALL_PREF)) {
            result = sharedPreferences.getString(PRE_INSTALL_PREF, null);
        } else {
            boolean isFirstLaunch = this.isAppsFlyerFirstLaunch(context);
            if (isFirstLaunch) {
                String valueFromFile = this.preInstallValueFromFile(context);
                result = valueFromFile != null ? valueFromFile : this.getManifestMetaData(new WeakReference<Context>(context), "AF_PRE_INSTALL_NAME");
            }
            if (result != null) {
                this.saveDataToSharedPreferences(context, PRE_INSTALL_PREF, result);
            }
        }
        if (result != null) {
            this.setProperty(PRE_INSTALL_PREF, result);
        }
        return result;
    }

    private void checkCache(Context context) {
        if (isDuringCheckCache || System.currentTimeMillis() - lastCacheCheck < 15000L) {
            return;
        }
        if (cacheScheduler != null) {
            return;
        }
        cacheScheduler = Executors.newSingleThreadScheduledExecutor();
        cacheScheduler.schedule(new CachedRequestSender(context), 1L, TimeUnit.SECONDS);
    }

    private String getConfiguredChannel(WeakReference<Context> context) {
        String channel = AppsFlyerProperties.getInstance().getString("channel");
        if (channel == null) {
            channel = this.getManifestMetaData(context, "CHANNEL");
        }
        return channel;
    }

    public boolean isPreInstalledApp(Context context) {
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 0);
            if ((applicationInfo.flags & 1) != 0) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            AFLogger.afLogE("Could not check if app is pre installed", e);
        }
        return false;
    }

    private String getCachedChannel(Context context, String currentChannel) throws PackageManager.NameNotFoundException {
        SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
        if (sharedPreferences.contains(CACHED_CHANNEL_PREF)) {
            return sharedPreferences.getString(CACHED_CHANNEL_PREF, null);
        }
        this.saveDataToSharedPreferences(context, CACHED_CHANNEL_PREF, currentChannel);
        return currentChannel;
    }

    private String getFirstInstallDate(SimpleDateFormat dateFormat, Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
        String firstLaunchDate = sharedPreferences.getString(FIRST_INSTALL_PREF, null);
        if (firstLaunchDate == null) {
            if (this.isAppsFlyerFirstLaunch(context)) {
                AFLogger.afDebugLog("AppsFlyer: first launch detected");
                firstLaunchDate = dateFormat.format(new Date());
            } else {
                firstLaunchDate = "";
            }
            this.saveDataToSharedPreferences(context, FIRST_INSTALL_PREF, firstLaunchDate);
        }
        AFLogger.afLog("AppsFlyer: first launch date: " + firstLaunchDate);
        return firstLaunchDate;
    }

    private void checkPlatform(Context context, Map<String, Object> params) {
        String sClassName = "com.unity3d.player.UnityPlayer";
        try {
            Class<?> classToInvestigate = Class.forName(sClassName);
            params.put("platformextension", "android_unity");
        }
        catch (ClassNotFoundException ignored) {
            params.put("platformextension", "android_native");
        }
        catch (Exception e) {
            AFLogger.afLogE(e.getMessage(), e);
        }
    }

    private void getSystemInfo(Map<String, Object> params) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("cpu_abi", this.getSystemProperty("ro.product.cpu.abi"));
        map.put("cpu_abi2", this.getSystemProperty("ro.product.cpu.abi2"));
        map.put("arch", this.getSystemProperty("os.arch"));
        map.put("build_display_id", this.getSystemProperty("ro.build.display.id"));
        JSONObject jsonData = new JSONObject(map);
        params.put("deviceData", jsonData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAttributionId(ContentResolver contentResolver) {
        String[] projection = new String[]{ATTRIBUTION_ID_COLUMN_NAME};
        Cursor cursor = contentResolver.query(Uri.parse((String)ATTRIBUTION_ID_CONTENT_URI), projection, null, null, null);
        String attributionId = null;
        try {
            if (cursor == null || !cursor.moveToFirst()) {
                String string = null;
                return string;
            }
            attributionId = cursor.getString(cursor.getColumnIndex(ATTRIBUTION_ID_COLUMN_NAME));
        }
        catch (Exception e) {
            AFLogger.afLogE("Could not collect cursor attribution. ", e);
        }
        finally {
            try {
                if (cursor != null) {
                    cursor.close();
                }
            }
            catch (Exception e) {
                AFLogger.afLogE(e.getMessage(), e);
            }
        }
        return attributionId;
    }

    private int getCounter(SharedPreferences sharedPreferences, String parameterName, boolean isIncrease) {
        int counter = sharedPreferences.getInt(parameterName, 0);
        if (isIncrease) {
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putInt(parameterName, ++counter);
            this.editorCommit(editor);
        }
        return counter;
    }

    private long getTimePassedSinceLastLaunch(Context context, boolean shouldSave) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
        long lastLaunchTime = sharedPreferences.getLong(AF_TIME_PASSED_SINCE_LAST_LAUNCH, 0L);
        long currentTime = System.currentTimeMillis();
        long timeInterval = lastLaunchTime > 0L ? currentTime - lastLaunchTime : -1L;
        if (shouldSave) {
            this.saveLongToSharedPreferences(context, AF_TIME_PASSED_SINCE_LAST_LAUNCH, currentTime);
        }
        return timeInterval / 1000L;
    }

    @Deprecated
    String getUniquePsuedoID() {
        String m_szDevIDShort = "35" + Build.BOARD.length() % 10 + Build.BRAND.length() % 10 + Build.CPU_ABI.length() % 10 + Build.DEVICE.length() % 10 + Build.MANUFACTURER.length() % 10 + Build.MODEL.length() % 10 + Build.PRODUCT.length() % 10;
        try {
            String serial = Build.class.getField("SERIAL").get(null).toString();
            return new UUID(m_szDevIDShort.hashCode(), serial.hashCode()).toString();
        }
        catch (Exception e) {
            AFLogger.afLogE(e.getMessage(), e);
            String serial = "serial";
            return new UUID(m_szDevIDShort.hashCode(), serial.hashCode()).toString();
        }
    }

    private String getNetwork(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
        if (activeNetwork != null) {
            if (activeNetwork.getType() == 1) {
                return "WIFI";
            }
            if (activeNetwork.getType() == 0) {
                return "MOBILE";
            }
        }
        return "unknown";
    }

    public String getAppsFlyerUID(Context context) {
        RemoteDebuggingManager.getInstance().addApiEvent("getAppsFlyerUID", new String[0]);
        return Installation.id(new WeakReference<Context>(context));
    }

    private void sendRequestToServer(String urlString, String postDataString, String afDevKey, WeakReference<Context> ctxReference, String cacheKey, boolean isLaunch) throws IOException {
        URL url = new URL(urlString);
        AFLogger.afLog("url: " + url.toString());
        this.debugAction(CALL_SERVER_ACTION, "\n" + url.toString() + "\nPOST:" + postDataString, (Context)ctxReference.get());
        LogMessages.logMessageMaskKey("data: " + postDataString);
        this.monitor((Context)ctxReference.get(), LOG_TAG, "EVENT_DATA", postDataString);
        try {
            this.callServer(url, postDataString, afDevKey, ctxReference, cacheKey, isLaunch);
        }
        catch (IOException e) {
            AFLogger.afLogE("Exception in sendRequestToServer. ", e);
            boolean useHttpFallback = AppsFlyerProperties.getInstance().getBoolean("useHttpFallback", false);
            if (useHttpFallback) {
                this.debugAction("https failed: " + e.getLocalizedMessage(), "", (Context)ctxReference.get());
                this.callServer(new URL(urlString.replace("https:", "http:")), postDataString, afDevKey, ctxReference, cacheKey, isLaunch);
            }
            AFLogger.afLog("failed to send requeset to server. " + e.getLocalizedMessage());
            this.monitor((Context)ctxReference.get(), LOG_TAG, "ERROR", e.getLocalizedMessage());
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callServer(URL url, String postData, String appsFlyerDevKey, WeakReference<Context> ctxReference, String cacheKey, boolean isLaunch) throws IOException {
        block25: {
            Context context = (Context)ctxReference.get();
            boolean shouldRequestConversion = isLaunch && conversionDataListener != null;
            HttpURLConnection connection = null;
            try {
                RemoteDebuggingManager.getInstance().addServerRequestEvent(url.toString(), postData);
                connection = (HttpsURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                int contentLength = postData.getBytes().length;
                connection.setRequestProperty("Content-Length", contentLength + "");
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setConnectTimeout(10000);
                connection.setDoOutput(true);
                try (OutputStreamWriter out = null;){
                    out = new OutputStreamWriter(connection.getOutputStream(), "UTF-8");
                    out.write(postData);
                }
                int statusCode = connection.getResponseCode();
                String response = this.readServerResponse(connection);
                RemoteDebuggingManager.getInstance().addServerResponseEvent(url.toString(), statusCode, response);
                AFLogger.afLogM("response code: " + statusCode);
                this.monitor(context, LOG_TAG, "SERVER_RESPONSE_CODE", Integer.toString(statusCode));
                this.debugAction(SERVER_RESPONDED_ACTION, Integer.toString(statusCode), context);
                SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
                if (statusCode == 200) {
                    if (this.getProperty("gcmProjectNumber") != null && this.getProperty("afUninstallToken") == null) {
                        UninstallUtils.registerDeviceForUninstalls(new WeakReference<Context>(context));
                    }
                    if (this.latestDeepLink != null) {
                        this.latestDeepLink = null;
                    }
                    if (cacheKey != null) {
                        CacheManager.getInstance().deleteRequest(cacheKey, context);
                    }
                    if (ctxReference.get() != null && cacheKey == null) {
                        this.saveDataToSharedPreferences(context, SENT_SUCCESSFULLY_PREF, "true");
                        this.checkCache(context);
                    }
                    try {
                        JSONObject responseJSON = new JSONObject(response);
                        boolean remoteDebuggingServerFlag = responseJSON.optBoolean("monitor", false);
                        if (remoteDebuggingServerFlag) {
                            RemoteDebuggingManager.getInstance().startRemoteDebuggingMode();
                        } else {
                            RemoteDebuggingManager.getInstance().dropPreLaunchDebugData();
                            RemoteDebuggingManager.getInstance().stopRemoteDebuggingMode();
                        }
                    }
                    catch (JSONException ignored) {
                        RemoteDebuggingManager.getInstance().dropPreLaunchDebugData();
                        RemoteDebuggingManager.getInstance().stopRemoteDebuggingMode();
                    }
                    catch (Throwable t) {
                        AFLogger.afLogE(t.getMessage(), t);
                        RemoteDebuggingManager.getInstance().dropPreLaunchDebugData();
                        RemoteDebuggingManager.getInstance().stopRemoteDebuggingMode();
                    }
                }
                int retries = sharedPreferences.getInt(CONVERSION_REQUEST_RETRIES, 0);
                long conversionDataCachedExpiration = sharedPreferences.getLong(CONVERSION_DATA_CACHE_EXPIRATION, 0L);
                if (conversionDataCachedExpiration != 0L && System.currentTimeMillis() - conversionDataCachedExpiration > 5184000000L) {
                    this.saveDataToSharedPreferences(context, ATTRIBUTION_ID_PREF, null);
                    this.saveLongToSharedPreferences(context, CONVERSION_DATA_CACHE_EXPIRATION, 0L);
                }
                if (sharedPreferences.getString(ATTRIBUTION_ID_PREF, null) == null && appsFlyerDevKey != null && shouldRequestConversion && conversionDataListener != null && retries <= 5) {
                    ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
                    scheduler.schedule(new InstallAttributionIdFetcher(context.getApplicationContext(), appsFlyerDevKey, scheduler), 10L, TimeUnit.MILLISECONDS);
                    break block25;
                }
                if (appsFlyerDevKey == null) {
                    AFLogger.afWarnLog("AppsFlyer dev key is missing.");
                    break block25;
                }
                if (!shouldRequestConversion || conversionDataListener == null || sharedPreferences.getString(ATTRIBUTION_ID_PREF, null) == null || this.getCounter(sharedPreferences, AF_COUNTER_PREF, false) <= 1) break block25;
                try {
                    Map<String, String> conversionData = this.getConversionData(context);
                    if (conversionData != null) {
                        conversionDataListener.onInstallConversionDataLoaded(conversionData);
                    }
                }
                catch (AttributionIDNotReady ae) {
                    AFLogger.afLogE(ae.getMessage(), ae);
                }
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
    }

    public void validateAndTrackInAppPurchase(Context context, String publicKey, String signature, String purchaseData, String price, String currency, HashMap<String, String> additionalParameters) {
        RemoteDebuggingManager.getInstance().addApiEvent("validateAndTrackInAppPurchase", publicKey, signature, purchaseData, price, currency, additionalParameters == null ? "" : additionalParameters.toString());
        AFLogger.afLog("Validate in app called with parameters: " + purchaseData + " " + price + " " + currency);
        if (publicKey == null || price == null || signature == null || currency == null || purchaseData == null) {
            if (validatorListener != null) {
                validatorListener.onValidateInAppFailure("Please provide purchase parameters");
            }
        } else {
            ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
            scheduler.schedule(new AFValidateInAppPurchase(context.getApplicationContext(), this.getProperty("AppsFlyerKey"), publicKey, signature, purchaseData, price, currency, additionalParameters, scheduler), 10L, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String readServerResponse(HttpURLConnection connection) {
        BufferedReader reader = null;
        StringBuilder stringBuilder = new StringBuilder();
        InputStreamReader inputStreamReader = null;
        try {
            String line;
            InputStream responseStream = connection.getErrorStream();
            if (responseStream == null) {
                responseStream = connection.getInputStream();
            }
            inputStreamReader = new InputStreamReader(responseStream);
            reader = new BufferedReader(inputStreamReader);
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line).append('\n');
            }
        }
        catch (Throwable t) {
            AFLogger.afLogE("Could not read connection response from: " + connection.getURL().toString(), t);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
            catch (Throwable responseStream) {}
        }
        String result = stringBuilder.toString();
        try {
            new JSONObject(result);
            return result;
        }
        catch (JSONException e) {
            JSONObject json = new JSONObject();
            try {
                json.put(RESPONSE_NOT_JSON, (Object)result);
                return json.toString();
            }
            catch (JSONException e1) {
                return new JSONObject().toString();
            }
        }
    }

    float getBatteryLevel(Context context) {
        float result = 1.0f;
        try {
            Intent batteryIntent = context.getApplicationContext().registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
            int level = batteryIntent.getIntExtra("level", -1);
            int scale = batteryIntent.getIntExtra("scale", -1);
            if (level == -1 || scale == -1) {
                return 50.0f;
            }
            result = (float)level / (float)scale * 100.0f;
        }
        catch (Throwable t) {
            AFLogger.afLogE(t.getMessage(), t);
        }
        return result;
    }

    static {
        cacheScheduler = null;
        instance = new AppsFlyerLib();
    }

    private class CachedRequestSender
    implements Runnable {
        private WeakReference<Context> ctxReference = null;

        public CachedRequestSender(Context context) {
            this.ctxReference = new WeakReference<Context>(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (isDuringCheckCache) {
                return;
            }
            lastCacheCheck = System.currentTimeMillis();
            if (this.ctxReference == null) {
                return;
            }
            isDuringCheckCache = true;
            try {
                String afDevKey = AppsFlyerLib.this.getProperty("AppsFlyerKey");
                WeakReference<Context> weakReference = this.ctxReference;
                synchronized (weakReference) {
                    for (RequestCacheData requestCacheData : CacheManager.getInstance().getCachedRequests((Context)this.ctxReference.get())) {
                        AFLogger.afLog("resending request: " + requestCacheData.getRequestURL());
                        try {
                            long currentTime = System.currentTimeMillis();
                            String cachedTimeString = requestCacheData.getCacheKey();
                            long cachedTime = Long.parseLong(cachedTimeString, 10);
                            AppsFlyerLib.this.sendRequestToServer(requestCacheData.getRequestURL() + AppsFlyerLib.CACHED_URL_PARAMETER + Long.toString((currentTime - cachedTime) / 1000L), requestCacheData.getPostData(), afDevKey, this.ctxReference, requestCacheData.getCacheKey(), false);
                        }
                        catch (Exception e) {
                            AFLogger.afLogE("Failed to resend cached request", e);
                        }
                    }
                }
            }
            catch (Exception e) {
                AFLogger.afLogE("failed to check cache. ", e);
            }
            finally {
                isDuringCheckCache = false;
            }
            cacheScheduler.shutdown();
            cacheScheduler = null;
        }
    }

    private abstract class AttributionIdFetcher
    implements Runnable {
        protected WeakReference<Context> ctxReference = null;
        private String appsFlyerDevKey;
        private ScheduledExecutorService executorService;
        private AtomicInteger currentRequestsCounter = new AtomicInteger(0);

        protected abstract void attributionCallback(Map<String, String> var1);

        public abstract String getUrl();

        protected abstract void attributionCallbackFailure(String var1, int var2);

        public AttributionIdFetcher(Context context, String appsFlyerDevKey, ScheduledExecutorService executorService) {
            this.ctxReference = new WeakReference<Context>(context);
            this.appsFlyerDevKey = appsFlyerDevKey;
            this.executorService = executorService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block18: {
                if (this.appsFlyerDevKey == null || this.appsFlyerDevKey.length() == 0) {
                    return;
                }
                this.currentRequestsCounter.incrementAndGet();
                HttpURLConnection connection = null;
                try {
                    Context context = (Context)this.ctxReference.get();
                    if (context == null) {
                        return;
                    }
                    long now = System.currentTimeMillis();
                    String channel = AppsFlyerLib.this.getCachedChannel(context, AppsFlyerLib.this.getConfiguredChannel(new WeakReference<Context>(context)));
                    String channelPostfix = "";
                    if (channel != null) {
                        channelPostfix = "-" + channel;
                    }
                    StringBuilder urlString = new StringBuilder().append(this.getUrl()).append(context.getPackageName()).append(channelPostfix).append("?devkey=").append(this.appsFlyerDevKey).append("&device_id=").append(Installation.id(new WeakReference<Context>(context)));
                    RemoteDebuggingManager.getInstance().addServerRequestEvent(urlString.toString(), "");
                    LogMessages.logMessageMaskKey("Calling server for attribution url: " + urlString.toString());
                    connection = (HttpsURLConnection)new URL(urlString.toString()).openConnection();
                    connection.setRequestMethod("GET");
                    connection.setConnectTimeout(10000);
                    connection.setRequestProperty("Connection", "close");
                    connection.connect();
                    int responseCode = connection.getResponseCode();
                    String response = AppsFlyerLib.this.readServerResponse(connection);
                    RemoteDebuggingManager.getInstance().addServerResponseEvent(urlString.toString(), responseCode, response);
                    if (responseCode == 200) {
                        Map conversionData;
                        String conversionJsonString;
                        long responseTime = System.currentTimeMillis();
                        AppsFlyerLib.this.saveLongToSharedPreferences(context, AppsFlyerLib.GET_CONVERSION_DATA_TIME, (responseTime - now) / 1000L);
                        LogMessages.logMessageMaskKey("Attribution data: " + response);
                        if (response.length() <= 0 || context == null) break block18;
                        Map conversionDataMap = AppsFlyerLib.this.attributionStringToMap(response);
                        String isCache = (String)conversionDataMap.get("iscache");
                        if (isCache != null && "false".equals(isCache)) {
                            AppsFlyerLib.this.saveLongToSharedPreferences(context, AppsFlyerLib.CONVERSION_DATA_CACHE_EXPIRATION, System.currentTimeMillis());
                        }
                        if ((conversionJsonString = new JSONObject(conversionDataMap).toString()) != null) {
                            AppsFlyerLib.this.saveDataToSharedPreferences(context, AppsFlyerLib.ATTRIBUTION_ID_PREF, conversionJsonString);
                        } else {
                            AppsFlyerLib.this.saveDataToSharedPreferences(context, AppsFlyerLib.ATTRIBUTION_ID_PREF, response);
                        }
                        AFLogger.afDebugLog("iscache=" + isCache + " caching conversion data");
                        if (conversionDataListener == null || this.currentRequestsCounter.intValue() > 1) break block18;
                        try {
                            conversionData = AppsFlyerLib.this.getConversionData(context);
                        }
                        catch (AttributionIDNotReady ae) {
                            AFLogger.afLogE("Exception while trying to fetch attribution data. ", ae);
                            conversionData = conversionDataMap;
                        }
                        this.attributionCallback(conversionData);
                        break block18;
                    }
                    if (conversionDataListener != null) {
                        this.attributionCallbackFailure("Error connection to server: " + responseCode, responseCode);
                    }
                    LogMessages.logMessageMaskKey("AttributionIdFetcher response code: " + responseCode + "  url: " + urlString);
                }
                catch (Throwable t) {
                    if (conversionDataListener != null) {
                        this.attributionCallbackFailure(t.getMessage(), 0);
                    }
                    AFLogger.afLogE(t.getMessage(), t);
                }
                finally {
                    this.currentRequestsCounter.decrementAndGet();
                    if (connection != null) {
                        connection.disconnect();
                    }
                }
            }
            this.executorService.shutdown();
        }
    }

    private class InstallAttributionIdFetcher
    extends AttributionIdFetcher {
        public InstallAttributionIdFetcher(Context context, String appsFlyerDevKey, ScheduledExecutorService executorService) {
            super(context, appsFlyerDevKey, executorService);
        }

        @Override
        public String getUrl() {
            return AppsFlyerLib.CONVERSION_DATA_URL;
        }

        @Override
        protected void attributionCallback(Map<String, String> conversionData) {
            conversionDataListener.onInstallConversionDataLoaded(conversionData);
            SharedPreferences sharedPreferences = ((Context)this.ctxReference.get()).getSharedPreferences(AppsFlyerLib.AF_SHARED_PREF, 0);
            AppsFlyerLib.this.saveIntegerToSharedPreferences((Context)this.ctxReference.get(), AppsFlyerLib.CONVERSION_REQUEST_RETRIES, 0);
        }

        @Override
        protected void attributionCallbackFailure(String error, int responseCode) {
            conversionDataListener.onInstallConversionFailure(error);
            if (responseCode >= 400 && responseCode < 500) {
                SharedPreferences sharedPreferences = ((Context)this.ctxReference.get()).getSharedPreferences(AppsFlyerLib.AF_SHARED_PREF, 0);
                int retries = sharedPreferences.getInt(AppsFlyerLib.CONVERSION_REQUEST_RETRIES, 0);
                AppsFlyerLib.this.saveIntegerToSharedPreferences((Context)this.ctxReference.get(), AppsFlyerLib.CONVERSION_REQUEST_RETRIES, ++retries);
            }
        }
    }

    private class SendToServerRunnable
    implements Runnable {
        private String urlString;
        private WeakReference<Context> ctxReference = null;
        Map<String, Object> params;
        boolean isLaunch;

        private SendToServerRunnable(String urlString, Map<String, Object> params, Context ctx, boolean isLaunch) {
            this.urlString = urlString;
            this.params = params;
            this.ctxReference = new WeakReference<Context>(ctx);
            this.isLaunch = isLaunch;
        }

        @Override
        public void run() {
            String postDataString = null;
            try {
                String afDevKey = (String)this.params.get("appsflyerKey");
                postDataString = new JSONObject(this.params).toString();
                AppsFlyerLib.this.sendRequestToServer(this.urlString, postDataString, afDevKey, this.ctxReference, null, this.isLaunch);
            }
            catch (IOException e) {
                AFLogger.afLogE("Exception while sending request to server. ", e);
                if (postDataString != null && this.ctxReference != null && !this.urlString.contains(AppsFlyerLib.CACHED_URL_PARAMETER)) {
                    CacheManager.getInstance().cacheRequest(new RequestCacheData(this.urlString, postDataString, AppsFlyerLib.BUILD_NUMBER), (Context)this.ctxReference.get());
                    AFLogger.afLogE(e.getMessage(), e);
                }
            }
            catch (Throwable t) {
                AFLogger.afLogE(t.getMessage(), t);
            }
        }
    }

    private class DataCollector
    implements Runnable {
        private WeakReference<Context> context;
        private String appsFlyerKey;
        private String eventName;
        private String eventValue;
        private String referrer;
        private ExecutorService executor;
        private boolean isNewAPI;

        private DataCollector(WeakReference<Context> context, String appsFlyerKey, String eventName, String eventValue, String referrer, boolean useNewAPI, ExecutorService executorService) {
            this.context = context;
            this.appsFlyerKey = appsFlyerKey;
            this.eventName = eventName;
            this.eventValue = eventValue;
            this.referrer = referrer;
            this.isNewAPI = useNewAPI;
            this.executor = executorService;
        }

        @Override
        public void run() {
            AppsFlyerLib.this.sendTrackingWithEvent((Context)this.context.get(), this.appsFlyerKey, this.eventName, this.eventValue, this.referrer, this.isNewAPI);
            this.executor.shutdown();
        }
    }
}

