/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

class AdvertisingIdObject {
    private static final String SEPARATOR = ",";
    private IdType type;
    private String advertisingId;
    private boolean limitAdTracking;

    AdvertisingIdObject(IdType type, String advertisingId, boolean limitAdTracking) {
        this.type = type;
        this.advertisingId = advertisingId;
        this.limitAdTracking = limitAdTracking;
    }

    AdvertisingIdObject(String fromString) {
        if (fromString == null) {
            return;
        }
        String[] aidData = fromString.split(SEPARATOR);
        if (aidData.length >= 3) {
            this.type = IdType.fromString(aidData[0]);
            this.advertisingId = aidData[1];
            this.limitAdTracking = Boolean.valueOf(aidData[2]);
        }
    }

    String getAdvertisingId() {
        return this.advertisingId;
    }

    void setAdvertisingId(String advertisingId) {
        this.advertisingId = advertisingId;
    }

    boolean isLimitAdTracking() {
        return this.limitAdTracking;
    }

    void setLimitAdTracking(boolean limitAdTracking) {
        this.limitAdTracking = limitAdTracking;
    }

    IdType getType() {
        return this.type;
    }

    void setType(IdType type) {
        this.type = type;
    }

    public String toString() {
        return String.format("%s,%s", this.advertisingId, this.limitAdTracking);
    }

    boolean isValid(IdType type) {
        return type.intValue == this.type.intValue && this.advertisingId != null && this.advertisingId.length() > 0;
    }

    static enum IdType {
        GOOGLE(0),
        AMAZON(1);

        private int intValue;

        private IdType(int intValue) {
            this.intValue = intValue;
        }

        public static IdType fromString(String text) {
            if (text != null) {
                for (IdType idType : IdType.values()) {
                    if (Integer.valueOf(text) != idType.intValue) continue;
                    return idType;
                }
            }
            return null;
        }

        public String toString() {
            return String.valueOf(this.intValue);
        }
    }
}

