/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

class AFUninstallToken {
    private static final int TOKEN_AGING_TIME = 2000;
    private static final String SEPARATOR = ",";
    private final Object lock = new Object();
    private long tokenTimestamp = 0L;
    private String token = "";

    AFUninstallToken(long tokenTimestamp, String token) {
        this.tokenTimestamp = tokenTimestamp;
        this.token = token;
    }

    AFUninstallToken(String token) {
        this(System.currentTimeMillis(), token);
    }

    static AFUninstallToken parse(String fromString) {
        if (fromString == null) {
            return AFUninstallToken.getEmptyUninstallToken();
        }
        String[] values = fromString.split(SEPARATOR);
        if (values.length < 2) {
            return AFUninstallToken.getEmptyUninstallToken();
        }
        return new AFUninstallToken(Long.parseLong(values[0]), values[1]);
    }

    private static AFUninstallToken getEmptyUninstallToken() {
        return new AFUninstallToken(0L, "");
    }

    boolean testAndUpdate(AFUninstallToken token) {
        if (token != null) {
            return this.testAndUpdate(token.getTokenTimestamp(), token.getToken());
        }
        AFUninstallToken emptyToken = AFUninstallToken.getEmptyUninstallToken();
        return this.testAndUpdate(emptyToken.tokenTimestamp, emptyToken.getToken());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testAndUpdate(long newTokenTimestamp, String newToken) {
        Object object = this.lock;
        synchronized (object) {
            if (newToken != null && !newToken.equals(this.token) && this.didExistingTokenAge(newTokenTimestamp)) {
                this.tokenTimestamp = newTokenTimestamp;
                this.token = newToken;
                return true;
            }
            return false;
        }
    }

    private boolean didExistingTokenAge(long newTokenTimestamp) {
        return newTokenTimestamp - this.tokenTimestamp > 2000L;
    }

    public String toString() {
        return this.tokenTimestamp + SEPARATOR + this.token;
    }

    private long getTokenTimestamp() {
        return this.tokenTimestamp;
    }

    String getToken() {
        return this.token;
    }
}

