/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.util.Log;
import com.appsflyer.AppsFlyerProperties;
import com.appsflyer.RemoteDebuggingManager;

class AFLogger {
    private static final String LOG_TAG = "AppsFlyer_4.7.1";

    AFLogger() {
    }

    static void afLog(String logMessage, boolean shouldRemoteDebug) {
        if (AFLogger.shouldLog()) {
            Log.i((String)LOG_TAG, (String)logMessage);
        }
        if (shouldRemoteDebug) {
            RemoteDebuggingManager.getInstance().addLogEntry("I", logMessage);
        }
    }

    static void afDebugLog(String debugLogMessage, boolean shouldRemoteDebug) {
        if (AFLogger.shouldLog()) {
            Log.d((String)LOG_TAG, (String)debugLogMessage);
        }
        if (shouldRemoteDebug) {
            RemoteDebuggingManager.getInstance().addLogEntry("D", debugLogMessage);
        }
    }

    static void afLogE(String errorLogMessage, Throwable ex, boolean shouldRemoteDebug, boolean shouldOutputToLog) {
        if (AFLogger.shouldLog() && shouldOutputToLog) {
            Log.e((String)LOG_TAG, (String)errorLogMessage, (Throwable)ex);
        }
        if (shouldRemoteDebug) {
            RemoteDebuggingManager.getInstance().addExceptionEvent(ex);
        }
    }

    static void afWarnLog(String warningLogMessage, boolean shouldRemoteDebug) {
        if (AFLogger.shouldLog()) {
            Log.w((String)LOG_TAG, (String)warningLogMessage);
        }
        if (shouldRemoteDebug) {
            RemoteDebuggingManager.getInstance().addLogEntry("W", warningLogMessage);
        }
    }

    private static boolean shouldLog() {
        return AppsFlyerProperties.getInstance().isEnableLog();
    }

    static void afLogM(String logMessage) {
        if (!AFLogger.noLogsAllowed()) {
            Log.d((String)LOG_TAG, (String)logMessage);
        }
        RemoteDebuggingManager.getInstance().addLogEntry("M", logMessage);
    }

    private static boolean noLogsAllowed() {
        return AppsFlyerProperties.getInstance().isLogsDisabledCompletely();
    }

    static void afDebugLog(String debugLogMessage) {
        AFLogger.afDebugLog(debugLogMessage, true);
    }

    static void afLog(String logMessage) {
        AFLogger.afLog(logMessage, true);
    }

    static void afLogE(String errorLogMessage, Throwable ex) {
        AFLogger.afLogE(errorLogMessage, ex, true, false);
    }

    static void afWarnLog(String warningLogMessage) {
        AFLogger.afWarnLog(warningLogMessage, true);
    }
}

