/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.content.pm.PackageManager;
import android.os.Build;
import com.appsflyer.AppsFlyerLib;
import com.appsflyer.AppsFlyerProperties;
import com.appsflyer.e;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class j {
    private static j instance;
    private static boolean shouldCollectPreLaunchDebugData;
    private static boolean shouldEnableRemoteDebuggingForThisApp;
    private final String DEVICE_DATA_BRAND = "brand";
    private final String DEVICE_DATA_MODEL = "model";
    private final String DEVICE_DATA_PLATFORM_NAME = "platform";
    private final String DEVICE_DATA_PLATFORM_VERSION = "platform_version";
    private final String DEVICE_DATA_GAID = "advertiserId";
    private final String DEVICE_DATA_IMEI = "imei";
    private final String DEVICE_DATA_ANDROID_ID = "android_id";
    private final String SDK_DATA_SDK_VERSION = "sdk_version";
    private final String SDK_DATA_DEV_KEY = "devkey";
    private final String SDK_DATA_ORIGINAL_AF_UID = "originalAppsFlyerId";
    private final String SDK_DATA_CURRENT_AF_UID = "uid";
    private final String APP_DATA_APP_ID = "app_id";
    private final String APP_DATA_APP_VERSION = "app_version";
    private final String APP_DATA_CHANNEL = "channel";
    private final String APP_DATA_PRE_INSTALL = "preInstall";
    private final String CHRONOLOGICAL_EVENTS_DATA = "data";
    private final String REMOTE_DEBUGGING_STOPPED = "r_debugging_off";
    private final String REMOTE_DEBUGGING_STARTED = "r_debugging_on";
    private final String PUBLIC_API_CALL = "public_api_call";
    private final String EXCEPTION = "exception";
    private final String SERVER_REQUEST = "server_request";
    private final String SERVER_RESPONSE = "server_response";
    private final String BQ_DATE_FORMAT = "yyyy-MM-dd HH:mm:ssZ";
    private final String EVENT_DATE_FORMAT = "MM-dd HH:mm:ss.SSS";
    private JSONObject remoteDebuggingJSON;
    private JSONArray chronologicalEvents = new JSONArray();
    private int requestSize = 0;
    private boolean remoteDebuggingEnabledFromServer = false;

    private j() {
    }

    static j getInstance() {
        if (instance == null) {
            instance = new j();
        }
        return instance;
    }

    final synchronized void startRemoteDebuggingMode() {
        this.remoteDebuggingEnabledFromServer = true;
        this.addStartEvent(System.currentTimeMillis());
    }

    final synchronized void stopRemoteDebuggingMode() {
        this.addStopEvent(System.currentTimeMillis());
        this.remoteDebuggingEnabledFromServer = false;
        shouldCollectPreLaunchDebugData = false;
    }

    final synchronized void releaseRemoteDebugging() {
        this.remoteDebuggingJSON = null;
        this.chronologicalEvents = null;
        instance = null;
    }

    /*
     * WARNING - void declaration
     */
    final void sendRemoteDebuggingData(String packageName, PackageManager packageManager) {
        try {
            void var1_1;
            String string;
            j.getInstance().loadStaticData(packageName, (PackageManager)string);
            string = j.getInstance().getJSONString(true);
            e e2 = new e(null);
            new e(null).bodyAsString = string;
            e2.setRemoteDebugMode(false);
            e2.execute(new String[]{"https://monitorsdk.appsflyer.com/remote-debug?app_id=" + (String)var1_1});
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    final boolean isRemoteDebugging() {
        return shouldEnableRemoteDebuggingForThisApp && (shouldCollectPreLaunchDebugData || this.remoteDebuggingEnabledFromServer);
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void setDeviceData(String brand, String model, String osVersion, String gaid, String imei, String androidId) {
        try {
            void var3_3;
            void var2_2;
            void var1_1;
            this.remoteDebuggingJSON.put("brand", (Object)var1_1);
            this.remoteDebuggingJSON.put("model", (Object)var2_2);
            this.remoteDebuggingJSON.put("platform", (Object)"Android");
            this.remoteDebuggingJSON.put("platform_version", (Object)var3_3);
            if (gaid != null && gaid.length() > 0) {
                this.remoteDebuggingJSON.put("advertiserId", (Object)gaid);
            }
            if (imei != null && imei.length() > 0) {
                this.remoteDebuggingJSON.put("imei", (Object)imei);
            }
            if (androidId != null && androidId.length() > 0) {
                this.remoteDebuggingJSON.put("android_id", (Object)androidId);
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void setSDKData(String version, String devKey, String originalAFUID, String currentAFUID) {
        try {
            void var1_1;
            this.remoteDebuggingJSON.put("sdk_version", (Object)var1_1);
            if (devKey != null && devKey.length() > 0) {
                void var2_2;
                this.remoteDebuggingJSON.put("devkey", (Object)var2_2);
            }
            if (originalAFUID != null && originalAFUID.length() > 0) {
                void var3_3;
                this.remoteDebuggingJSON.put("originalAppsFlyerId", (Object)var3_3);
            }
            if (currentAFUID != null && currentAFUID.length() > 0) {
                this.remoteDebuggingJSON.put("uid", (Object)currentAFUID);
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void setAppData(String appId, String appVersion, String channel, String preInstall) {
        try {
            if (appId != null && appId.length() > 0) {
                void var1_1;
                this.remoteDebuggingJSON.put("app_id", (Object)var1_1);
            }
            if (appVersion != null && appVersion.length() > 0) {
                void var2_2;
                this.remoteDebuggingJSON.put("app_version", (Object)var2_2);
            }
            if (channel != null && channel.length() > 0) {
                void var3_3;
                this.remoteDebuggingJSON.put("channel", (Object)var3_3);
            }
            if (preInstall != null && preInstall.length() > 0) {
                this.remoteDebuggingJSON.put("preInstall", (Object)preInstall);
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addStartEvent(long startTime) {
        void var1_1;
        this.addEvent("r_debugging_on", new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ", Locale.ENGLISH).format((long)var1_1), new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    private void addStopEvent(long endTime) {
        void var1_1;
        this.addEvent("r_debugging_off", new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ", Locale.ENGLISH).format((long)var1_1), new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    final void addApiEvent(String methodName, String ... args) {
        void var2_2;
        void var1_1;
        this.addEvent("public_api_call", (String)var1_1, (String[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    final void addExceptionEvent(Throwable t) {
        void var1_1;
        Throwable throwable = t.getCause();
        this.addEvent("exception", t.getClass().getSimpleName(), this.getThrowableStringData(throwable == null ? t.getMessage() : throwable.getMessage(), throwable == null ? var1_1.getStackTrace() : throwable.getStackTrace()));
    }

    /*
     * WARNING - void declaration
     */
    final void addServerRequestEvent(String url, String requestBody) {
        void var2_2;
        void var1_1;
        this.addEvent("server_request", (String)var1_1, new String[]{var2_2});
    }

    /*
     * WARNING - void declaration
     */
    final void addServerResponseEvent(String url, int responseCode, String responseBody) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.addEvent("server_response", (String)var1_1, new String[]{String.valueOf((int)var2_2), var3_3});
    }

    /*
     * WARNING - void declaration
     */
    final void addLogEntry(String type, String logMessage) {
        void var2_2;
        void var1_1;
        this.addEvent(null, (String)var1_1, new String[]{var2_2});
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void addEvent(String eventType, String title, String ... body) {
        if (!this.isRemoteDebugging() || this.requestSize >= 98304) {
            return;
        }
        try {
            void var2_2;
            void var1_1;
            long l = System.currentTimeMillis();
            CharSequence charSequence = "";
            if (body.length > 0) {
                void var3_3;
                charSequence = new StringBuilder();
                for (int k = body.length - 1; k > 0; --k) {
                    ((StringBuilder)charSequence).append(body[k]).append(", ");
                }
                ((StringBuilder)charSequence).append((String)var3_3[0]);
                charSequence = ((StringBuilder)charSequence).toString();
            }
            String string = new SimpleDateFormat("MM-dd HH:mm:ss.SSS", Locale.ENGLISH).format(l);
            charSequence = eventType != null ? String.format("%18s %5s _/%s [%s] %s %s", string, Thread.currentThread().getId(), "AppsFlyer_4.6.7", var1_1, title, charSequence) : String.format("%18s %5s %s/%s %s", string, Thread.currentThread().getId(), var2_2, "AppsFlyer_4.6.7", charSequence);
            this.chronologicalEvents.put((Object)charSequence);
            this.requestSize += ((String)charSequence).getBytes().length;
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized String getJSONString(boolean shouldClearData) {
        String string = null;
        try {
            void var1_1;
            System.currentTimeMillis();
            this.remoteDebuggingJSON.put("data", (Object)this.chronologicalEvents);
            string = this.remoteDebuggingJSON.toString();
            if (var1_1 != false) {
                this.clearData();
            }
        }
        catch (JSONException jSONException) {}
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void loadStaticData(String packageName, PackageManager packageManager) {
        AppsFlyerProperties appsFlyerProperties = AppsFlyerProperties.getInstance();
        Object object = AppsFlyerLib.getInstance();
        String string = appsFlyerProperties.getString("remote_debug_static_data");
        if (string != null) {
            try {
                this.remoteDebuggingJSON = new JSONObject(string);
                return;
            }
            catch (Throwable throwable) {
                return;
            }
        }
        this.remoteDebuggingJSON = new JSONObject();
        this.setDeviceData(Build.BRAND, Build.MODEL, Build.VERSION.RELEASE, appsFlyerProperties.getString("advertiserId"), ((AppsFlyerLib)object).userCustomImei, ((AppsFlyerLib)object).userCustomAndroidId);
        this.setSDKData("4.6.7.302", appsFlyerProperties.getString("AppsFlyerKey"), appsFlyerProperties.getString("KSAppsFlyerId"), appsFlyerProperties.getString("uid"));
        try {
            void var1_1;
            void var2_2;
            int n = var2_2.getPackageInfo((String)packageName, (int)0).versionCode;
            object = appsFlyerProperties.getString("channel");
            string = appsFlyerProperties.getString("preInstallName");
            this.setAppData((String)var1_1, String.valueOf(n), (String)object, string);
        }
        catch (Throwable throwable) {}
        appsFlyerProperties.set("remote_debug_static_data", this.remoteDebuggingJSON.toString());
    }

    /*
     * WARNING - void declaration
     */
    private String[] getThrowableStringData(String msg, StackTraceElement[] stackTrace) {
        void var1_1;
        if (stackTrace == null) {
            return new String[]{msg};
        }
        String[] stringArray = new String[stackTrace.length + 1];
        String[] stringArray2 = stringArray;
        stringArray[0] = var1_1;
        for (int k = 1; k < stackTrace.length; ++k) {
            stringArray2[k] = stackTrace[k].toString();
        }
        return stringArray2;
    }

    private synchronized void clearData() {
        this.chronologicalEvents = null;
        this.chronologicalEvents = new JSONArray();
        this.requestSize = 0;
    }

    final synchronized void dropPreLaunchDebugData() {
        shouldCollectPreLaunchDebugData = false;
        this.clearData();
    }

    final void disableRemoteDebuggingForThisApp() {
        shouldEnableRemoteDebuggingForThisApp = false;
    }

    final boolean isRemoteDebuggingEnabledFromServer() {
        return this.remoteDebuggingEnabledFromServer;
    }

    static {
        shouldCollectPreLaunchDebugData = true;
        shouldEnableRemoteDebuggingForThisApp = true;
    }
}

