/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.content.Context;
import com.appsflyer.AFLogger;
import com.appsflyer.AppsFlyerLib;
import com.appsflyer.AppsFlyerProperties;
import com.appsflyer.GcmToken;
import com.google.android.gms.iid.InstanceID;
import com.google.android.gms.iid.InstanceIDListenerService;
import java.io.IOException;

public class InstanceIDListener
extends InstanceIDListenerService {
    private String _refreshedToken;
    private long _tokenTimestamp;

    public void onTokenRefresh() {
        super.onTokenRefresh();
        AFLogger.afLog("onTokenRefresh called");
        String gcmProjectNumber = AppsFlyerProperties.getInstance().getString("gcmProjectNumber");
        InstanceID instanceID = InstanceID.getInstance((Context)this);
        try {
            this._refreshedToken = instanceID.getToken(gcmProjectNumber, "GCM", null);
            this._tokenTimestamp = System.currentTimeMillis();
        }
        catch (IOException e) {
            AFLogger.afLog("Could not load registration ID");
        }
        catch (Throwable t) {
            AFLogger.afLog("Error registering for uninstall feature");
        }
        if (this._refreshedToken != null) {
            AFLogger.afLog("new token=" + this._refreshedToken);
            String token = AppsFlyerProperties.getInstance().getString("gcmToken");
            String instanceId = AppsFlyerProperties.getInstance().getString("gcmInstanceId");
            String tokenTimestamp = AppsFlyerProperties.getInstance().getString("gcmTokenTimestamp");
            GcmToken existingGcmToken = new GcmToken(tokenTimestamp, token, instanceId);
            GcmToken newGcmToken = new GcmToken(this._tokenTimestamp, this._refreshedToken, instanceId);
            if (existingGcmToken.update(newGcmToken)) {
                AppsFlyerLib.getInstance().updateServerGcmToken(existingGcmToken, this.getApplicationContext());
            }
        }
    }
}

