package com.appsflyer;

/**
 * Created by golan on 5/21/15.
 */


import android.content.Context;
import android.os.AsyncTask;
import org.json.JSONObject;

import javax.net.ssl.HttpsURLConnection;
import java.io.*;
import java.net.*;
import java.util.Map;


public class BackgroundHttpTask extends AsyncTask<String, Void, String> {


    private static final int WAIT_TIMEOUT = 30 * 1000;

    private String content =  null;
    private boolean error = false;
    public Map<String,String> bodyParameters;
    private String bodyAsString;
    private Context mContext;

    public BackgroundHttpTask(Context context){

        this.mContext = context;
    }

    protected void onPreExecute() {

        JSONObject jsonObject = new JSONObject(this.bodyParameters);
        if (jsonObject != null) {
           this.bodyAsString = jsonObject.toString();
        }
    }

    protected String doInBackground(String... urls) {

        try {

            URL url = new URL(urls[0]);

            LogMessages.logMessageMaskKey("call = " + url + " parameters = " + bodyParameters.toString());

            HttpsURLConnection conn = (HttpsURLConnection) url.openConnection();
            conn.setReadTimeout(WAIT_TIMEOUT);
            conn.setConnectTimeout(WAIT_TIMEOUT);
            conn.setRequestMethod("POST");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", "application/json");


            OutputStream os = conn.getOutputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
            writer.write(bodyAsString);
            writer.flush();
            writer.close();
            os.close();
            conn.connect();


            int responseCode=conn.getResponseCode();

            if (responseCode == HttpsURLConnection.HTTP_OK) {
                String line;
                BufferedReader br=new BufferedReader(new InputStreamReader(conn.getInputStream()));
                while ((line=br.readLine()) != null) {
                    content+=line;
                }
                AFLogger.afLog("Status 200 ok");
            }

        }catch (MalformedURLException malEx) {
            AFLogger.afLog("MalformedURLException: " + malEx.toString());
        }
        catch (ProtocolException protEx) {
            AFLogger.afLog("ProtocolException: " + protEx.toString());
        }
        catch (IOException ioEx) {
            AFLogger.afLog("IOException: " + ioEx.toString());
        }
        catch (Exception ex) {
            AFLogger.afLog("Exception: " + ex.toString());
        }

        return content;
    }


    protected void onCancelled() {
    }

    protected void onPostExecute(String content) {
        if (error) {
            AFLogger.afLog("Connection error");
        } else {
            AFLogger.afLog("Connection call succeeded");
        }
    }
}