package com.appsflyer;

import java.io.*;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.*;
import java.util.concurrent.atomic.AtomicInteger;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.*;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.support.annotation.Nullable;
import android.telephony.TelephonyManager;
import com.appsflyer.cache.CacheManager;
import com.appsflyer.cache.RequestCacheData;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import com.google.android.gms.iid.InstanceID;
import org.json.JSONException;
import org.json.JSONObject;

public class AppsFlyerLib
{

    public static final String JENKINS_BUILD_NUMBER="87";
    public static final String BUILD_NUMBER="4.4.0";
    public static final String SERVER_BUILD_NUMBER = BUILD_NUMBER.substring(0,BUILD_NUMBER.indexOf("."));
    public static final String SDK_BUILD_NUMBER = BUILD_NUMBER.substring(BUILD_NUMBER.indexOf(".")+1);
    public static final String LOG_TAG = LogMessages.LOG_TAG_PREFIX+SDK_BUILD_NUMBER;
    public static final String APPS_TRACKING_URL = "https://t.appsflyer.com/api/v"+SERVER_BUILD_NUMBER+"/androidevent?buildnumber="+SDK_BUILD_NUMBER+"&app_id=";
    public static final String EVENTS_TRACKING_URL = "https://events.appsflyer.com/api/v"+SERVER_BUILD_NUMBER+"/androidevent?buildnumber="+SDK_BUILD_NUMBER+"&app_id=";
    private static final String REGISTER_URL = "https://register.appsflyer.com/api/v"+SERVER_BUILD_NUMBER+"/androidevent?buildnumber="+SDK_BUILD_NUMBER+"&app_id=";
    private static final String STATS_URL = "https://stats.appsflyer.com/stats";

    private static final String VALIDATE_URL = "https://sdk-services.appsflyer.com/validate-android-signature";
    private static final String CONVERSION_DATA_URL = "https://api.appsflyer.com/install_data/v3/";

    private static final String INSTALL_UPDATE_DATE_FORMAT = "yyyy-MM-dd_HHmmZ";

    protected static final String AF_SHARED_PREF = "appsflyer-data";
    static final String SENT_SUCCESSFULLY_PREF = "sentSuccessfully";
    static final String AF_COUNTER_PREF = "appsFlyerCount";
    static final String AF_EVENT_COUNTER_PREF = "appsFlyerInAppEventCount";
    static final String AF_TIME_PASSED_SINCE_LAST_LAUNCH  = "AppsFlyerTimePassedSincePrevLaunch";

    static final String FIRST_INSTALL_PREF = "appsFlyerFirstInstall";
    protected static final String REFERRER_PREF = "referrer";
    static final String ATTRIBUTION_ID_PREF = "attributionId";
    private static final String PREPARE_DATA_ACTION = "collect data for server";
    private static final String CALL_SERVER_ACTION = "call server.";
    private static final String SERVER_RESPONDED_ACTION = "response from server. status=";

    public static final String ATTRIBUTION_ID_CONTENT_URI = "content://com.facebook.katana.provider.AttributionIdProvider";

    public static final String ATTRIBUTION_ID_COLUMN_NAME = "aid";

    private static final String WARNING_PREFIX = "WARNING: ";
    private static final String ERROR_PREFIX = "ERROR: ";
    private static final String CACHED_CHANNEL_PREF = "CACHED_CHANNEL";

    private static final String CACHED_URL_PARAMETER = "&isCachedRequest=true&timeincache=";
    private static final String INSTALL_STORE_PREF = "INSTALL_STORE";
    private static final List<String> IGNORABLE_KEYS = Arrays.asList(new String[]{"is_cache"});
    private static final String DEEPLINK_ATTR_PREF = "deeplinkAttribution";
    private static final String PRE_INSTALL_PREF = "preInstallName";
    private static final String IMEI_CACHED_PREF = "imeiCached";
    private static final String PREV_EVENT_TIMESTAMP = "prev_event_timestamp";
    private static final String PREV_EVENT_VALUE = "prev_event_value";
    private static final String PREV_EVENT_NAME = "prev_event_name";
    private static final String PREV_EVENT = "prev_event";
    private static final long TEST_MODE_MAX_DURATION = 30*1000;
    private static String userCustomImei;
    private static final String ANDROID_ID_CACHED_PREF = "androidIdCached";
    private static String userCustomAndroidId;
    private static final String IN_APP_EVENTS_API = "1";

    private static AppsFlyerConversionListener conversionDataListener = null;
    private static AppsFlyerInAppPurchaseValidatorListener validatorListener = null;

    private static boolean isDuringCheckCache = false;
    private static long lastCacheCheck;
    private static ScheduledExecutorService cacheScheduler = null;
    private static long timeInApp;
    private static final String CONVERSION_REQUEST_RETRIES  = "appsflyerConversionDataRequestRetries";
    private static final int NUMBER_OF_CONVERSION_DATA_RETRIES = 5;
    private static final String CONVERSION_DATA_CACHE_EXPIRATION = "appsflyerConversionDataCacheExpiration";
    private static final String GET_CONVERSION_DATA_TIME = "appsflyerGetConversionDataTiming";
    private static final long SIXTY_DAYS =  60 * 60 * 24 * 60 * 1000L; // in milli seconds
    private static final String VERSION_CODE = "versionCode";

    private static AppsFlyerLib instance = new AppsFlyerLib();

    private Foreground.Listener listener;
    private long testModeStartTime;

    public void onReceive(Context context, Intent intent) {

        String shouldMonitor = intent.getStringExtra("shouldMonitor");
        if (shouldMonitor != null){
            AFLogger.afLog("Turning on monitoring.");
            AppsFlyerProperties.getInstance().set(AppsFlyerProperties.IS_MONITOR,shouldMonitor.equals("true"));
            monitor(context, null,  MonitorMessages.START_TRACKING, context.getPackageName());
            return;
        }

        AFLogger.afLog( "****** onReceive called *******");
        debugAction("******* onReceive: ","",context);

        AppsFlyerProperties.getInstance().setOnReceiveCalled();

        String referrer = intent.getStringExtra(REFERRER_PREF);
        AFLogger.afLog( LogMessages.PLAY_STORE_REFERRER_RECIEVED + referrer);

        if(referrer != null) {
            // check if test app
            String testIntegration = intent.getStringExtra("TestIntegrationMode");

            if (testIntegration != null && testIntegration.equals("AppsFlyer_Test")) {

                SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
                SharedPreferences.Editor editor =  sharedPreferences.edit();
                editor.clear();
                editorCommit(editor);
//                editor.apply();
                AppsFlyerProperties.getInstance().setFirstLaunchCalled(false);
                startTestMode();
            }
            debugAction("onReceive called. referrer: ",referrer,context);

            saveDataToSharedPreferences(context, REFERRER_PREF, referrer);

            // set in memory value in case the shared pref will not be sync on time
            AppsFlyerProperties.getInstance().setReferrer(referrer);

            if  (AppsFlyerProperties.getInstance().isFirstLaunchCalled()){ // send to server only if it's after the onCreate call
                AFLogger.afLog("onReceive: isLaunchCalled");
                runInBackground(context, null, null, null, referrer,false);
            }
        }
    }

    @SuppressLint("CommitPrefEdits")
    private void editorCommit(SharedPreferences.Editor editor) {
        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.GINGERBREAD) {
            editor.apply();
        } else {
            editor.commit();
        }
    }

    private void startTestMode() {
        AFLogger.afLog("Test mode started..");
        testModeStartTime = System.currentTimeMillis();
    }
    private void endTestMode() {
        AFLogger.afLog("Test mode ended!");
        testModeStartTime = 0;
    }
    private boolean isInTestMode(String referrer) {
        long interval = System.currentTimeMillis() - testModeStartTime;
        return (interval <= TEST_MODE_MAX_DURATION) && referrer != null && referrer.contains("AppsFlyer_Test");
    }


    private AppsFlyerLib() {
    }

    public static AppsFlyerLib getInstance() {
        return instance;
    }


    private void registerForAppEvents(Application application) {

        if (listener == null) {

            AppsFlyerProperties.getInstance().loadProperties(application.getApplicationContext());


            if (Build.VERSION.SDK_INT >= 14 ) {
                Foreground.init(application);
                listener = new Foreground.Listener() {
                    public void onBecameForeground(Activity currentActivity) {
                        AFLogger.afLog("onBecameForeground");
                        timeInApp = System.currentTimeMillis();
                        trackEvent(currentActivity, null, null);
                    }

                    public void onBecameBackground(Activity currentActivity) {
                        AFLogger.afLog("onBecameBackground");
                        AFLogger.afLog("callStatsBackground background call");
                        callStatsBackground(currentActivity.getApplicationContext());
                    }
                };
                Foreground.getInstance().addListener(listener);
            }
            else {
                AFLogger.afLog("SDK<14 call trackAppLaunch manually");
                trackEvent(application.getApplicationContext(), null, null);
            }
        }
    }

    private void registerOnGCM(final Context context) {

        final String gcmProjectID = AppsFlyerProperties.getInstance().getString(AppsFlyerProperties.GCM_PROJECT_ID);

        if (gcmProjectID != null && AppsFlyerProperties.getInstance().getString(AppsFlyerProperties.GCM_TOKEN) == null) {

            new Thread(new Runnable() {
                @Override
                public void run() {
                    try {
                        Class.forName("com.google.android.gms.iid.InstanceID");
                        InstanceID instanceID = InstanceID.getInstance(context);
                        String token = instanceID.getToken(gcmProjectID, GoogleCloudMessaging.INSTANCE_ID_SCOPE, null);
                        AFLogger.afLog("token=" + token);
                        AppsFlyerProperties.getInstance().set(AppsFlyerProperties.GCM_TOKEN, token);

                        String sInstanceId = instanceID.getId();
                        AFLogger.afLog("instance id=" + sInstanceId);
                        AppsFlyerProperties.getInstance().set(AppsFlyerProperties.GCM_INSTANCE_ID, sInstanceId);

                        callRegisterBackground(context);

                    } catch (ClassNotFoundException e) {
                        AFLogger.afLog("Please integrate Google Play Services in order to support uninstall feature");
                    } catch (IOException e) {
                        AFLogger.afLog("Could not load registration ID");
                    } catch (Throwable t) {
                        AFLogger.afLog("Error registering for uninstall feature");
                    }
                }}).start();
        }
    }


    /**
     *
     * @deprecated use {@link #setGCMProjectNumber(String)} instead.
     */
    @Deprecated
    public void setGCMProjectID(String id){
        setGCMProjectNumber(id);
    }

    public void setGCMProjectNumber(String id){
        AppsFlyerProperties.getInstance().set(AppsFlyerProperties.GCM_PROJECT_ID, id);
    }


    public void setDebugLog(boolean shouldEnable){
        AppsFlyerProperties.getInstance().enableLogOutput(shouldEnable);
    }


    public void setImeiData(String aImei) {
        userCustomImei = aImei;
    }

    public void setAndroidIdData(String aAndroidId) {
        userCustomAndroidId = aAndroidId;
    }


    private void debugAction(String actionMsg, String parameter,Context context) {
        try {
            if (isAppsFlyerPackage(context)) {
                DebugLogQueue.getInstance().push(actionMsg + parameter);
            }
        } catch (Exception e) {
            AFLogger.afLog(e.toString());
        }
    }

    private boolean isAppsFlyerPackage(Context context) {
        return context != null && context.getPackageName().length() > 12 && "com.appsflyer".equals(context.getPackageName().toLowerCase().substring(0, 13));
    }

    private void saveDataToSharedPreferences(Context context, String key, String value) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
        android.content.SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(key, value);
        editorCommit(editor);
    }


    private void saveIntegerToSharedPreferences(Context context, String key, int value) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
        android.content.SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putInt(key, value);
        editorCommit(editor);
    }

    private void saveLongToSharedPreferences(Context context, String key, long value) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
        android.content.SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong(key, value);
        editorCommit(editor);
    }

    private boolean checkWriteExternalPermission(Context context)
    {

        String permission = "android.permission.ACCESS_FINE_LOCATION";
        int res = context.checkCallingOrSelfPermission(permission);
        return (res == PackageManager.PERMISSION_GRANTED);
    }


    protected void setProperty(String key,String value){
        AppsFlyerProperties.getInstance().set(key,value);
    }

    public String getProperty(String key){
        return AppsFlyerProperties.getInstance().getString(key);
    }

    /**
     *
     * @deprecated use {@link #setCustomerUserId(String)} instead
     */
    @Deprecated
    public void setAppUserId(String id){
         setCustomerUserId(id);
    }

    public void setCustomerUserId(String id){
        AFLogger.afLog( "setCustomerUserId = " + id);
        setProperty(AppsFlyerProperties.APP_USER_ID, id);
    }

    public void setAdditionalData (HashMap<String, Object> customData){

        JSONObject jsonObject = new JSONObject(customData);
        AppsFlyerProperties.getInstance().setCustomData(jsonObject.toString());
    }

    public void sendDeepLinkData(Activity activity) {
        AFLogger.afLog("getDeepLinkData with activity " + activity.getIntent().getDataString());
        registerForAppEvents(activity.getApplication());
    }

    /**
     *
     * @deprecated use {@link #setUserEmails(AppsFlyerProperties.EmailsCryptType, String...)} instead
     */
    @Deprecated
    public void setUserEmail(String email ) {
        setProperty(AppsFlyerProperties.USER_EMAIL, email);
    }

    public void setUserEmails(String... emails) {
        setUserEmails(AppsFlyerProperties.EmailsCryptType.NONE, emails);
    }

    public void setUserEmails(AppsFlyerProperties.EmailsCryptType cryptMethod, String... emails) {

        AppsFlyerProperties.getInstance().set(AppsFlyerProperties.EMAIL_CRYPT_TYPE, cryptMethod.getValue());
        HashMap<String, Object> emailData = new HashMap<>();
        StringBuilder emailsString = new StringBuilder();

        for (String email : emails) {
            emailsString.append(email);
            emailsString.append(",");
        }

        switch (cryptMethod) {
            default:
            case SHA1:
                emailData.put("sha1_el_arr", HashUtils.toSHA1(emailsString.toString()));
                break;
            case MD5:
                emailData.put("md5_el_arr", HashUtils.toMD5(emailsString.toString()));
                break;
            case NONE:
                emailData.put("plain_el_arr", emailsString.toString());
                break;
        }

        JSONObject jsonObject = new JSONObject(emailData);
        AppsFlyerProperties.getInstance().setUserEmails(jsonObject.toString());
    }

    public void setUseHTTPFalback(boolean isUseHttp){
        setProperty(AppsFlyerProperties.USE_HTTP_FALLBACK, Boolean.toString(isUseHttp));
    }

    public void setCollectAndroidID(boolean isCollect){
        setProperty(AppsFlyerProperties.COLLECT_ANDROID_ID, Boolean.toString(isCollect));
    }

    public void setCollectMACAddress(boolean isCollect){
        setProperty(AppsFlyerProperties.COLLECT_MAC, Boolean.toString(isCollect));
    }

    public void setCollectIMEI(boolean isCollect){
        setProperty(AppsFlyerProperties.COLLECT_IMEI, Boolean.toString(isCollect));
    }

    public void setCollectFingerPrint(boolean isCollect){
        setProperty(AppsFlyerProperties.COLLECT_FINGER_PRINT, Boolean.toString(isCollect));
    }


    public void startTracking(Application application, String key){
        AFLogger.afLogM("Build Number: "+JENKINS_BUILD_NUMBER);
        setProperty(AppsFlyerProperties.AF_KEY, key);
        LogMessages.setDevKey(key);
        registerForAppEvents(application);
        registerOnGCM(application.getApplicationContext());
    }

    public String getAppUserId(){
        return getProperty(AppsFlyerProperties.APP_USER_ID);
    }

    public void setAppId(String id) {
        setProperty(AppsFlyerProperties.APP_ID, id);
    }

    public String getAppId() {
        return getProperty(AppsFlyerProperties.APP_ID);
    }

    /**
     * SDK plugins and extensions will set this field
     * @param extension
     */
    public void setExtension(String extension){
        AppsFlyerProperties.getInstance().set(AppsFlyerProperties.EXTENSION, extension);
    }

    public void setIsUpdate(boolean isUpdate) {
        AppsFlyerProperties.getInstance().set(AppsFlyerProperties.IS_UPDATE, isUpdate);
    }

    public void setCurrencyCode(String currencyCode){
        AppsFlyerProperties.getInstance().set(AppsFlyerProperties.CURRENCY_CODE, currencyCode);
    }

    public void trackLocation(Context context, double latitude, double longitude) {
        Map<String,Object> location = new HashMap<String, Object>();
        location.put(AFInAppEventParameterName.LONGTITUDE, Double.toString(longitude));
        location.put(AFInAppEventParameterName.LATITUDE, Double.toString(latitude));

        trackEvent(context, AFInAppEventType.LOCATION_COORDINATES, location);
    }

    private void callStatsBackground(Context context) {

        AFLogger.afLog("app went to background");
        AppsFlyerProperties.getInstance().saveProperties(context);
        // measure session time.
        long sessionTime =  System.currentTimeMillis() - timeInApp;


        Map<String,String> params = new HashMap<String, String>();
        String afDevKey = getProperty(AppsFlyerProperties.AF_KEY);

        params.put(ServerParameters.APP_ID, context.getPackageName());
        params.put(ServerParameters.DEV_KEY, afDevKey);
        params.put(ServerParameters.AF_USER_ID, getAppsFlyerUID(context));
        params.put(ServerParameters.TIME_SPENT_IN_APP, String.valueOf(sessionTime / 1000));
        params.put(ServerParameters.STATUS_TYPE, "user_closed_app");
        params.put(ServerParameters.PLATFORM, "Android");
        params.put(ServerParameters.LAUNCH_COUNTER ,Integer.toString(getCounter(context,AF_COUNTER_PREF ,false)));
        SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
        params.put(ServerParameters.CONVERSION_DATA_TIMING, Long.toString(sharedPreferences.getLong(GET_CONVERSION_DATA_TIME,0)));
        params.put(ServerParameters.CHANNEL_SERVER_PARAM, getConfiguredChannel(context));

        boolean collectFingerPrint = AppsFlyerProperties.getInstance().getBoolean(AppsFlyerProperties.COLLECT_FINGER_PRINT,true);

        if (collectFingerPrint) {
            String customUUID = getUniquePsuedoID();
            if (customUUID != null) {
                params.put(ServerParameters.DEVICE_FINGER_PRINT_ID, customUUID);
            }
        }

        try {
            BackgroundHttpTask statTask = new BackgroundHttpTask(context);
            statTask.bodyParameters = params;
            statTask.execute(STATS_URL);
        } catch (Throwable ignored) {
        }
    }

    // for Unity
    public void trackAppLaunch(Context ctx, String devKey) {

        runInBackground(ctx, devKey, null, null, "" ,true);
    }

    public void reportTrackSession(Context ctx) {
        trackEvent(ctx,null,null);
    }

    public void trackEvent(Context context, String eventName,Map<String,Object> eventValues){
        JSONObject jsonObject = new JSONObject(eventValues == null ? new HashMap() : eventValues);
        String referrer = AppsFlyerProperties.getInstance().getReferrer(context);
        runInBackground(context, null, eventName, jsonObject.toString(), referrer == null ? "" : referrer,true);
    }

    private void monitor(Context context, String eventIdentifier, String message, String value) {
        if (AppsFlyerProperties.getInstance().getBoolean(AppsFlyerProperties.IS_MONITOR,false)){
            // tell other SDK to send back messages
            Intent localIntent = new Intent(MonitorMessages.BROADCAST_ACTION);
            localIntent.setPackage("com.appsflyer.nightvision");
            localIntent.putExtra(MonitorMessages.MESSAGE, message);
            localIntent.putExtra(MonitorMessages.VALUE, value);
            localIntent.putExtra(MonitorMessages.PACKAGE, "true");
            localIntent.putExtra(MonitorMessages.PROCESS_ID, new Integer(android.os.Process.myPid()));
            localIntent.putExtra(MonitorMessages.EVENT_IDENTIFIER, eventIdentifier);
            localIntent.putExtra(MonitorMessages.SDK_VERSION, SERVER_BUILD_NUMBER+'.'+SDK_BUILD_NUMBER);

            context.sendBroadcast(localIntent);

        }
    }

    private void callRegisterBackground(Context context) {

        Map<String,String> params = new HashMap<String, String>();
        String afDevKey = getProperty(AppsFlyerProperties.AF_KEY);

        params.put(ServerParameters.DEV_KEY, afDevKey);
        params.put(ServerParameters.AF_USER_ID, getAppsFlyerUID(context));
        params.put(ServerParameters.AFGCM_TOKEN, AppsFlyerProperties.getInstance().getString(AppsFlyerProperties.GCM_TOKEN));
        params.put(ServerParameters.ADVERTISING_ID_PARAM, AppsFlyerProperties.getInstance().getString(ServerParameters.ADVERTISING_ID_PARAM));
        params.put(ServerParameters.GOOGLE_INSTANCE_ID, AppsFlyerProperties.getInstance().getString(AppsFlyerProperties.GCM_INSTANCE_ID));
        params.put(ServerParameters.LAUNCH_COUNTER, Integer.toString(getCounter(context,AF_COUNTER_PREF ,false)));
        params.put("sdk",Integer.toString(android.os.Build.VERSION.SDK_INT));
        params.put(ServerParameters.CHANNEL_SERVER_PARAM, getConfiguredChannel(context));


        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            long firstInstallTime = packageInfo.firstInstallTime;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            params.put("install_date", dateFormat.format(new Date(firstInstallTime)));
        }
        catch(android.content.pm.PackageManager.NameNotFoundException e) {
            // ignore
        } catch (NoSuchFieldError e){
            // ignore
        }

        boolean collectFingerPrint = AppsFlyerProperties.getInstance().getBoolean(AppsFlyerProperties.COLLECT_FINGER_PRINT,true);

        if (collectFingerPrint) {
            String customUUID = getUniquePsuedoID();
            if (customUUID != null) {
                params.put(ServerParameters.DEVICE_FINGER_PRINT_ID, customUUID);
            }
        }
        try {
            BackgroundHttpTask statTask = new BackgroundHttpTask(context);
            statTask.bodyParameters = params;
            String url = REGISTER_URL + context.getPackageName();
            statTask.execute(url);
        } catch (Throwable ignored) {
        }
    }

    private static void broadcastBacktoTestApp(Context context, HashMap<String, String> params) {

        Intent localIntent = new Intent(MonitorMessages.TEST_INTEGRATION_ACTION);
        localIntent.putExtra("params", params);
        context.sendBroadcast(localIntent);

    }


    public void setDeviceTrackingDisabled(boolean isDisabled){
        AppsFlyerProperties.getInstance().set(AppsFlyerProperties.DEVICE_TRACKING_DISABLED, isDisabled);
    }

    /*
     If referrer exist it is returned. Otherwise, return the cached attribution data
     */
    public Map<String,String> getConversionData(Context context) throws AttributionIDNotReady {
        SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
        String referrer = AppsFlyerProperties.getInstance().getReferrer(context);
        if (referrer != null && referrer.length() > 0 && referrer.contains("af_tranid")){
            return referrerStringToMap(context, referrer);
        }
        String attributionString = sharedPreferences.getString(ATTRIBUTION_ID_PREF,null);

        if (attributionString != null && attributionString.length() > 0){
            return attributionStringToMap(attributionString);
        } else {
            throw new AttributionIDNotReady();
        }
    }

    public void registerConversionListener(Context context, AppsFlyerConversionListener conversionDataListener){
        if (conversionDataListener == null){
            return;
        }
        AppsFlyerLib.conversionDataListener = conversionDataListener;

    }

    public void registerValidatorListener(Context context, AppsFlyerInAppPurchaseValidatorListener validationListener){

        AFLogger.afDebugLog("registerValidatorListener called");

        if (validationListener == null) {
            AFLogger.afDebugLog("registerValidatorListener null listener");
            return;
        }
        AppsFlyerLib.validatorListener = validationListener;

    }

    /**
     *
     * @deprecated use {@link #registerConversionListener(android.content.Context,com.appsflyer.AppsFlyerConversionListener)} instead.
     */
    @Deprecated
    public void getConversionData(final Context context, final ConversionDataListener conversionDataListener) {
        registerConversionListener(context, new AppsFlyerConversionListener() {
            public void onInstallConversionDataLoaded(Map<String, String> conversionData) {
                conversionDataListener.onConversionDataLoaded(conversionData);
            }

            public void onInstallConversionFailure(String errorMessage) {
                conversionDataListener.onConversionFailure(errorMessage);
            }

            public void onAppOpenAttribution(Map<String, String> attributionData) {

            }

            public void onAttributionFailure(String errorMessage) {

            }
        });
    }


    private Map<String, String> referrerStringToMap(Context context, String referrer)  {

        final Map<String, String> conversionData = new LinkedHashMap<String, String>();
        final String[] pairs = referrer.split("&");
        boolean didFindPrt = false;

        for (String pair : pairs) {
            final int idx = pair.indexOf("=");
            String name = idx > 0 ? pair.substring(0, idx) : pair;
            if (!conversionData.containsKey(name)) {

                if (name.equals("c")){
                    name = "campaign";
                } else if (name.equals("pid")){
                    name = "media_source";
                } else if (name.equals("af_prt")){
                    didFindPrt = true;
                    name = "agency";
                }

                conversionData.put(name, new String());
            }
            final String value = idx > 0 && pair.length() > idx + 1 ? pair.substring(idx + 1) : null;
            conversionData.put(name, value);
        }
        try {
            if (!conversionData.containsKey("install_time")) {
                PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
                // ***Note this will work only on android 9 and above!!!!!!!!!!!!!!!!!!!!!!!!
                long firstInstallTime = packageInfo.firstInstallTime;
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                conversionData.put("install_time", dateFormat.format(new Date(firstInstallTime)));
            }
        } catch (Exception e){
            AFLogger.afWarnLog("Could not fetch install time"); ;
        }
        if (!conversionData.containsKey("af_status")){
            conversionData.put("af_status","Non-organic");
        }

         if (didFindPrt) {
            conversionData.remove("media_source");
        }


        return conversionData;
    }




    private Map<String,String> attributionStringToMap(String inputString){
        Map<String,String> conversionData = new HashMap<String, String>();

        try {
            JSONObject jsonObject = new JSONObject(inputString);
            Iterator iterator = jsonObject.keys();
            while (iterator.hasNext()){
                String key = (String) iterator.next();
                if (!IGNORABLE_KEYS.contains(key)){
                    conversionData.put(key,jsonObject.getString(key));
                }
            }
        } catch(JSONException e) {
            AFLogger.afWarnLog(e.getMessage());
            return null;
        }

        return conversionData;
    }


    private void runInBackground(Context context,String appsFlyerKey,String eventName,String eventValue,String referrer,boolean isNewAPI){
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        scheduler.schedule(new DataCollector(context,appsFlyerKey,eventName,eventValue,referrer,isNewAPI,scheduler),5, TimeUnit.MILLISECONDS);

    }

    private void sendTrackingWithEvent(Context context,String appsFlyerKey,String eventName,String eventValue,String referrer,boolean isUseNewAPI) {

        AppsFlyerProperties.getInstance().saveProperties(context);
        AFLogger.afLog("AsendTrackingWithEvent from activity: " + context.getClass().getName().toString());
        boolean isLaunchEvent = eventName == null;
        Map<String,String> params = new HashMap<String, String>();
        params.put(ServerParameters.TIMESTAMP,Long.toString(new Date().getTime()));


        try{

            debugAction(PREPARE_DATA_ACTION,"",context);
            AFLogger.afLog(LogMessages.EVENT_CREATED_WITH_NAME+(isLaunchEvent ? "Launch" : eventName));
            debugAction("********* sendTrackingWithEvent: ",isLaunchEvent ? "Launch" : eventName,context);

            monitor(context, AppsFlyerLib.LOG_TAG, MonitorMessages.EVENT_CREATED_WITH_NAME,isLaunchEvent ? "Launch" : eventName);
            CacheManager.getInstance().init(context);

            try {
                // permissions
                PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), PackageManager.GET_PERMISSIONS);
                List<String> requestedPermissions = Arrays.asList(packageInfo.requestedPermissions);
                if (!requestedPermissions.contains("android.permission.INTERNET")){
                    AFLogger.afWarnLog(LogMessages.PERMISSION_INTERNET_MISSING);
                    monitor(context, null, MonitorMessages.PERMISSION_INTERNET_MISSING,null);
                }
                if (!requestedPermissions.contains("android.permission.ACCESS_NETWORK_STATE")){
                    AFLogger.afWarnLog(LogMessages.PERMISSION_ACCESS_NETWORK_MISSING);
                }
                if (!requestedPermissions.contains("android.permission.ACCESS_WIFI_STATE")){
                    AFLogger.afWarnLog(LogMessages.PERMISSION_ACCESS_WIFI_MISSING);
                }
            } catch (Exception e){
                //ignore
            }

            StringBuilder urlString = new StringBuilder();
            urlString.append(isLaunchEvent ? APPS_TRACKING_URL : EVENTS_TRACKING_URL).append(context.getPackageName());
            if (isUseNewAPI){
                params.put("af_events_api",IN_APP_EVENTS_API);
            }
            params.put("brand",android.os.Build.BRAND);
            params.put("device",android.os.Build.DEVICE);
            params.put("product",android.os.Build.PRODUCT); // key was brand
            params.put("sdk",Integer.toString(android.os.Build.VERSION.SDK_INT));
            params.put("model",Build.MODEL);
            params.put("deviceType",Build.TYPE);

            if (isLaunchEvent){
                if (isAppsFlyerFirstLaunch(context) && !AppsFlyerProperties.getInstance().isOtherSdkStringDisabled()) {
                    params.put(ServerParameters.OTHER_SDKS, generateOtherSDKsString());
                }
            }else {
                lastEventsProcessing(context, params, eventName, eventValue);
            }
            String customData = getProperty(AppsFlyerProperties.ADDITIONAL_CUSTOM_DATA);
            if (customData != null) {
                params.put("customData", customData);
            }
            try {
                String installerPackage = context.getPackageManager().getInstallerPackageName(context.getPackageName());
                if (installerPackage != null){
                    params.put("installer_package",installerPackage);
                }
            } catch (Exception e){

            }

            String sdkExtension = AppsFlyerProperties.getInstance().getString(AppsFlyerProperties.EXTENSION);
            if (sdkExtension != null && sdkExtension.length() > 0){
                params.put("sdkExtension",sdkExtension);
            }

            String currentChannel = getConfiguredChannel(context);

            String originalChannel = getCachedChannel(context,currentChannel);
            if (originalChannel != null){
                params.put(ServerParameters.CHANNEL_SERVER_PARAM,originalChannel);
            }

            if (originalChannel != null && !originalChannel.equals(currentChannel)
                    || originalChannel == null && currentChannel != null){
                params.put(ServerParameters.LATEST_CHANNEL_SERVER_PARAM,currentChannel);
            }

            String installStore = getCachedStore(context);
            if (installStore != null){
                params.put(ServerParameters.INSTALL_STORE,installStore.toLowerCase());
            }

            String preInstallName = getPreInstallName(context);
            if (preInstallName != null){
                params.put(ServerParameters.PRE_INSTALL_NAME,preInstallName.toLowerCase());
            }

            String currentStore = getCurrentStore(context);
            if (currentStore != null){
                params.put(ServerParameters.CURRENT_STORE,currentStore.toLowerCase());
            }

            String afKEy = appsFlyerKey;
            if (afKEy == null || afKEy.length() == 0){
                afKEy = getProperty(AppsFlyerProperties.AF_KEY);
            }
            if (afKEy != null && afKEy.length() > 0){
                params.put(ServerParameters.AF_DEV_KEY,afKEy);
                if (afKEy.length() > 8){
                    params.put("dkh",afKEy.substring(0,8));
                }
            } else {
                AFLogger.afLog(LogMessages.DEV_KEY_MISSING);
                monitor(context,LOG_TAG,MonitorMessages.DEV_KEY_MISSING,null);
                AFLogger.afLog("AppsFlyer will not track this event.");
                return;
            }

            String appUserId = getAppUserId();
            if (appUserId != null){
                params.put("appUserId",appUserId);
            }

            String emailData = AppsFlyerProperties.getInstance().getString(AppsFlyerProperties.USER_EMAILS);
            if (emailData != null) {
                params.put("user_emails", emailData);
            }
            else { // should be removed in the future and not use from now on
                String userEmail = getProperty(AppsFlyerProperties.USER_EMAIL);
                if (userEmail != null) {
                    params.put("sha1_el", HashUtils.toSHA1(userEmail)); // for testing todo remove it
                }
            }

            if (eventName != null){
                params.put(ServerParameters.EVENT_NAME,eventName);
                if (eventValue != null) {
                    params.put(ServerParameters.EVENT_VALUE, eventValue);
                }
            }

            if(getProperty(AppsFlyerProperties.APP_ID) != null) {
                params.put("appid", getProperty(AppsFlyerProperties.APP_ID));
            }
            String currencyCode = getProperty(AppsFlyerProperties.CURRENCY_CODE);
            if(currencyCode != null) {
                if(currencyCode.length() != 3)  {
                    AFLogger.afWarnLog((new StringBuilder()).append(WARNING_PREFIX + "currency code should be 3 characters!!! '").append(currencyCode).append("' is not a legal value.").toString());
                }
                params.put("currency", currencyCode);
            }

            String isUpdate = getProperty(AppsFlyerProperties.IS_UPDATE);
            if(isUpdate != null) {
                params.put("isUpdate", isUpdate);
            }
            boolean isPreInstall = isPreInstalledApp(context);
            params.put("af_preinstalled",Boolean.toString(isPreInstall));

            boolean shouldCollectFBId = AppsFlyerProperties.getInstance().getBoolean(AppsFlyerProperties.COLLECT_FACEBOOK_ATTR_ID, true);

            if (shouldCollectFBId) {
                String facebookAttributeId = getAttributionId(context.getContentResolver());
                if (facebookAttributeId != null){
                    params.put("fb",facebookAttributeId);
                }
            }

            addDeviceTracking(context, params);

            try {
                String uid = Installation.id(context);
                if(uid != null)
                    params.put(ServerParameters.AF_USER_ID, uid);
            }
            catch(Exception e){
                AFLogger.afLog((new StringBuilder()).append(ERROR_PREFIX).append(ERROR_PREFIX).append("could not get uid ").append(e.getMessage()).toString());
            }

            try {
                params.put("lang", Locale.getDefault().getDisplayLanguage());
            } catch(Exception e) {
                // ignore
            }

            try {
                params.put("lang_code", Locale.getDefault().getLanguage());
            } catch(Exception e) {
                // ignore
            }

            try {
                params.put("country", Locale.getDefault().getCountry());
            } catch(Exception e) {
                // ignore
            }
            try {
                TelephonyManager manager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
                params.put("operator",manager.getSimOperatorName());
                params.put("carrier",manager.getNetworkOperatorName());
            } catch (Exception e){
                // ignore
            }

            try {
                params.put("network",getNetwork(context));
            } catch (Throwable e){
                AFLogger.afLog("checking network error "+e.getMessage());
            }


            boolean collectFingerPrint = AppsFlyerProperties.getInstance().getBoolean(AppsFlyerProperties.COLLECT_FINGER_PRINT,true);

            if (collectFingerPrint) {
                String customUUID = getUniquePsuedoID();
                if (customUUID != null) {
                    params.put(ServerParameters.DEVICE_FINGER_PRINT_ID, customUUID);
                }
            }

            addAdvertiserIDData(context,params);
            checkPlatform(context, params);

            SimpleDateFormat dateFormat = new SimpleDateFormat(INSTALL_UPDATE_DATE_FORMAT, Locale.US);

            if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.GINGERBREAD){
                try {
                    long installed = context.getPackageManager().getPackageInfo(context.getPackageName(), 0).firstInstallTime;
                    params.put("installDate",dateFormat.format(new Date(installed)));
                } catch (Exception e){
                    // ignore
                }
            }

            try {
                PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);

                SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
                int versioncode = sharedPreferences.getInt(VERSION_CODE, 0);

                if (packageInfo.versionCode > versioncode) {
                    // New version detected.
                    // Zeroing the conversion data error counter.
                    saveIntegerToSharedPreferences(context, CONVERSION_REQUEST_RETRIES, 0);
                    saveIntegerToSharedPreferences(context, VERSION_CODE, packageInfo.versionCode);

                }

                params.put("app_version_code",Integer.toString(packageInfo.versionCode));
                params.put("app_version_name", packageInfo.versionName);

                if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.GINGERBREAD) {

                    // ***Note this will work only on android 9 and above!!!!!!!!!!!!!!!!!!!!!!!!
                    long firstInstallTime = packageInfo.firstInstallTime;
                    long lastUpdateTime = packageInfo.lastUpdateTime;
                    params.put("date1", dateFormat.format(new Date(firstInstallTime)));
                    params.put("date2", dateFormat.format(new Date(lastUpdateTime)));
                    String firstInstallDate = getFirstInstallDate(dateFormat, context);
                    params.put("firstLaunchDate", firstInstallDate);
                }


            } catch(android.content.pm.PackageManager.NameNotFoundException e) {
                // ignore
            } catch (NoSuchFieldError e){
                // ignore
            }

            if (referrer.length() > 0){
                params.put(REFERRER_PREF,referrer);
            }

            SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
            String attributionString = sharedPreferences.getString(ATTRIBUTION_ID_PREF,null);
            if (attributionString != null && attributionString.length() > 0){
                params.put("installAttribution",attributionString);
            }


            String instanceId = AppsFlyerProperties.getInstance().getString(AppsFlyerProperties.GCM_INSTANCE_ID);
            if (instanceId != null) {
                params.put(ServerParameters.GOOGLE_INSTANCE_ID, instanceId);
            }

            if (isLaunchEvent && context instanceof Activity){
                Uri uri = getDeepLinkUri(context);
                if (uri != null) {
                    handleDeepLinkCallback(context,params,uri);
                }
            }
            if (isInTestMode(referrer)) {
                params.put("testAppMode","true");
                broadcastBacktoTestApp(context, (HashMap<String, String>) params);
                AFLogger.afLog("Sent params to test app");
                endTestMode();
            }

            AFLogger.afLog("AppsFlyerLib.sendTrackingWithEvent");
            new SendToServerRunnable(urlString.toString(),params,context.getApplicationContext(),isLaunchEvent).run();

        }catch (Throwable e) {
            AFLogger.afLogE(e.getLocalizedMessage(),e);
        }
    }

    private Uri getDeepLinkUri(Context context) {
        Uri res = null;
        Intent intent = ((Activity)context).getIntent();
        if (intent != null && intent.getAction().equals(Intent.ACTION_VIEW)) {
            res = intent.getData();
        }
        return res;
    }

    private void handleDeepLinkCallback(Context context, Map<String, String> params, Uri uri) {
        params.put(ServerParameters.DEEP_LINK, uri.toString());

        Map<String, String> attributionMap;
        if (uri.getQueryParameter("af_deeplink") != null) {
            attributionMap = referrerStringToMap(context, uri.getQuery().toString());

            if (uri.getPath() != null) {
                attributionMap.put("path", uri.getPath());
            }

            if (uri.getScheme() != null) {
                attributionMap.put("scheme", uri.getScheme());
            }

        } else {
            attributionMap = new HashMap<String, String>();
            attributionMap.put("link", uri.toString());
        }

        String json = new JSONObject(attributionMap).toString();
        saveDataToSharedPreferences(context, DEEPLINK_ATTR_PREF, json);


        if (conversionDataListener != null) {
            conversionDataListener.onAppOpenAttribution(attributionMap);
        }

    }

    /**
     * Note - the order should never be changed !!!!!!!!
     * @return
     */
    private String generateOtherSDKsString() {
        return new StringBuilder()
                .append(numricBooleanIsClassExist("com.tune.Tune"))
                .append(numricBooleanIsClassExist("com.adjust.sdk.Adjust"))
                .append(numricBooleanIsClassExist("com.kochava.android.tracker.Feature"))
                .append(numricBooleanIsClassExist("io.branch.referral.Branch"))
                .append(numricBooleanIsClassExist("com.apsalar.sdk.Apsalar"))
                .append(numricBooleanIsClassExist("com.localytics.android.Localytics"))
                .append(numricBooleanIsClassExist("com.tenjin.android.TenjinSDK"))
                .append(numricBooleanIsClassExist("com.talkingdata.sdk.TalkingDataSDK"))
                .append(numricBooleanIsClassExist("it.partytrack.sdk.Track"))
                .append(numricBooleanIsClassExist("jp.appAdForce.android.LtvManager"))
                .toString();
    }

    private int numricBooleanIsClassExist(String className){
        try {
            Class.forName(className );
            return 1;
        } catch( ClassNotFoundException e ) {
            return 0;
        }
    }

    private void lastEventsProcessing(Context context, Map<String, String> params, String newEventName, String newEventValue) {
        SharedPreferences sp = context.getSharedPreferences(AF_SHARED_PREF, 0);
        android.content.SharedPreferences.Editor editor = sp.edit();
        try {

            String previousEventName = sp.getString(PREV_EVENT_NAME,null);

           if (previousEventName != null) { // not the first event, previous event exists
                JSONObject json = new JSONObject();
                json.put(PREV_EVENT_TIMESTAMP,sp.getLong(PREV_EVENT_TIMESTAMP,-1)+"");
                json.put(PREV_EVENT_VALUE,sp.getString(PREV_EVENT_VALUE,null));
                json.put(PREV_EVENT_NAME,previousEventName);
                params.put(PREV_EVENT,json.toString());
            } 

            editor.putString(PREV_EVENT_NAME,newEventName);
            editor.putString(PREV_EVENT_VALUE,newEventValue);
            editor.putLong(PREV_EVENT_TIMESTAMP, System.currentTimeMillis());
            editorCommit(editor);
        } catch (Exception e) {
            AFLogger.afLogE("Error while processing previous event.",e);
        }

    }

    private boolean isGooglePlayServicesAvailable(Context context) {

        boolean retValue = false;
        try {

            int statusCode = GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(context);
            if (statusCode == ConnectionResult.SUCCESS) {
                retValue = true;
            }
        }
        catch (Throwable t) {
            AFLogger.afLog(WARNING_PREFIX + "Google play services is unavailable.");
        }
        return retValue;
    }

    private void addDeviceTracking(Context context, Map<String, String> params) {
        boolean deviceTrackingDisabled = AppsFlyerProperties.getInstance().getBoolean(AppsFlyerProperties.DEVICE_TRACKING_DISABLED,false);

        if (deviceTrackingDisabled){
            params.put("deviceTrackingDisabled","true");
        } else {
            SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
            boolean collectIMEI = AppsFlyerProperties.getInstance().getBoolean(AppsFlyerProperties.COLLECT_IMEI,true);
            String cachedImei = sharedPreferences.getString(IMEI_CACHED_PREF,null);
            String imei = null;
            if (collectIMEI){
                if (isIdCollectionAllowed(context)) {
                    try {
                        TelephonyManager manager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
                        String deviceImei = (String) manager.getClass().getMethod("ge" + "tDe" + "vic" + 'e' + "Id").invoke(manager); // mask for Kingsoft chinese regulations. They should use collectIMEI = false, this is just for the robots
                        if (deviceImei != null) {
                            imei = deviceImei;
                        } else if (userCustomImei != null) { // fallback to user-imei in case of failure collecting device-IMEI
                            imei = userCustomImei;
                        } else if (cachedImei != null) {
                            imei = cachedImei;
                        } // else IMEI not collected
                    } catch (Exception e) {
                        //  ignore
                        AFLogger.afLog(WARNING_PREFIX + "READ_PHONE_STATE is missing");
                    }
                } else {
                    if (userCustomImei != null) {
                        imei = userCustomImei;
                    } // else IMEI not collected
                }
            } else {
                if (userCustomImei != null) {
                    imei = userCustomImei;
                } // else IMEI not collected
            }

            if (imei != null) {
                saveDataToSharedPreferences(context, IMEI_CACHED_PREF, imei);
                params.put("imei", imei);
            } else {
                AFLogger.afLog("IMEI was not collected.");
            }


            boolean collectAndroidId = AppsFlyerProperties.getInstance().getBoolean(AppsFlyerProperties.COLLECT_ANDROID_ID,true);
            String cachedAndroidId = sharedPreferences.getString(ANDROID_ID_CACHED_PREF,null);
            String androidId = null;
            if (collectAndroidId) {
                if (isIdCollectionAllowed(context)) {
                    try {
                        String deviceAndroidId = Settings.Secure.getString(context.getContentResolver(), Settings.Secure.ANDROID_ID);
                        if (deviceAndroidId != null) {
                            androidId = deviceAndroidId;
                        } else if (userCustomAndroidId != null) { // fallback to user-android-id in case of failure collecting device-AndroidId
                            androidId = userCustomAndroidId;
                        } else if (cachedAndroidId != null) {
                            androidId = cachedAndroidId;
                        } // else Android-ID not collected
                    } catch (Exception e) {
                        // ignore
                    }
                } else {
                    if (userCustomAndroidId != null) {
                        androidId = userCustomAndroidId;
                    } // else Android-ID not collected
                }
            } else {
                if (userCustomAndroidId != null) {
                    androidId = userCustomAndroidId;
                } // else Android-ID not collected
            }

            if (androidId != null) {
                saveDataToSharedPreferences(context, ANDROID_ID_CACHED_PREF, androidId);
                params.put(ServerParameters.ANDROID_ID, androidId);
            } else {
                AFLogger.afLog("Android ID was not collected.");
            }

        }
    }

    private boolean isIdCollectionAllowed(Context context) {
        return Build.VERSION.SDK_INT < Build.VERSION_CODES.KITKAT || !isGooglePlayServicesAvailable(context);
    }

    private boolean isAppsFlyerFirstLaunch(Context context){
        SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);

        return !sharedPreferences.contains(AF_COUNTER_PREF);
    }

    private String getCachedStore(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
        if (sharedPreferences.contains(INSTALL_STORE_PREF)) {
            return sharedPreferences.getString(INSTALL_STORE_PREF,null);
        } else {
            boolean isFirstLaunch = isAppsFlyerFirstLaunch(context);
            String store = isFirstLaunch ? getCurrentStore(context) : null;
            saveDataToSharedPreferences(context, INSTALL_STORE_PREF, store);
            return store;
        }
    }

    private String getCurrentStore(Context context) {

        return getManifestMetaData(context,"AF_STORE");
    }

    @Nullable
    private String getManifestMetaData(Context context, String key) {
        String res = null;
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), PackageManager.GET_META_DATA);
            Bundle bundle = applicationInfo.metaData;
            if (bundle != null){
                Object storeObj = bundle.get(key);
                if (storeObj != null){
                    res = storeObj.toString();
                }
            }
        } catch (Exception e){
            AFLogger.afLogE("Could not find "+key+" value in the manifest",e);
        }

        return res;
    }

    private String preInstallValueFromFile(Context context) {
        FileReader reader = null;
        try {
            Properties props = new Properties();
            reader = new FileReader("/etc/pre_install.appsflyer");
            props.load(reader);
            AFLogger.afLog("Found pre_install definition");
            return props.getProperty(context.getPackageName());
        } catch (Throwable e) {
            // do nothing
        } finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            } catch (IOException e) {
            }
        }
        return null;
    }

    private String getPreInstallName(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
        if (sharedPreferences.contains(PRE_INSTALL_PREF)) {
            return sharedPreferences.getString(PRE_INSTALL_PREF,null);
        } else {
            boolean isFirstLaunch = isAppsFlyerFirstLaunch(context);
            String preInstallProviderName = null;
            if (isFirstLaunch){
                String valueFromFile = preInstallValueFromFile(context);
                if (valueFromFile != null){
                    return valueFromFile;
                }
                preInstallProviderName = getManifestMetaData(context,"AF_PRE_INSTALL_NAME");
            }

            saveDataToSharedPreferences(context, PRE_INSTALL_PREF, preInstallProviderName);
            return preInstallProviderName;
        }
    }


    private void checkCache(Context context) {
        if (isDuringCheckCache || (System.currentTimeMillis() - lastCacheCheck) < 15000) {
            return;
        }
        if (cacheScheduler != null){
            return;
        }
        cacheScheduler = Executors.newSingleThreadScheduledExecutor();
        cacheScheduler.schedule(new CachedRequestSender(context),1,TimeUnit.SECONDS);
    }

    private String getConfiguredChannel(Context context) {

        String channel = AppsFlyerProperties.getInstance().getString(AppsFlyerProperties.CHANNEL);
        if (channel == null){
            channel = getManifestMetaData(context,"CHANNEL");
        }
        return channel;
    }

    public boolean isPreInstalledApp(Context context) {

        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 0);
            // FLAG_SYSTEM is only set to system applications,
            // this will work even if application is installed in external storage

            // Check if package is system app
            if ((applicationInfo.flags & ApplicationInfo.FLAG_SYSTEM) != 0) {
                return true;
            }
        } catch (PackageManager.NameNotFoundException e) {
            AFLogger.afLogE("Could not check if app is pre installed", e);
        }
        return false;
    }

    private String getCachedChannel(Context context,String currentChannel) throws PackageManager.NameNotFoundException {
        SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
        if (sharedPreferences.contains(CACHED_CHANNEL_PREF)) {
            return sharedPreferences.getString(CACHED_CHANNEL_PREF,null);
        } else {

            saveDataToSharedPreferences(context, CACHED_CHANNEL_PREF, currentChannel);
            return currentChannel;
        }
    }

    private String getFirstInstallDate(SimpleDateFormat dateFormat,Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
        String firstLaunchDate = sharedPreferences.getString(FIRST_INSTALL_PREF, null);
        if (firstLaunchDate == null) {
            if (isAppsFlyerFirstLaunch(context)){
                AFLogger.afDebugLog("AppsFlyer: first launch detected");
                firstLaunchDate = dateFormat.format(new Date());
            } else {
                firstLaunchDate = ""; // unknown
            }
            saveDataToSharedPreferences(context, FIRST_INSTALL_PREF, firstLaunchDate);
        }

        AFLogger.afLog("AppsFlyer: first launch date: "+firstLaunchDate);

        return firstLaunchDate;
    }

    private void addAdvertiserIDData(Context context, Map<String, String> params) {
        AdvertisingIdClient.Info gpsAdInfo;
        com.appsflyer.AdvertisingIdClient.AdInfo internalAdInfo;
        String advertisingId = null;
        String advertisingIdEnabled = null;
        boolean advertisingIdWithGps = false;
        String gaidError = null;
        int statusCode = -1;
        try {
            Class.forName("com.google.android.gms.ads.identifier.AdvertisingIdClient");
            gpsAdInfo = AdvertisingIdClient.getAdvertisingIdInfo(context);

            if (gpsAdInfo != null) {
                advertisingId = gpsAdInfo.getId();
                advertisingIdEnabled = Boolean.toString(!gpsAdInfo.isLimitAdTrackingEnabled());
                advertisingIdWithGps = true;
                if (advertisingId == null || advertisingId.length() == 0){
                    gaidError = "emptyOrNull";
                }
            } else {
                gaidError = "gpsAdInfo-null";
            }
        } catch (Throwable t1){
            try {
                statusCode = GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(context);
            } catch(Throwable ignored) {

            }
            gaidError = t1.getClass().getSimpleName();
            AFLogger.afLog(WARNING_PREFIX+"Google Play services SDK jar is missing.");
            if (AppsFlyerProperties.getInstance().getBoolean(AppsFlyerProperties.ENABLE_GPS_FALLBACK, true)) {
                try {
                    internalAdInfo = com.appsflyer.AdvertisingIdClient.getAdvertisingIdInfo(context);
                    if (internalAdInfo != null) {
                        advertisingId = internalAdInfo.getId();
                        advertisingIdEnabled = Boolean.toString(!internalAdInfo.isLimitAdTrackingEnabled());
                        if (advertisingId == null || advertisingId.length() == 0){
                            gaidError = "emptyOrNull (bypass)";
                        }
                    } else {
                        gaidError = "gpsAdInfo-null (bypass)";
                    }
                } catch (Throwable t2) {
                    debugAction("GAID", "\tgot error: " + t2.getMessage(), context);
                    advertisingId = AppsFlyerProperties.getInstance().getString(ServerParameters.ADVERTISING_ID_PARAM);
                    advertisingIdEnabled = AppsFlyerProperties.getInstance().getString(ServerParameters.ADVERTISING_ID_ENABLED_PARAM);

                    if (t2.getLocalizedMessage() != null){
                        AFLogger.afLog(t2.getLocalizedMessage());
                    } else {
                        AFLogger.afLog(t2.toString());
                    }

                    debugAction("Could not fetch advertiser id: ", t2.getLocalizedMessage(), context);
                }
            }
        }

        if (gaidError != null){
            params.put("gaidError", statusCode+": "+gaidError);
        }

        if (advertisingId != null && advertisingIdEnabled != null) {
            params.put(ServerParameters.ADVERTISING_ID_PARAM, advertisingId);
            params.put(ServerParameters.ADVERTISING_ID_ENABLED_PARAM, advertisingIdEnabled);
            AppsFlyerProperties.getInstance().set(ServerParameters.ADVERTISING_ID_PARAM, advertisingId);
            AppsFlyerProperties.getInstance().set(ServerParameters.ADVERTISING_ID_ENABLED_PARAM, advertisingIdEnabled);
            params.put(ServerParameters.ADVERTISING_ID_WITH_GPS,String.valueOf(advertisingIdWithGps));
        }
    }


    private void checkPlatform(Context context, Map<String, String> params) {

        String sClassName = "com.unity3d.player.UnityPlayer";
        try {
            Class classToInvestigate = Class.forName(sClassName);
            params.put("platformextension", "android_unity");

        } catch (ClassNotFoundException e) {
            // Class not found!
            params.put("platformextension", "android_native");


        } catch (Exception e) {
            // Unknown exception
        }
    }


    public String getAttributionId(ContentResolver contentResolver) {
        String [] projection = {ATTRIBUTION_ID_COLUMN_NAME};
        Cursor cursor  = contentResolver.query(Uri.parse(ATTRIBUTION_ID_CONTENT_URI), projection, null, null, null);
        String attributionId = null;
        try {
            if (cursor == null || !cursor.moveToFirst()) {
                return null;
            } else {
                attributionId = cursor.getString(cursor.getColumnIndex(ATTRIBUTION_ID_COLUMN_NAME));
            }
        } catch (Exception e){
            AFLogger.afWarnLog("Could not collect cursor attribution" + e);
        } finally {
            try {
                if (cursor != null) {
                    cursor.close();
                }
            } catch (Exception e){
                // nothing we can do
            }
        }
        return attributionId;
    }

    private int getCounter(Context context, String parameterName, boolean isIncrease) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);

        int counter = sharedPreferences.getInt(parameterName, 0);

        if (isIncrease){
            counter++;
            @SuppressLint("CommitPrefEdits") android.content.SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putInt(parameterName, counter);
            editorCommit(editor);
        }

        return counter;
    }


    private long getTimePassedSinceLastLaunch(Context context, boolean shouldSave) {

        SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);

        long lastLaunchTime = sharedPreferences.getLong(AF_TIME_PASSED_SINCE_LAST_LAUNCH, 0);

        long currentTime = System.currentTimeMillis();

        long timeInterval;
        if (lastLaunchTime > 0) {
            timeInterval = currentTime - lastLaunchTime;
        }
        else {
            timeInterval = -1;
        }

        if (shouldSave) {
            saveLongToSharedPreferences(context, AF_TIME_PASSED_SINCE_LAST_LAUNCH, currentTime);
        }

        return timeInterval / 1000; // for seconds

    }


    public String getUniquePsuedoID()
    {
        // If all else fails, if the user does have lower than API 9 (lower
        // than Gingerbread), has reset their device or 'Secure.ANDROID_ID'
        // returns 'null', then simply the ID returned will be solely based
        // off their Android device information. This is where the collisions
        // can happen.
        String m_szDevIDShort = "35" + (Build.BOARD.length() % 10) + (Build.BRAND.length() % 10) + (Build.CPU_ABI.length() % 10) + (Build.DEVICE.length() % 10) + (Build.MANUFACTURER.length() % 10) + (Build.MODEL.length() % 10) + (Build.PRODUCT.length() % 10);

        // Only devices with API >= 9 have android.os.Build.SERIAL
        // If a user upgrades software or roots their device, there will be a duplicate entry
        String serial = null;
        try {
            serial = android.os.Build.class.getField("SERIAL").get(null).toString();

            // Return the serial for api => 9
            return new UUID(m_szDevIDShort.hashCode(), serial.hashCode()).toString();
        } catch (Exception exception) {
            // String needs to be initialized. This is an arbitrary value
            serial = "serial";
        }

        // Finally, combine the values we have found by using the UUID class to create a unique identifier
        return new UUID(m_szDevIDShort.hashCode(), serial.hashCode()).toString();
    }




    private String getNetwork(Context context){
        ConnectivityManager cm = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
        if (activeNetwork != null) { // connected to the internet
            if (activeNetwork.getType() == ConnectivityManager.TYPE_WIFI) {
                // connected to wifi
                return "WIFI";
            } else if (activeNetwork.getType() == ConnectivityManager.TYPE_MOBILE) {
                // connected to the mobile provider's data plan
                return "MOBILE";
            }
        } else {
            // not connected to the internet
        }
        return "unknown";
    }
    public String getAppsFlyerUID(Context context){
        return Installation.id(context);
    }

    private void sendRequestToServer(String urlString,
                                            String postDataString,
                                            String afDevKey, WeakReference<Context> ctxReference,
                                            String cacheKey,
                                            boolean shouldRequestConversion) throws IOException {
        URL url = new URL(urlString);

        AFLogger.afLog("url: "+url.toString());

        debugAction(CALL_SERVER_ACTION,"\n"+url.toString()+"\nPOST:"+postDataString,ctxReference.get());
        LogMessages.logMessageMaskKey(LogMessages.EVENT_DATA+postDataString);

        monitor(ctxReference.get(), LOG_TAG, MonitorMessages.EVENT_DATA, postDataString);
        try {
            callServer(url,postDataString,afDevKey,ctxReference,cacheKey,shouldRequestConversion);
        } catch (IOException e){
            boolean useHttpFallback = AppsFlyerProperties.getInstance().getBoolean(AppsFlyerProperties.USE_HTTP_FALLBACK,false);
            if (useHttpFallback){
                debugAction("https failed: "+e.getLocalizedMessage(),"",ctxReference.get());
                callServer(new URL(urlString.replace("https:","http:")),postDataString,afDevKey,ctxReference,cacheKey,shouldRequestConversion);
            } else {
                AFLogger.afLog(LogMessages.SERVER_CALL_FAILRED+e.getLocalizedMessage());
                monitor(ctxReference.get(),LOG_TAG, MonitorMessages.ERROR, e.getLocalizedMessage());
                throw (e); // throw exception for handling the cache data from its caller.
            }
        }
    }

    private void callServer(URL url,
                                   String postData,
                                   String appsFlyerDevKey,
                                   WeakReference<Context> ctxReference,
                                   String cacheKey,
                                   boolean shouldRequestConversion) throws IOException {
        Context context = ctxReference.get();

        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)url.openConnection();

            connection.setRequestMethod("POST");
            int contentLength = postData.getBytes().length;
            connection.setRequestProperty("Content-Length", contentLength + "");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setConnectTimeout(10000);
            connection.setDoOutput(true);
            OutputStreamWriter out = null;
            try {
                out = new OutputStreamWriter(connection.getOutputStream());
                out.write(postData);
            } finally {
                if (out != null){
                    out.close();
                }
            }
            int statusCode = connection.getResponseCode();

            AFLogger.afLogM(LogMessages.SERVER_RESPONSE_CODE+statusCode);

            monitor(context, LOG_TAG, MonitorMessages.SERVER_RESPONSE_CODE, Integer.toString(statusCode));
            debugAction(SERVER_RESPONDED_ACTION,Integer.toString(statusCode),context);
            SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
            if (statusCode == HttpURLConnection.HTTP_OK) {
                if (cacheKey != null){
                    CacheManager.getInstance().deleteRequest(cacheKey,context);
                }
                if (ctxReference.get() != null && cacheKey == null){
                    // we getString it again just to be sure the context still exist.
                    saveDataToSharedPreferences(context, SENT_SUCCESSFULLY_PREF, "true");
                    checkCache(context);
                }
            }

            int retries = sharedPreferences.getInt(CONVERSION_REQUEST_RETRIES,0);

            long conversionDataCachedExpiration  = sharedPreferences.getLong(CONVERSION_DATA_CACHE_EXPIRATION, 0);
            if (conversionDataCachedExpiration != 0 && System.currentTimeMillis() - conversionDataCachedExpiration > SIXTY_DAYS) {
                saveDataToSharedPreferences(context, ATTRIBUTION_ID_PREF, null);
                saveLongToSharedPreferences(context, CONVERSION_DATA_CACHE_EXPIRATION, 0);
            }

            if (sharedPreferences.getString(ATTRIBUTION_ID_PREF,null) == null && appsFlyerDevKey != null && shouldRequestConversion && AppsFlyerLib.conversionDataListener != null && retries <= NUMBER_OF_CONVERSION_DATA_RETRIES){
                // Out of store
                ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
                scheduler.schedule(new InstallAttributionIdFetcher(context.getApplicationContext(),appsFlyerDevKey,scheduler),10, TimeUnit.MILLISECONDS);// it used to be 5000 but as the server have the delay I canceled it
            } else if (appsFlyerDevKey == null){
                AFLogger.afWarnLog("AppsFlyer dev key is missing.");
            } else if (shouldRequestConversion
                    && AppsFlyerLib.conversionDataListener != null
                    && sharedPreferences.getString(ATTRIBUTION_ID_PREF,null) != null
                    && getCounter(context, AF_COUNTER_PREF, false) > 1) {

                Map<String, String> conversionData;
                try {
                    conversionData = getConversionData(context);
                    if (conversionData != null) {
                        AppsFlyerLib.conversionDataListener.onInstallConversionDataLoaded(conversionData);
                    }
                } catch (AttributionIDNotReady ae) {
                    //
                }
            }
        } finally {
            if (connection != null){
                connection.disconnect();
            }
        }
    }

    public void validateAndTrackInAppPurchase(Context context, String publicKey, String signature, String purchaseData, String price, String currency, HashMap<String, String> additionalParameters) {
        AFLogger.afLog("Validate in app called with parameters: " + purchaseData + " " + price + " " +  currency);
        if (publicKey == null || price == null || signature == null || currency == null || purchaseData == null)  {
            if (AppsFlyerLib.validatorListener != null) {
                AppsFlyerLib.validatorListener.onValidateInAppFailure("Please provide purchase parameters");
            }
        }
        else {
            ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
            scheduler.schedule(new AppsFlyerInAppPurchaseValidator(context.getApplicationContext(), getProperty(AppsFlyerProperties.AF_KEY), publicKey, signature, purchaseData, price, currency, additionalParameters ,scheduler), 10, TimeUnit.MILLISECONDS);
        }
    }

    private class DataCollector implements Runnable {

        private Context context;
        private String appsFlyerKey;
        private String eventName;
        private String eventValue;
        private String referrer;
        private ExecutorService executor;
        private boolean isNewAPI;

        private DataCollector(Context context,
                              String appsFlyerKey,
                              String eventName,
                              String eventValue,
                              String referrer,
                              boolean useNewAPI,
                              ExecutorService executorService) {
            this.context = context;
            this.appsFlyerKey = appsFlyerKey;
            this.eventName = eventName;
            this.eventValue = eventValue;
            this.referrer = referrer;
            this.isNewAPI = useNewAPI;
            this.executor = executorService;
        }

        public void run() {
            sendTrackingWithEvent(context,appsFlyerKey,eventName,eventValue,referrer,isNewAPI);
            executor.shutdown();
        }
    }

    private class SendToServerRunnable implements Runnable{

        private String urlString;
        private WeakReference<Context> ctxReference = null;
        Map<String,String> params;
        boolean isLaunch;


        private SendToServerRunnable(String urlString,
                                     Map<String, String> params,
                                     Context ctx,
                                     boolean isLaunch) {
            this.urlString = urlString;
            this.params = params;
            this.ctxReference = new WeakReference<Context>(ctx);
            this.isLaunch = isLaunch;
        }

        public void run() {
            String postDataString = null;

            try {
                Context context = ctxReference.get();
                boolean sentSuccessfully = false;
                if (context != null){
                    String referrer = AppsFlyerProperties.getInstance().getReferrer(context);
                    if (referrer != null && referrer.length() > 0 && params.get(REFERRER_PREF) == null){
                        //referrer exist in storage but not in the URL - we need to add it
                        params.put(REFERRER_PREF,referrer);
                    }
                    SharedPreferences sharedPreferences = context.getSharedPreferences(AF_SHARED_PREF, 0);
                    sentSuccessfully = "true".equals(sharedPreferences.getString(SENT_SUCCESSFULLY_PREF,""));
                    String eventName = params.get(ServerParameters.EVENT_NAME);
                    int counter = getCounter(context, AF_COUNTER_PREF ,eventName == null);
                    params.put("counter",Integer.toString(counter)); // eventName == null on launch
                    params.put("iaecounter",Integer.toString(getCounter(context,AF_EVENT_COUNTER_PREF,eventName != null))); // eventName == null on launch
                    params.put(ServerParameters.TIME_PASSED_SINCE_LAST_LAUNCH, Long.toString(getTimePassedSinceLastLaunch(context, true)));

                    if (isLaunch && counter == 1) { // we set it as late as we can.
                        AppsFlyerProperties.getInstance().setFirstLaunchCalled();
                    }
                }
                params.put("isFirstCall",Boolean.toString(!sentSuccessfully));

                String afDevKey = params.get(ServerParameters.AF_DEV_KEY);
                if (afDevKey == null || afDevKey.length() == 0){
                    AFLogger.afDebugLog("Not sending data yet, waiting for dev key");
                    return;
                }
                // for verification against frauds
                String hash = new HashUtils().getHashCode(params);
                params.put("af_v", hash);


                postDataString  = new JSONObject(params).toString();

                sendRequestToServer(urlString,postDataString,afDevKey,ctxReference,null, (isLaunch && AppsFlyerLib.conversionDataListener != null) );

            } catch (IOException t){
                if (postDataString != null && ctxReference != null && !urlString.contains(CACHED_URL_PARAMETER)){
                    AFLogger.afLogE(t.getMessage(),t);
                    CacheManager.getInstance().cacheRequest(new RequestCacheData(urlString, postDataString, SDK_BUILD_NUMBER), ctxReference.get());
                }
            } catch (Throwable t){
                AFLogger.afLogE(t.getMessage(),t);
            }
        }
    }

    public String mapToString(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder postData = new StringBuilder();
        for (String key : params.keySet()){
            String value = params.get(key);
            value = value == null ? "" : URLEncoder.encode(value,"UTF-8");
            if (postData.length() > 0){
                postData.append('&');
            }
            postData.append(key).append('=').append(value);
        }


        return postData.toString();
    }

    private class InstallAttributionIdFetcher extends AttributionIdFetcher{

        public InstallAttributionIdFetcher(Context context, String appsFlyerDevKey, ScheduledExecutorService executorService) {
            super(context, appsFlyerDevKey, executorService);
        }

        @Override
        public String getUrl() {
            return CONVERSION_DATA_URL;
        }
        @Override
        protected void attributionCallback(Map<String, String> conversionData) {
            AppsFlyerLib.conversionDataListener.onInstallConversionDataLoaded(conversionData);
            SharedPreferences sharedPreferences = this.ctxReference.get().getSharedPreferences(AF_SHARED_PREF, 0);
            saveIntegerToSharedPreferences(this.ctxReference.get(), CONVERSION_REQUEST_RETRIES, 0);
        }
        @Override
        protected void attributionCallbackFailure(String error, int responseCode) {
            AppsFlyerLib.conversionDataListener.onInstallConversionFailure(error);

            if (responseCode >= 400 && responseCode < 500) {
                SharedPreferences sharedPreferences = this.ctxReference.get().getSharedPreferences(AF_SHARED_PREF, 0);
                int retries = sharedPreferences.getInt(CONVERSION_REQUEST_RETRIES,0);
                saveIntegerToSharedPreferences(this.ctxReference.get(), CONVERSION_REQUEST_RETRIES, ++retries);

            }
        }
    }
    
    private abstract class AttributionIdFetcher implements Runnable {

        protected WeakReference<Context> ctxReference = null;
        private String appsFlyerDevKey;
        private ScheduledExecutorService executorService;

        protected abstract void attributionCallback(Map<String, String> conversionData);
        public abstract String getUrl();
        protected abstract void attributionCallbackFailure(String error, int responseCode);

        private AtomicInteger currentRequestsCounter = new AtomicInteger(0);

        public AttributionIdFetcher(Context context, String appsFlyerDevKey, ScheduledExecutorService executorService) {
            this.ctxReference = new WeakReference<Context>(context);
            this.appsFlyerDevKey = appsFlyerDevKey;
            this.executorService = executorService;
        }

        public void run() {
            if (appsFlyerDevKey == null || appsFlyerDevKey.length() == 0){
                return;
            }
            currentRequestsCounter.incrementAndGet();
            HttpURLConnection connection = null;
            try {
                Context context = ctxReference.get();
                if (context == null){
                    return;
                }

                long now = System.currentTimeMillis();
                String channel = getCachedChannel(context,getConfiguredChannel(context));
                String channelPostfix = "";
                if (channel != null){
                    channelPostfix = "-"+channel;
                }
                StringBuilder urlString = new StringBuilder()
                        .append(getUrl())
                        .append(context.getPackageName())
                        .append(channelPostfix)
                        .append("?devkey=").append(appsFlyerDevKey)
                        .append("&device_id=").append(getAppsFlyerUID(context));

                LogMessages.logMessageMaskKey("Calling server for attribution url: "+urlString.toString());

                connection= (HttpURLConnection)new URL(urlString.toString()).openConnection();

                connection.setRequestMethod("GET");
                connection.setConnectTimeout(10000);
                connection.setRequestProperty("Connection","close");
                connection.connect();

                if (connection.getResponseCode() == HttpURLConnection.HTTP_OK) {

                    long responseTime = System.currentTimeMillis();

                    saveLongToSharedPreferences(context, GET_CONVERSION_DATA_TIME, (responseTime - now) / 1000);

                    // read the output from the server
                    BufferedReader reader = null;
                    StringBuilder stringBuilder = new StringBuilder();
                    InputStreamReader inputStreamReader = null;
                    try {
                        inputStreamReader = new InputStreamReader(connection.getInputStream());
                        reader = new BufferedReader(inputStreamReader);

                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            stringBuilder.append(line).append('\n');
                        }
                    } finally {
                        if (reader != null){
                            reader.close();
                        }
                        if (inputStreamReader != null){
                            inputStreamReader.close();
                        }
                    }

                    LogMessages.logMessageMaskKey("Attribution data: " + stringBuilder.toString());

                    if (stringBuilder.length() > 0 && context != null){
                        Map<String,String> conversionDataMap = attributionStringToMap(stringBuilder.toString());
                        String isCache = conversionDataMap.get("iscache");


                        if (isCache != null && "false".equals(isCache)) {
                            // save expiration date.
                            saveLongToSharedPreferences(context, CONVERSION_DATA_CACHE_EXPIRATION, System.currentTimeMillis());
                        }

                        String conversionJsonString = new JSONObject(conversionDataMap).toString();
                        if (conversionJsonString != null) {
                            saveDataToSharedPreferences(context, ATTRIBUTION_ID_PREF, conversionJsonString);
                        }
                        else {
                            saveDataToSharedPreferences(context, ATTRIBUTION_ID_PREF, stringBuilder.toString());
                        }

                        AFLogger.afDebugLog("iscache=" + isCache + " caching conversion data");

                        if (AppsFlyerLib.conversionDataListener != null){
                            if (currentRequestsCounter.intValue() <= 1){ // if we had 2 requests from onReceive and from onCreate we wait for the last one which should be he none organic
                                Map<String,String> conversionData;
                                try {
                                    conversionData = getConversionData(context);
                                } catch (AttributionIDNotReady ae){
                                    conversionData = conversionDataMap;
                                }
                                attributionCallback(conversionData);
                            }
                        }
                    }

                } else {
                    if (AppsFlyerLib.conversionDataListener != null){
                        attributionCallbackFailure("Error connection to server: " + connection.getResponseCode(), connection.getResponseCode());
                    }
                    LogMessages.logMessageMaskKey("AttributionIdFetcher response code: "+connection.getResponseCode()+"  url: "+urlString);

                }
            } catch (Throwable t){
                if (AppsFlyerLib.conversionDataListener != null){
                    attributionCallbackFailure(t.getMessage(), 0);
                }
                AFLogger.afLogE(t.getMessage(),t);
            } finally {
                currentRequestsCounter.decrementAndGet();
                if (connection != null){
                    connection.disconnect();
                }
            }
            executorService.shutdown();
        }
    }

    private class CachedRequestSender implements Runnable {

        private WeakReference<Context> ctxReference = null;

        public CachedRequestSender(Context context) {
            ctxReference = new WeakReference<Context>(context);
        }

        public void run() {
            if (isDuringCheckCache){
                return;
            }
            lastCacheCheck = System.currentTimeMillis();
            if (ctxReference == null){
                return;
            }
            isDuringCheckCache = true;
            try {
                String afDevKey = getProperty(AppsFlyerProperties.AF_KEY);
                synchronized (ctxReference){
                    for (RequestCacheData requestCacheData : CacheManager.getInstance().getCachedRequests(ctxReference.get())){

                        AFLogger.afLog("resending request: "+requestCacheData.getRequestURL());

                        try {
                            // convert cache key name (file name) to miliseconds

                            long currentTime = System.currentTimeMillis();
                            String cachedTimeString = requestCacheData.getCacheKey();
                            long cachedTime =  Long.parseLong(cachedTimeString, 10);

                            sendRequestToServer(requestCacheData.getRequestURL() + CACHED_URL_PARAMETER + Long.toString((currentTime - cachedTime) / 1000),
                                    requestCacheData.getPostData(),
                                    afDevKey,
                                    ctxReference,
                                    requestCacheData.getCacheKey(),
                                    false);

                        } catch (Exception e){
                            AFLogger.afLog("Failed to resend cached request");
                        }
                    }
                }
            } catch (Exception e){
                AFLogger.afLog("failed to check cache.");
            } finally {
                isDuringCheckCache = false;
            }
            cacheScheduler.shutdown();
            cacheScheduler = null;
        }
    }

    private class AppsFlyerInAppPurchaseValidator extends ValidateInAppPurchase{

        public AppsFlyerInAppPurchaseValidator(Context context, String appsFlyerDevKey, String pubKey, String purData, String sig, String price, String currency, HashMap<String, String> additionalParams    ,ScheduledExecutorService executorService) {
            super(context, appsFlyerDevKey, pubKey, purData, sig, price, currency, additionalParams, executorService);
        }

        @Override
        public String getUrl() {
            return VALIDATE_URL;
        }
        @Override
        protected void validateCallback(boolean validated, String purchaseData, String price, String currency, HashMap<String, String> additionalParams, String error) {

            if (AppsFlyerLib.validatorListener != null) {

                AFLogger.afLog("Validate callback parameters: " + purchaseData + " " + price + " " + currency);
                if (error == null) {

                    if (validated) {
                        AFLogger.afLog("Validate in app purchase success");
                        AppsFlyerLib.validatorListener.onValidateInApp();
                    }
                    else {
                        AFLogger.afLog("Validate in app purchase failed");
                        AppsFlyerLib.validatorListener.onValidateInAppFailure("Failed validating");
                    }
                }
                else {
                    AppsFlyerLib.validatorListener.onValidateInAppFailure(error);
                    AFLogger.afLog("Validate in app purchase failed: error : " + error);

                }

                Map<String,Object> eventMap = new HashMap<String,Object>();

                eventMap.put(AFInAppEventParameterName.VALIDATED, validated);
                eventMap.put(AFInAppEventParameterName.PARAM_2, purchaseData);
                eventMap.put(AFInAppEventParameterName.REVENUE, price);
                eventMap.put(AFInAppEventParameterName.CURRENCY, currency);
                if (additionalParams != null)
                     eventMap.put(AFInAppEventParameterName.PARAM_1, additionalParams);

                trackEvent(this.ctxReference.get(), AFInAppEventType.PURCHASE, eventMap);
            }
        }
    }



    private abstract class ValidateInAppPurchase implements Runnable {

        protected WeakReference<Context> ctxReference = null;
        private String appsFlyerDevKey, googlePublicKey, signature, purchaseData, price, currency;
        private HashMap<String, String> additionalParams;
        private ScheduledExecutorService executorService;

        protected abstract void validateCallback(boolean validated, String purchaseData, String price, String currency, HashMap<String, String> additionalParameters, String error);
        public abstract String getUrl();


        public ValidateInAppPurchase(Context context, String appsFlyerDevKey, String aPublicKey, String aSignature, String aPurchaseData, String aPrice, String aCurrency, HashMap<String, String> aAdditionalParams, ScheduledExecutorService executorService) {
            this.ctxReference = new WeakReference<Context>(context);
            this.appsFlyerDevKey = appsFlyerDevKey;
            this.googlePublicKey = aPublicKey;
            this.purchaseData = aPurchaseData;
            this.price = aPrice;
            this.currency = aCurrency;
            this.additionalParams = aAdditionalParams;
            this.signature = aSignature;
            this.executorService = executorService;
        }

        public void run() {
            if (appsFlyerDevKey == null || appsFlyerDevKey.length() == 0){
                return;
            }

            HttpURLConnection connection = null;
            try {
                Context context = ctxReference.get();
                if (context == null){
                    return;
                }

                Map<String,String> parameters = new HashMap<String,String>();
                parameters.put("app_id", context.getPackageName());
                parameters.put("dev_key", appsFlyerDevKey);
                parameters.put("public-key", this.googlePublicKey);
                parameters.put("sig-data", this.purchaseData);
                parameters.put("signature", this.signature);


                JSONObject requestJsonObject = new JSONObject(parameters);
                String postData = requestJsonObject.toString();

                URL url = new URL(getUrl());
                connection = (HttpURLConnection)url.openConnection();

                connection.setRequestMethod("POST");
                int contentLength = postData.getBytes().length;
                connection.setRequestProperty("Content-Length", contentLength + "");
                connection.setRequestProperty("Connection","close");
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setConnectTimeout(10000);
                connection.setDoOutput(true);
                OutputStreamWriter out = null;

                try {

                    out = new OutputStreamWriter(connection.getOutputStream());
                    out.write(postData);

                } finally {

                    if (out != null) {
                        out.close();
                    }
                }

                int statusCode = connection.getResponseCode();
                BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder sb = new StringBuilder();
                String output;

                while ((output = br.readLine()) != null) {
                    sb.append(output);
                }

                String str = sb.toString();
                JSONObject responseJsonObject = new JSONObject(str);

                if (statusCode == HttpURLConnection.HTTP_OK) {
                    AFLogger.afLog("Validate response 200 ok: " + responseJsonObject.toString());

                    boolean validated  = responseJsonObject.getBoolean("result");
                    validateCallback(validated, this.purchaseData, this.price, this.currency, this.additionalParams, null);

                } else {
                    AFLogger.afLog("Failed Validate request");
                    validateCallback(false, this.purchaseData, this.price, this.currency, this.additionalParams, str);
                }
            } catch (Throwable t){
                if (AppsFlyerLib.validatorListener != null){
                    AFLogger.afLog("Failed Validate request + ex = " + t.getMessage());
                    validateCallback(false, this.purchaseData, this.price, this.currency, this.additionalParams, t.getMessage());
                }

                AFLogger.afLogE(t.getMessage(),t);
            } finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
            executorService.shutdown();
        }
    }
}

