/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.cache;

import android.content.Context;
import android.util.Log;
import com.appsflyer.cache.RequestCacheData;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class CacheManager {
    public static final int CACHE_MAX_SIZE = 40;
    public static final String AF_CACHE_DIR = "AFRequestCache";
    private static CacheManager ourInstance = new CacheManager();

    public static CacheManager getInstance() {
        return ourInstance;
    }

    private CacheManager() {
    }

    private File getCacheDir(Context context) {
        return new File(context.getFilesDir(), AF_CACHE_DIR);
    }

    public void init(Context context) {
        try {
            if (!this.getCacheDir(context).exists()) {
                this.getCacheDir(context).mkdir();
            }
        }
        catch (Exception e) {
            Log.i((String)"AppsFlyer_3.4", (String)"Could not create cache directory");
        }
    }

    public void cacheRequest(RequestCacheData data, Context context) {
        try {
            File cacheDir = this.getCacheDir(context);
            if (!cacheDir.exists()) {
                cacheDir.mkdir();
                return;
            }
            if (cacheDir.listFiles().length > 40) {
                Log.i((String)"AppsFlyer_3.4", (String)"reached cache limit, not caching request");
                return;
            }
            Log.i((String)"AppsFlyer_3.4", (String)"caching request...");
            File requestFile = new File(this.getCacheDir(context), Long.toString(System.currentTimeMillis()));
            requestFile.createNewFile();
            OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(requestFile.getPath(), true));
            out.write("version=");
            out.write(data.getVersion());
            out.write(10);
            out.write("url=");
            out.write(data.getRequestURL());
            out.write(10);
            out.write("data=");
            out.write(data.getPostData());
            out.write(10);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            Log.i((String)"AppsFlyer_3.4", (String)"Could not cache request");
        }
    }

    public List<RequestCacheData> getCachedRequests(Context context) {
        ArrayList<RequestCacheData> requests = new ArrayList<RequestCacheData>();
        try {
            File cacheDir = this.getCacheDir(context);
            if (!cacheDir.exists()) {
                cacheDir.mkdir();
            } else {
                File[] files;
                for (File file : files = cacheDir.listFiles()) {
                    Log.i((String)"AppsFlyer_3.4", (String)("Found cached request" + file.getName()));
                    requests.add(this.loadRequestData(file));
                }
            }
        }
        catch (Exception e) {
            Log.i((String)"AppsFlyer_3.4", (String)"Could not cache request");
        }
        return requests;
    }

    private RequestCacheData loadRequestData(File file) {
        try {
            FileReader reader = new FileReader(file);
            char[] chars = new char[(int)file.length()];
            reader.read(chars);
            RequestCacheData cacheData = new RequestCacheData(chars);
            cacheData.setCacheKey(file.getName());
            reader.close();
            return cacheData;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void deleteRequest(String cacheKey, Context context) {
        File cacheDir = this.getCacheDir(context);
        File cachedRequestFile = new File(cacheDir, cacheKey);
        Log.i((String)"AppsFlyer_3.4", (String)("Deleting " + cacheKey + " from cache"));
        if (cachedRequestFile.exists()) {
            try {
                cachedRequestFile.delete();
            }
            catch (Exception e) {
                Log.i((String)"AppsFlyer_3.4", (String)("Could not delete " + cacheKey + " from cache"), (Throwable)e);
            }
        }
    }
}

