/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import com.appsflyer.AFLogger;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class Foreground
implements Application.ActivityLifecycleCallbacks {
    public static final long CHECK_DELAY = 500L;
    private static Foreground instance;
    private boolean foreground = false;
    private boolean paused = true;
    private Handler handler = new Handler();
    private List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private Runnable check;

    public static Foreground init(Application application) {
        if (instance == null) {
            instance = new Foreground();
            if (Build.VERSION.SDK_INT >= 14) {
                application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)instance);
            }
        }
        return instance;
    }

    public static Foreground get(Application application) {
        if (instance == null) {
            Foreground.init(application);
        }
        return instance;
    }

    public static Foreground get(Context ctx) {
        if (instance == null) {
            Context appCtx = ctx.getApplicationContext();
            if (appCtx instanceof Application) {
                Foreground.init((Application)appCtx);
            }
            throw new IllegalStateException("Foreground is not initialised and cannot obtain the Application object");
        }
        return instance;
    }

    public static Foreground getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Foreground is not initialised - invoke at least once with parameter init/get");
        }
        return instance;
    }

    public boolean isForeground() {
        return this.foreground;
    }

    public boolean isBackground() {
        return !this.foreground;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void onActivityResumed(Activity activity) {
        this.paused = false;
        boolean wasBackground = !this.foreground;
        this.foreground = true;
        if (this.check != null) {
            this.handler.removeCallbacks(this.check);
        }
        if (wasBackground) {
            for (Listener l : this.listeners) {
                try {
                    l.onBecameForeground(activity);
                }
                catch (Exception exc) {
                    AFLogger.afLogE("Listener threw exception! ", exc);
                }
            }
        }
    }

    public void onActivityPaused(final Activity activity) {
        this.paused = true;
        if (this.check != null) {
            this.handler.removeCallbacks(this.check);
        }
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                if (Foreground.this.foreground && Foreground.this.paused) {
                    Foreground.this.foreground = false;
                    for (Listener l : Foreground.this.listeners) {
                        try {
                            l.onBecameBackground(activity);
                        }
                        catch (Exception exc) {
                            AFLogger.afLogE("Listener threw exception! ", exc);
                        }
                    }
                }
            }
        });
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    public static interface Listener {
        public void onBecameForeground(Activity var1);

        public void onBecameBackground(Activity var1);
    }
}

