/*
 * Decompiled with CFR 0.152.
 */
package com.tracelytics.logging;

import com.tracelytics.a.f.a.h;
import com.tracelytics.joboe.config.ConfigContainer;
import com.tracelytics.joboe.config.ConfigProperty;
import com.tracelytics.logging.setting.LogSetting;
import com.tracelytics.util.DaemonThreadFactory;
import com.tracelytics.util.HostInfoUtils;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class Logger {
    public static final String APPOPTICS_TAG = "[AppOptics]";
    private static final Level c = Level.INFO;
    private static final ThreadLocal<DateFormat> d = new ThreadLocal<DateFormat>(){

        @Override
        protected final /* synthetic */ Object initialValue() {
            return new SimpleDateFormat("MMM dd, yyyy hh:mm:ss.SSS aa");
        }
    };
    private static final LogSetting e = new LogSetting(c, true, true, null, null, null);
    static final Logger a = new Logger();
    static final Logger b = new Logger();
    private Level f = c;
    private c g = new d(0);
    private c h = new e(0);

    Logger() {
    }

    private c a(Path path, int n2, int n3) {
        String string = HostInfoUtils.getAzureInstanceId();
        if (string != null) {
            Path path2 = path.getFileName();
            string = string + "-" + path2.toString();
            path = path.getParent() != null ? Paths.get(path.getParent().toString(), string) : Paths.get(string, new String[0]);
        }
        try {
            this.info("Java agent log location: " + path.toAbsolutePath().toString());
            return new b(path, n2 << 10 << 10, n3);
        }
        catch (IOException iOException) {
            this.warn("Failed to redirect logs to [" + path.toAbsolutePath() + "] : " + iOException.getMessage(), iOException);
            return null;
        }
    }

    public void fatal(String string) {
        this.log(Level.FATAL, string);
    }

    public void fatal(String string, Throwable throwable) {
        this.log(Level.FATAL, string, throwable);
    }

    public void error(String string) {
        this.log(Level.ERROR, string);
    }

    public void error(String string, Throwable throwable) {
        this.log(Level.ERROR, string, throwable);
    }

    public void warn(String string) {
        this.log(Level.WARNING, string);
    }

    public void warn(String string, Throwable throwable) {
        this.log(Level.WARNING, string, throwable);
    }

    public void info(String string) {
        this.log(Level.INFO, string);
    }

    public void info(String string, Throwable throwable) {
        this.log(Level.INFO, string, throwable);
    }

    public void debug(String string) {
        this.log(Level.DEBUG, string);
    }

    public void debug(String string, Throwable throwable) {
        this.log(Level.DEBUG, string, throwable);
    }

    public void trace(String string) {
        this.log(Level.TRACE, string);
    }

    public void trace(String string, Throwable throwable) {
        this.log(Level.TRACE, string, throwable);
    }

    public void log(Level level, String string) {
        this.log(level, string, null);
    }

    public void log(Level object, String string, Throwable throwable) {
        if (object == null) {
            if (this.shouldLog(Level.ERROR)) {
                String string2 = "Missing log Level for this log message!";
                Level level = Level.ERROR;
                object = this;
                ((Logger)object).a(level, string2, null);
            }
            if (this.shouldLog(c)) {
                this.a(c, string, throwable);
                return;
            }
        } else if (this.shouldLog((Level)((Object)object))) {
            this.a((Level)((Object)object), string, throwable);
        }
    }

    private void a(Level level, String string, Throwable throwable) {
        c c2 = level.compareTo(Level.INFO) < 0 ? this.g : this.h;
        c2.a(Logger.a(level, string));
        if (throwable != null) {
            c2.a(throwable);
        }
    }

    private static String a(Level object, String string) {
        String string2 = d.get().format(Calendar.getInstance().getTime());
        object = string2 + " " + object.toString() + " [AppOptics]" + " ";
        if (string != null) {
            return (String)object + string;
        }
        return object;
    }

    public boolean shouldLog(Level level) {
        return level.compareTo(this.f) <= 0;
    }

    final void a(ConfigContainer object) {
        Level level;
        Logger logger;
        LogSetting logSetting = (LogSetting)((ConfigContainer)object).get(ConfigProperty.AGENT_LOGGING);
        if (logSetting == null) {
            logSetting = e;
        }
        if (((ConfigContainer)object).containsProperty(ConfigProperty.AGENT_DEBUG) && ((Boolean)((ConfigContainer)object).get(ConfigProperty.AGENT_DEBUG)).booleanValue()) {
            logger = this;
            level = Level.DEBUG;
        } else {
            logger = this;
            level = logSetting.getLevel() != null ? logSetting.getLevel() : c;
        }
        logger.f = level;
        Iterable<Path> iterable = null;
        if (((ConfigContainer)object).containsProperty(ConfigProperty.AGENT_LOG_FILE)) {
            iterable = (Path)((ConfigContainer)object).get(ConfigProperty.AGENT_LOG_FILE);
        } else if (logSetting.getLogFilePath() != null) {
            iterable = logSetting.getLogFilePath();
        }
        object = null;
        if (iterable != null) {
            if (com.tracelytics.a.f.a.h.b < 51) {
                this.info("Cannot set up log file at [" + iterable + "] as it is only supported for JDK 7 or later");
            } else {
                object = this.a((Path)iterable, logSetting.getLogFileMaxSize(), logSetting.getLogFileMaxBackup());
            }
        }
        iterable = new ArrayList();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (logSetting.isStderrEnabled()) {
            iterable.add(com.tracelytics.logging.Logger$d.a);
        }
        if (logSetting.isStdoutEnabled()) {
            arrayList.add(com.tracelytics.logging.Logger$e.a);
        }
        if (object != null) {
            iterable.add((Object)object);
            arrayList.add(object);
        }
        if (iterable.size() == 1) {
            this.g = (c)iterable.get(0);
        } else {
            Iterable<Path> iterable2 = iterable;
            this.g = new a(this, iterable2.toArray((c[])new c[iterable2.size()]), 0);
        }
        if (arrayList.size() == 1) {
            this.h = (c)arrayList.get(0);
            return;
        }
        ArrayList<Object> arrayList2 = arrayList;
        this.h = new a(this, arrayList2.toArray(new c[arrayList2.size()]), 0);
    }

    public Level getLoggerLevel() {
        return this.f;
    }

    static final class com.tracelytics.logging.Logger$b
    implements c,
    Closeable {
        private final Path a;
        private final Path b;
        private FileChannel c;
        private PrintWriter d;
        private Long e;
        private Long f;
        private long g;
        private int h;
        private final ExecutorService i = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(100000), DaemonThreadFactory.newInstance("file-logger"));

        com.tracelytics.logging.Logger$b(Path path, int n2, int n3) throws IOException {
            Path path2 = path;
            Object object = this;
            ((com.tracelytics.logging.Logger$b)object).a(path2, true);
            this.a = path;
            object = System.getProperty("java.io.tmpdir");
            this.b = object != null && Files.isWritable(Paths.get((String)object, new String[0])) ? Paths.get((String)object, path.getFileName() + ".lock") : Paths.get(path.toString() + ".lock", new String[0]);
            a.debug("Using " + this.b + " for log file lock for file rolling");
            this.g = n2;
            this.h = n3;
        }

        private void a(Path path, boolean bl) throws IOException {
            long l2 = System.currentTimeMillis();
            if (bl ? true : (bl = this.f == null || l2 - this.f >= 60000L)) {
                this.a();
                this.c = FileChannel.open(path, StandardOpenOption.APPEND, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                this.d = new PrintWriter(new BufferedWriter(Channels.newWriter(this.c, Charset.defaultCharset().newEncoder(), -1)));
                this.f = l2;
            }
        }

        public final void a(String string) {
            try {
                this.i.submit(new b(this, string){
                    private /* synthetic */ String a;
                    private /* synthetic */ com.tracelytics.logging.Logger$b b;
                    {
                        this.b = b2;
                        this.a = string;
                        super(b2, (byte)0);
                    }

                    protected final void a() {
                        this.b.d.println(this.a);
                        this.b.d.flush();
                    }
                });
                return;
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                b.debug("Failed to log message to file as queue is full " + rejectedExecutionException.getMessage(), rejectedExecutionException);
                return;
            }
        }

        public final void a(Throwable throwable) {
            try {
                this.i.submit(new b(this, throwable){
                    private /* synthetic */ Throwable a;
                    private /* synthetic */ com.tracelytics.logging.Logger$b b;
                    {
                        this.b = b2;
                        this.a = throwable;
                        super(b2, (byte)0);
                    }

                    protected final void a() {
                        this.a.printStackTrace(this.b.d);
                        this.b.d.flush();
                    }
                });
                return;
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                b.debug("Failed to log message to file as queue is full " + rejectedExecutionException.getMessage(), rejectedExecutionException);
                return;
            }
        }

        public final void close() {
            long l2 = 5L;
            com.tracelytics.logging.Logger$b b2 = this;
            b2.i.shutdown();
            try {
                b2.i.awaitTermination(5L, TimeUnit.SECONDS);
                b2.a();
                return;
            }
            catch (Exception exception) {
                return;
            }
        }

        private void a() throws IOException {
            if (this.d != null) {
                this.d.flush();
                this.d.close();
            }
            if (this.c != null) {
                this.c.close();
            }
        }

        private boolean b() throws IOException {
            com.tracelytics.logging.Logger$b b2 = this;
            if (b2.c.size() > b2.g) {
                com.tracelytics.logging.Logger$b b3;
                boolean bl = false;
                try {
                    if (this.c()) {
                        a.debug("Log file [" + this.a + "] exceeds " + this.g / 1024L / 1024L + " MB, attempt to roll the log files.");
                        bl = this.d();
                    }
                    b3 = this;
                }
                catch (Throwable throwable) {
                    com.tracelytics.logging.Logger$b b4 = this;
                    b4.a(b4.a, false);
                    throw throwable;
                }
                b3.a(b3.a, bl);
            }
            return true;
        }

        private boolean c() throws IOException {
            return Files.size(this.a) > this.g && (this.e == null || System.currentTimeMillis() - this.e >= 60000L);
        }

        private boolean d() throws IOException {
            a a2 = null;
            try {
                a2 = this.e();
                boolean bl = false;
                if (a2 == null) {
                    a.warn("Failed to acquire lock on log file after 5 tries during the attempt to roll.");
                } else if (this.c()) {
                    try {
                        com.tracelytics.logging.Logger$b b2 = this;
                        Path path = Paths.get(b2.a.toString() + "." + b2.h, new String[0]);
                        Files.deleteIfExists(path);
                        for (int i2 = b2.h - 1; i2 > 0; --i2) {
                            Path path2 = Paths.get(b2.a.toString() + "." + i2, new String[0]);
                            Path path3 = Paths.get(b2.a.toString() + "." + (i2 + 1), new String[0]);
                            if (!Files.exists(path2, new LinkOption[0])) continue;
                            Files.move(path2, path3, StandardCopyOption.ATOMIC_MOVE);
                        }
                        Files.move(b2.a, Paths.get(b2.a.toString() + ".1", new String[0]), StandardCopyOption.ATOMIC_MOVE);
                        bl = true;
                        a.debug("Successfully rolled the log files");
                        this.e = null;
                    }
                    catch (IOException iOException) {
                        a.warn("Failed to roll the log files, exception message: " + iOException.getMessage(), iOException);
                        this.e = System.currentTimeMillis();
                        throw iOException;
                    }
                }
                return bl;
            }
            finally {
                if (a2 != null) {
                    a2.a.release();
                    a2.b.close();
                }
            }
        }

        private a e() {
            int n2 = 0;
            while (++n2 <= 5) {
                try {
                    FileChannel fileChannel = FileChannel.open(this.b, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                    FileLock fileLock = fileChannel.tryLock();
                    if (fileLock != null) {
                        return new a(this, fileLock, fileChannel, 0);
                    }
                }
                catch (IOException iOException) {
                    a.debug("Failed to obtain lockChannel : " + iOException.getMessage(), iOException);
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    a.debug("Retry lock sleep interrupted", interruptedException);
                }
            }
            return null;
        }

        final class a {
            private final FileLock a;
            private final FileChannel b;

            private a(com.tracelytics.logging.Logger$b b2, FileLock fileLock, FileChannel fileChannel) {
                this.a = fileLock;
                this.b = fileChannel;
            }

            /* synthetic */ a(com.tracelytics.logging.Logger$b b2, FileLock fileLock, FileChannel fileChannel, byte by) {
                this(b2, fileLock, fileChannel);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        abstract class b
        implements Callable<Boolean> {
            private /* synthetic */ com.tracelytics.logging.Logger$b a;

            private b(com.tracelytics.logging.Logger$b b2) {
                this.a = b2;
            }

            private Boolean b() {
                try {
                    this.a.b();
                }
                catch (Throwable throwable) {
                    Logger.b.warn("Failed to check the log file for size limit : " + throwable.getMessage(), throwable);
                }
                this.a();
                return Boolean.TRUE;
            }

            protected abstract void a();

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.b();
            }

            /* synthetic */ b(com.tracelytics.logging.Logger$b b2, byte by) {
                this(b2);
            }
        }
    }

    static final class d
    implements c {
        static final d a = new d();

        private d() {
        }

        public final void a(String string) {
            System.err.println(string);
        }

        public final void a(Throwable throwable) {
            throwable.printStackTrace(System.err);
        }

        /* synthetic */ d(byte by) {
            this();
        }
    }

    static final class e
    implements c {
        static final e a = new e();

        private e() {
        }

        public final void a(String string) {
            System.out.println(string);
        }

        public final void a(Throwable throwable) {
            throwable.printStackTrace(System.out);
        }

        /* synthetic */ e(byte by) {
            this();
        }
    }

    final class a
    implements c {
        private final c[] a;

        private a(Logger logger, c ... cArray) {
            this.a = cArray;
        }

        public final void a(String string) {
            c[] cArray = this.a;
            int n2 = this.a.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                c c2 = cArray[i2];
                c2.a(string);
            }
        }

        public final void a(Throwable throwable) {
            c[] cArray = this.a;
            int n2 = this.a.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                c c2 = cArray[i2];
                c2.a(throwable);
            }
        }

        /* synthetic */ a(Logger logger, c[] cArray, byte by) {
            this(logger, cArray);
        }
    }

    static interface c {
        public void a(String var1);

        public void a(Throwable var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        OFF("off"),
        FATAL("fatal"),
        ERROR("error"),
        WARNING("warn"),
        INFO("info"),
        DEBUG("debug"),
        TRACE("trace");

        private static final Map<String, Level> a;
        private String b;

        private Level(String string2) {
            this.b = string2;
        }

        public static Level fromLabel(String string) {
            return a.get(string);
        }

        public final String getLabel() {
            return this.b;
        }

        public static Set<String> getAllLabels() {
            return Collections.unmodifiableSet(a.keySet());
        }

        static {
            a = new HashMap<String, Level>();
            for (Level level : Level.values()) {
                a.put(level.b, level);
            }
        }
    }
}

