/*
 * Decompiled with CFR 0.152.
 */
package com.tracelytics.joboe.settings;

import com.tracelytics.joboe.rpc.ClientException;
import com.tracelytics.joboe.rpc.RpcClientManager;
import com.tracelytics.joboe.settings.PollingSettingsFetcher;
import com.tracelytics.joboe.settings.RpcSettingsReader;
import com.tracelytics.joboe.settings.Settings;
import com.tracelytics.joboe.settings.SettingsArg;
import com.tracelytics.joboe.settings.SettingsArgChangeListener;
import com.tracelytics.joboe.settings.SettingsFetcher;
import com.tracelytics.joboe.settings.a;
import com.tracelytics.logging.Logger;
import com.tracelytics.logging.LoggerFactory;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SettingsManager {
    private static SettingsFetcher a;
    private static Map<SettingsArg<?>, Set<SettingsArgChangeListener<?>>> b;
    private static Logger c;

    public static CountDownLatch initialize() throws ClientException {
        RpcSettingsReader rpcSettingsReader = new RpcSettingsReader(RpcClientManager.getClient(RpcClientManager.OperationType.SETTINGS));
        a = new PollingSettingsFetcher(rpcSettingsReader);
        SettingsManager.initializeFetcher(a);
        return a.isSettingsAvailableLatch();
    }

    public static void initializeFetcher(SettingsFetcher settingsFetcher) {
        a = settingsFetcher;
        settingsFetcher.registerListener(new a(){

            public final void a(Settings settings) {
                for (Map.Entry entry : b.entrySet()) {
                    SettingsArg settingsArg = (SettingsArg)entry.getKey();
                    settingsArg = settings != null ? settings.getArgValue(settingsArg) : null;
                    for (SettingsArgChangeListener settingsArgChangeListener : (Set)entry.getValue()) {
                        settingsArgChangeListener.onValue(settingsArg);
                    }
                }
            }
        });
    }

    public static void registerListener(SettingsArgChangeListener<?> settingsArgChangeListener) {
        Set<SettingsArgChangeListener<?>> set = b.get(settingsArgChangeListener.getType());
        if (set == null) {
            set = new HashSet();
            b.put(settingsArgChangeListener.getType(), set);
        }
        set.add(settingsArgChangeListener);
        set = SettingsManager.getSettings();
        if (set != null) {
            set = ((Settings)((Object)set)).getArgValue(settingsArgChangeListener.getType());
            settingsArgChangeListener.onValue(set);
        }
    }

    public static void removeListener(SettingsArgChangeListener<?> settingsArgChangeListener) {
        Set<SettingsArgChangeListener<?>> set = b.get(settingsArgChangeListener.getType());
        if (set != null) {
            set.remove(settingsArgChangeListener);
        }
    }

    public static Settings getSettings() {
        return SettingsManager.getSettings(0L, null);
    }

    public static Settings getSettings(long l2, TimeUnit timeUnit) {
        if (a != null) {
            if (l2 > 0L) {
                try {
                    if (!a.isSettingsAvailableLatch().await(l2, timeUnit)) {
                        c.warn("Settings are not avaialable after waiting for " + l2 + " " + (Object)((Object)timeUnit));
                        return null;
                    }
                }
                catch (InterruptedException interruptedException) {
                    c.warn("Settings are not avaialable as latch await is interrupted");
                    return null;
                }
            }
            return a.getSettings();
        }
        c.debug("Settings are not yet available as initialization has not been completed yet");
        return null;
    }

    public static SettingsFetcher getFetcher() {
        return a;
    }

    static {
        b = new ConcurrentHashMap();
        c = LoggerFactory.getLogger();
    }
}

