/*
 * Decompiled with CFR 0.152.
 */
package com.tracelytics.joboe.config;

import com.tracelytics.joboe.config.ConfigContainer;
import com.tracelytics.joboe.config.ConfigProperty;
import com.tracelytics.joboe.config.ConfigReader;
import com.tracelytics.joboe.config.ConfigSourceType;
import com.tracelytics.joboe.config.InvalidConfigException;
import com.tracelytics.util.ServiceKeyUtils;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvConfigReader
extends ConfigReader {
    private Map<String, String> b;

    public EnvConfigReader(Map<String, String> map) {
        super(ConfigSourceType.ENV_VAR);
        this.b = map;
    }

    @Override
    public void read(ConfigContainer configContainer) throws InvalidConfigException {
        ArrayList<InvalidConfigException> arrayList = new ArrayList<InvalidConfigException>();
        for (Map.Entry<String, ConfigProperty> entry : ConfigProperty.getEnviromentVariableMap().entrySet()) {
            String string = entry.getKey();
            if (!this.b.containsKey(string)) continue;
            String string2 = this.b.get(string);
            try {
                configContainer.putByStringValue(entry.getValue(), string2);
                String string3 = entry.getValue() == ConfigProperty.AGENT_SERVICE_KEY ? ServiceKeyUtils.maskServiceKey(string2) : string2;
                this.a.info("System environment variable [" + string + "] value [" + string3 + "] maps to agent property " + (Object)((Object)entry.getValue()));
            }
            catch (InvalidConfigException invalidConfigException) {
                this.a.warn("Invalid System environment variable [" + string + "] value [" + string2 + "]");
                arrayList.add(invalidConfigException);
            }
        }
        if (!arrayList.isEmpty()) {
            this.a.warn("Found " + arrayList.size() + " exception(s) while reading config from environment variables");
            throw (InvalidConfigException)arrayList.get(0);
        }
    }
}

