/*
 * Decompiled with CFR 0.152.
 */
package com.tracelytics.joboe;

import com.tracelytics.joboe.Event;
import com.tracelytics.joboe.EventReporter;
import com.tracelytics.joboe.EventReporterQueueFullException;
import com.tracelytics.joboe.EventReporterStats;
import com.tracelytics.joboe.config.ConfigManager;
import com.tracelytics.joboe.config.ConfigProperty;
import com.tracelytics.joboe.rpc.Result;
import com.tracelytics.joboe.rpc.ResultCode;
import com.tracelytics.joboe.settings.SettingsArg;
import com.tracelytics.joboe.settings.SettingsArgChangeListener;
import com.tracelytics.joboe.settings.SettingsManager;
import com.tracelytics.logging.Logger;
import com.tracelytics.logging.LoggerFactory;
import com.tracelytics.util.DaemonThreadFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QueuingEventReporter
implements EventReporter {
    private BlockingQueue<Event> d = new LinkedBlockingQueue<Event>(10000);
    protected ExecutorService a = Executors.newSingleThreadExecutor(DaemonThreadFactory.newInstance("queuing-event-reporter"));
    protected static Logger b = LoggerFactory.getLogger();
    private a e = new a(this);
    static int c = 2;
    private boolean f = false;
    private long g = 0L;
    private final b h = new b(this, 0);

    static void a(int n2) {
        if (n2 >= 0) {
            c = n2;
            b.debug("Event flush interval set to " + n2 + "s");
            return;
        }
        b.warn("Event flush interval value " + n2 + " is not valid");
    }

    protected QueuingEventReporter() {
        this.a.execute(this.h);
    }

    @Override
    public void send(Event event) throws com.tracelytics.joboe.a {
        if (!this.d.offer(event)) {
            long l2;
            com.tracelytics.joboe.QueuingEventReporter$a.d(this.e, 1L);
            com.tracelytics.joboe.QueuingEventReporter$a.c(this.e, 1L);
            if (!this.f && (l2 = System.currentTimeMillis()) - this.g >= 60000L) {
                b.warn("Fail to report tracing event as the event queue is full in the reporter");
                this.f = true;
                this.g = l2;
            }
            throw new EventReporterQueueFullException("Cannot send event as the reporter queue is full");
        }
        com.tracelytics.joboe.QueuingEventReporter$a.e(this.e, this.d.size());
        if (this.d.size() >= 1000) {
            this.h.a();
        }
        this.f = false;
    }

    @Override
    public EventReporterStats consumeStats() {
        return com.tracelytics.joboe.QueuingEventReporter$a.a(this.e);
    }

    @Override
    public void close() {
        b.debug("Closing queueing event reporter, signaling shut down after sending all events");
        com.tracelytics.joboe.QueuingEventReporter$b.a(this.h, true);
        this.a.shutdown();
        try {
            this.a.awaitTermination(5L, TimeUnit.SECONDS);
            b.debug("Event reporter service shut down");
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public abstract Result synchronousSend(List<Event> var1) throws Exception;

    static {
        if (ConfigManager.getConfig(ConfigProperty.AGENT_EVENTS_FLUSH_INTERVAL) instanceof Integer) {
            QueuingEventReporter.a((Integer)ConfigManager.getConfig(ConfigProperty.AGENT_EVENTS_FLUSH_INTERVAL));
        }
        SettingsManager.registerListener(new SettingsArgChangeListener<Integer>(SettingsArg.EVENTS_FLUSH_INTERVAL){

            @Override
            public final /* synthetic */ void a(Object object) {
                if ((object = (Integer)object) != null) {
                    QueuingEventReporter.a((Integer)object);
                    return;
                }
                QueuingEventReporter.a(2);
            }
        });
    }

    final class a {
        private final AtomicLong a = new AtomicLong();
        private final AtomicLong b = new AtomicLong();
        private final AtomicLong c = new AtomicLong();
        private final AtomicLong d = new AtomicLong();
        private final AtomicLong e = new AtomicLong();
        private /* synthetic */ QueuingEventReporter f;

        public a(QueuingEventReporter queuingEventReporter) {
            this.f = queuingEventReporter;
        }

        static /* synthetic */ void a(a a2, long l2) {
            long l3 = l2;
            a2.c.addAndGet(l3);
        }

        static /* synthetic */ void b(a a2, long l2) {
            long l3 = l2;
            a2.a.addAndGet(l3);
        }

        static /* synthetic */ void c(a a2, long l2) {
            long l3 = l2;
            a2.e.addAndGet(l3);
        }

        static /* synthetic */ void d(a a2, long l2) {
            long l3 = 1L;
            a2.b.addAndGet(l3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static /* synthetic */ void e(a a2, long l2) {
            long l3 = l2;
            AtomicLong atomicLong = a2.d;
            synchronized (atomicLong) {
                if (l3 > a2.d.get()) {
                    a2.d.set(l3);
                }
                return;
            }
        }

        static /* synthetic */ EventReporterStats a(a a2) {
            long l2 = a2.a.getAndSet(0L);
            long l3 = a2.b.getAndSet(0L);
            long l4 = a2.c.getAndSet(0L);
            long l5 = a2.d.getAndSet(a2.f.d.size());
            long l6 = a2.e.getAndSet(0L);
            return new EventReporterStats(l2, l3, l4, l6, l5);
        }
    }

    final class b
    implements Runnable {
        private boolean a = false;
        private CountDownLatch b = new CountDownLatch(1);
        private ScheduledExecutorService c = Executors.newScheduledThreadPool(1, DaemonThreadFactory.newInstance("send-event-delay"));
        private /* synthetic */ QueuingEventReporter d;

        private b(QueuingEventReporter queuingEventReporter) {
            this.d = queuingEventReporter;
        }

        public final void run() {
            while (!this.a || !this.d.d.isEmpty()) {
                ArrayList<Event> arrayList = new ArrayList<Event>();
                try {
                    Object object;
                    arrayList.add((Event)this.d.d.take());
                    this.d.d.drainTo(arrayList, 1000 - arrayList.size());
                    if (arrayList.size() < 1000) {
                        try {
                            object = this;
                            this.b = new CountDownLatch(1);
                            ((b)object).c.schedule(new Runnable((b)object){
                                private /* synthetic */ b a;
                                {
                                    this.a = b2;
                                }

                                public final void run() {
                                    this.a.b.countDown();
                                }
                            }, (long)c, TimeUnit.SECONDS);
                            ((b)object).b.await();
                        }
                        catch (InterruptedException interruptedException) {
                            b.debug("Queuing event wait interrupted");
                        }
                        this.d.d.drainTo(arrayList, 1000 - arrayList.size());
                    }
                    object = this.d.synchronousSend(arrayList);
                    if (((ResultCode)((Object)(object = ((Result)object).getResultCode()))).isError()) {
                        b.debug("Failed to send out " + arrayList.size() + " events");
                        com.tracelytics.joboe.QueuingEventReporter$a.a(this.d.e, arrayList.size());
                        continue;
                    }
                    com.tracelytics.joboe.QueuingEventReporter$a.b(this.d.e, arrayList.size());
                }
                catch (Exception exception) {
                    b.debug("Failed to send " + arrayList.size() + " events, exception found: " + exception.getMessage());
                    com.tracelytics.joboe.QueuingEventReporter$a.a(this.d.e, arrayList.size());
                }
                finally {
                    com.tracelytics.joboe.QueuingEventReporter$a.c(this.d.e, arrayList.size());
                }
            }
            this.c.shutdownNow();
        }

        protected final void a() {
            if (this.b != null && this.b.getCount() > 0L) {
                b.debug("SendNow signaled for event reporter");
                this.b.countDown();
            }
        }

        /* synthetic */ b(QueuingEventReporter queuingEventReporter, byte by) {
            this(queuingEventReporter);
        }

        static /* synthetic */ boolean a(b b2, boolean bl) {
            b2.a = true;
            return true;
        }
    }
}

