/*
 * Decompiled with CFR 0.152.
 */
package com.tracelytics.instrumentation.http.ws;

import com.tracelytics.instrumentation.ClassInstrumentation;
import com.tracelytics.instrumentation.Module;
import com.tracelytics.instrumentation.TvContextObjectAware;
import com.tracelytics.instrumentation.config.HideParamsConfig;
import com.tracelytics.joboe.Context;
import com.tracelytics.joboe.Event;
import com.tracelytics.joboe.Metadata;
import com.tracelytics.joboe.config.ConfigManager;
import com.tracelytics.joboe.config.ConfigProperty;
import com.tracelytics.util.HttpUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseWsClientInstrumentation
extends ClassInstrumentation {
    protected static boolean f = ConfigManager.getConfig(ConfigProperty.AGENT_HIDE_PARAMS) != null ? ((HideParamsConfig)ConfigManager.getConfig(ConfigProperty.AGENT_HIDE_PARAMS)).shouldHideParams(Module.WEB_SERVICE) : false;

    public static Metadata layerEntrySoap(String string, String string2, String string3) {
        return BaseWsClientInstrumentation.layerEntrySoap(string, string2, string3, false);
    }

    public static Metadata layerEntrySoap(String object, String string, String string2, boolean bl) {
        if (Context.getMetadata().isSampled()) {
            Metadata metadata = null;
            if (bl) {
                metadata = Context.getMetadata();
                Context.setMetadata(new Metadata(metadata));
            }
            Event event = Context.createEvent();
            event.addInfo("Layer", string2, "Label", "entry");
            if (object != null) {
                event.addInfo("SoapAction", object);
            }
            if (string != null) {
                event.addInfo("RemoteURL", (Object)(f ? HttpUtils.trimQueryParameters(string) : string));
            }
            event.addInfo("RemoteController", "SOAP", "IsService", Boolean.TRUE, "Spec", "rsc");
            event.report();
            object = event.getMetadata();
            if (bl && metadata != null) {
                Context.setMetadata(metadata);
            }
            return object;
        }
        if (Context.getMetadata().isValid()) {
            return Context.getMetadata();
        }
        return null;
    }

    public static void layerExitSoap(String string) {
        BaseWsClientInstrumentation.layerExitSoap(string, null);
    }

    public static void layerExitSoap(String string, List<String> list) {
        BaseWsClientInstrumentation.layerExitSoap(string, list != null && !list.isEmpty() ? list.get(0) : null);
    }

    public static void layerExitSoap(String string, List<String> list, boolean bl) {
        BaseWsClientInstrumentation.layerExitSoap(string, list != null && !list.isEmpty() ? list.get(0) : null, bl);
    }

    public static void layerExitSoap(String string, String string2) {
        BaseWsClientInstrumentation.layerExitSoap(string, string2, false);
    }

    public static void layerExitSoap(String string, String string2, boolean bl) {
        Event event = Context.createEvent();
        event.addInfo("Layer", string, "Label", "exit");
        if (string2 != null) {
            event.addEdge(string2);
        }
        if (bl) {
            event.setAsync();
        }
        event.report();
    }

    public static Metadata layerEntryRest(String string, String string2, String string3) {
        return BaseWsClientInstrumentation.layerEntryRest(string, string2, string3, false);
    }

    public static Metadata layerEntryRest(String object, String string, String string2, boolean bl) {
        if (Context.getMetadata().isSampled()) {
            Metadata metadata = null;
            if (bl) {
                metadata = Context.getMetadata();
                Context.setMetadata(new Metadata(metadata));
            }
            Event event = Context.createEvent();
            event.addInfo("Layer", string2, "Label", "entry");
            if (object != null) {
                event.addInfo("HTTPMethod", object);
            }
            if (string != null) {
                event.addInfo("RemoteURL", (Object)(f ? HttpUtils.trimQueryParameters(string) : string));
                event.addInfo("RemoteController", "REST", "Spec", "rsc", "IsService", Boolean.TRUE);
            }
            event.report();
            object = event.getMetadata();
            if (bl && metadata != null) {
                Context.setMetadata(metadata);
            }
            return object;
        }
        if (Context.getMetadata().isValid()) {
            return Context.getMetadata();
        }
        return null;
    }

    public static void layerExitRest(String string) {
        BaseWsClientInstrumentation.layerExitRest(string, null);
    }

    public static void layerExitRest(String string, List<String> list) {
        BaseWsClientInstrumentation.layerExitRest(string, list != null && !list.isEmpty() ? list.get(0) : null);
    }

    public static void layerExitRest(String string, String string2) {
        BaseWsClientInstrumentation.layerExitRest(string, string2, false);
    }

    public static void layerExitRest(String string, String string2, boolean bl) {
        if (Context.getMetadata().isSampled()) {
            Event event = Context.createEvent();
            event.addInfo("Layer", string, "Label", "exit");
            if (string2 != null) {
                event.addEdge(string2);
            }
            if (bl) {
                event.setAsync();
            }
            event.report();
        }
    }

    public static void storeContext(Object object, Metadata metadata) {
        if (object == null) {
            a.warn("Attempted to store context on the Soap/rest asynchronous call back but it is null. Unexpected");
            return;
        }
        if (!(object instanceof TvContextObjectAware)) {
            a.warn("Attempted to store context on the Soap/rest asynchronous call back but it is not instance of " + TvContextObjectAware.class.getName() + ". Unexpected");
            return;
        }
        if (metadata != null) {
            ((TvContextObjectAware)object).setTvContext(metadata);
        }
    }
}

