/*
 * Decompiled with CFR 0.152.
 */
package com.tracelytics.instrumentation.http.netty;

import com.tracelytics.a.f.g;
import com.tracelytics.a.f.t;
import com.tracelytics.instrumentation.ClassInstrumentation;
import com.tracelytics.instrumentation.Module;
import com.tracelytics.instrumentation.config.HideParamsConfig;
import com.tracelytics.instrumentation.http.ServletInstrumentation;
import com.tracelytics.instrumentation.http.netty.NettyChannel;
import com.tracelytics.instrumentation.http.netty.NettyHttpMessage;
import com.tracelytics.instrumentation.http.netty.NettyHttpRequest;
import com.tracelytics.instrumentation.http.netty.NettyHttpResponse;
import com.tracelytics.joboe.Context;
import com.tracelytics.joboe.XTraceHeader;
import com.tracelytics.joboe.XTraceOptionsResponse;
import com.tracelytics.joboe.config.ConfigManager;
import com.tracelytics.joboe.config.ConfigProperty;
import com.tracelytics.joboe.span.impl.ScopeManager;
import com.tracelytics.joboe.span.impl.Span;
import com.tracelytics.joboe.span.impl.SpanDictionary;
import com.tracelytics.util.HttpUtils;
import java.util.HashMap;
import java.util.Map;

public abstract class NettyBaseInstrumentation
extends ClassInstrumentation {
    private static String f = "netty";
    private static boolean g = ConfigManager.getConfig(ConfigProperty.AGENT_HIDE_PARAMS) != null ? ((HideParamsConfig)ConfigManager.getConfig(ConfigProperty.AGENT_HIDE_PARAMS)).shouldHideParams(Module.NETTY) : false;

    public static void endTrace(Object object, Object object2, boolean bl) {
        NettyBaseInstrumentation.endTrace(object, object2, bl, null);
    }

    /*
     * WARNING - void declaration
     */
    public static void endTrace(Object object, Object object2, boolean bl, Integer n2) {
        void var2_5;
        Integer n3;
        if (!(object instanceof NettyChannel)) {
            a.warn("Cannot find the context from the Netty Context, cannot create the end trace event.");
            return;
        }
        if (NettyBaseInstrumentation.a((NettyHttpMessage)(object2 = (NettyHttpResponse)object2))) {
            return;
        }
        object = (NettyChannel)object;
        if (bl) {
            Map<Integer, Span> object32 = object.tvGetAndRemoveAllSpans();
        } else {
            Object object3;
            HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
            if (NettyBaseInstrumentation.a((NettyHttpResponse)object2)) {
                n3 = 1;
                object3 = object.tvGetAndRemoveSpan(null);
            } else {
                object3 = object.tvGetAndRemoveSpan(n3);
            }
            if (object3 != null) {
                hashMap.put(n3, object3);
            } else {
                return;
            }
        }
        for (Map.Entry entry : var2_5.entrySet()) {
            Object object4 = (Integer)entry.getKey();
            Span span = (Span)entry.getValue();
            if (NettyBaseInstrumentation.a((NettyHttpResponse)object2)) {
                object4 = new HashMap<String, Boolean>();
                object4.put("HTTP2Upgrade", Boolean.TRUE);
                object4.put("HTTP2UpgradeStatus", object2.tvGetStatusCode());
                span.log((Map)object4);
                object.tvSetSpan(n3, span);
                continue;
            }
            if (object2 != null && object2.tvGetStatusCode() != null) {
                span.setTag("Status", object2.tvGetStatusCode());
            }
            if (object4 != null) {
                span.setTag("ResponseStreamId", (Number)object4);
            }
            span.finish();
            if (span.getSpanPropertyValue(Span.SpanProperty.EXIT_XID) != null && object2 != null) {
                object2.tvSetHeader("X-Trace".toLowerCase(), span.getSpanPropertyValue(Span.SpanProperty.EXIT_XID));
            }
            if (object2 != null && (object4 = XTraceOptionsResponse.computeResponse(span)) != null) {
                object2.tvSetHeader("X-Trace-Options-Response", ((XTraceOptionsResponse)object4).toString());
            }
            SpanDictionary.removeSpan(span);
            Context.clearMetadata();
        }
    }

    private static boolean a(NettyHttpResponse object) {
        if (object == null || object.tvGetStatusCode() != 101) {
            return false;
        }
        return "h2c".equals(object = object.tvGetHeader("upgrade")) || "h2".equals(object);
    }

    public static void startTrace(Object object, Object object2) {
        NettyBaseInstrumentation.startTrace(object, object2, null);
    }

    public static void startTrace(Object object, Object object2, Integer n2) {
        Object object3;
        if (NettyBaseInstrumentation.a((NettyHttpMessage)(object2 = (NettyHttpRequest)object2))) {
            return;
        }
        if (n2 == null && (object3 = object2).tvGetHeader("x-http2-stream-id") != null) {
            return;
        }
        ScopeManager.INSTANCE.removeAllScopes();
        if (object instanceof NettyChannel) {
            if ((object = (NettyChannel)object).tvGetSpan(n2) != null) {
                return;
            }
            object3 = object2;
            HashMap<XTraceHeader, String> hashMap = new HashMap<XTraceHeader, String>();
            for (Map.Entry entry : ServletInstrumentation.XTRACE_HTTP_HEADER_KEYS.entrySet()) {
                String string = object3.tvGetHeader((String)entry.getKey());
                if (string == null) continue;
                hashMap.put((XTraceHeader)((Object)entry.getValue()), string);
            }
            object3 = NettyBaseInstrumentation.startTraceAsSpan(f, hashMap, object2.getUri(), false);
            ((Span)object3).setTag("Spec", "ws");
            ClassInstrumentation.setForwardedTags((Span)object3, new ClassInstrumentation.HeaderExtractor<String, String>((NettyHttpRequest)object2){
                private /* synthetic */ NettyHttpRequest a;
                {
                    this.a = nettyHttpRequest;
                }

                @Override
                public final /* synthetic */ Object extract(Object object) {
                    String string = (String)object;
                    object = this;
                    return object.a.tvGetHeader(string);
                }
            });
            if (object2.getUri() != null) {
                ((Span)object3).setTag("URL", g ? HttpUtils.trimQueryParameters(object2.getUri()) : object2.getUri());
            }
            if (object2.getTvMethod() != null) {
                ((Span)object3).setTag("HTTPMethod", object2.getTvMethod());
            }
            if (n2 != null) {
                ((Span)object3).setTag("RequestStreamId", n2);
            }
            if (object.getRemoteAddress() != null) {
                ((Span)object3).setTag("Remote-Host", object.getRemoteAddress().toString());
            }
            if (object.getLocalAddress() != null) {
                ((Span)object3).setTag("HTTP-Host", object.getLocalAddress().toString());
            }
            object.tvSetSpan(n2, (Span)object3);
            long l2 = SpanDictionary.setSpan((Span)object3);
            object2.tvSetHeader("x-tv-span", String.valueOf(l2));
            object2.tvSetHeader("X-Trace", ((Span)object3).context().getMetadata().toHexString());
            Context.clearMetadata();
        }
    }

    private static boolean a(NettyHttpMessage nettyHttpMessage) {
        return nettyHttpMessage != null && "application/grpc".equals(nettyHttpMessage.tvGetHeader("content-type"));
    }

    public static void reportException(Object object, Throwable throwable) {
        if (!(object instanceof NettyChannel)) {
            a.warn("Cannot find the context from the Netty Context, cannot create error event.");
            return;
        }
        if (throwable == null) {
            a.debug("Not reporting error event for netty when execption object is null");
            return;
        }
        Span span = (object = (NettyChannel)object).tvGetSpan(null);
        if (span == null) {
            return;
        }
        if (!object.tvHasExceptionReported(throwable)) {
            NettyBaseInstrumentation.reportError(span, throwable);
            object.tvAddExceptionReported(throwable);
        }
    }

    protected static boolean c(g g2) {
        try {
            g2.a("headers", "()Lorg/jboss/netty/handler/codec/http/HttpHeaders;");
            return true;
        }
        catch (t t2) {
            return false;
        }
    }
}

