/*
 * Decompiled with CFR 0.152.
 */
package com.tracelytics.agent.config;

import com.tracelytics.a.h.b;
import com.tracelytics.a.h.c;
import com.tracelytics.agent.ResourceDirectory;
import com.tracelytics.agent.config.ModeStringToBooleanParser;
import com.tracelytics.joboe.config.ConfigParser;
import com.tracelytics.joboe.config.ConfigProperty;
import com.tracelytics.joboe.config.InvalidConfigException;
import com.tracelytics.logging.Logger;
import com.tracelytics.logging.LoggerFactory;
import com.tracelytics.logging.setting.LogSetting;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogSettingParser
implements ConfigParser<String, LogSetting> {
    private static final Logger a = LoggerFactory.getLogger();
    public static final String LEVEL_KEY = "level";
    public static final String STDOUT_KEY = "stdout";
    public static final String STDERR_KEY = "stderr";
    public static final String FILE_KEY = "file";
    public static final String FILE_LOCATION_KEY = "location";
    public static final String FILE_MAX_SIZE_KEY = "maxSize";
    public static final String FILE_MAX_BACKUP_KEY = "maxBackup";
    private static final List<String> b = Arrays.asList("level", "stderr", "stdout", "file");
    private static final List<String> c = Arrays.asList("location", "maxSize", "maxBackup");
    public static final LogSettingParser INSTANCE = new LogSettingParser();
    public static final int MAX_BACKUP_MIN = 1;
    public static final int MAX_BACKUP_MAX = 100;
    public static final int MAX_SIZE_MIN = 1;
    public static final int MAX_SIZE_MAX = 1024;

    private LogSettingParser() {
    }

    @Override
    public LogSetting convert(String string) throws InvalidConfigException {
        Object object = string.trim();
        if (string.startsWith("{")) {
            return this.a((String)object);
        }
        string = object;
        if ((object = Logger.Level.fromLabel(string)) == null) {
            a.warn("Agent logging level value [" + string + "] is invalid. Using default logging level instead...");
        }
        return new LogSetting((Logger.Level)((Object)object), true, true, null, null, null);
    }

    private LogSetting a(String string) throws InvalidConfigException {
        try {
            Path path;
            Integer n2;
            Integer n3;
            String string2;
            boolean bl;
            boolean bl2;
            Logger.Level level;
            block13: {
                Object object = new c(string);
                LogSettingParser.a((c)object, b);
                level = Logger.Level.fromLabel(((c)object).c(LEVEL_KEY));
                if (level == null) {
                    throw new InvalidConfigException("Agent logging level value [" + string + "] defined in " + LogSettingParser.b(LEVEL_KEY) + " is invalid");
                }
                bl2 = this.a((c)object, STDOUT_KEY, true);
                bl = this.a((c)object, STDERR_KEY, true);
                object = ((c)object).e(FILE_KEY);
                string2 = null;
                n3 = null;
                n2 = null;
                path = null;
                if (object != null) {
                    if (object instanceof c) {
                        object = (c)object;
                        LogSettingParser.a((c)object, c);
                        string2 = ((c)object).c(FILE_LOCATION_KEY);
                        try {
                            path = Paths.get(string2, new String[0]);
                            if (!path.isAbsolute() && ResourceDirectory.getAgentDirectory() != null) {
                                path = Paths.get(ResourceDirectory.getAgentDirectory(), path.toString());
                            }
                            n3 = ((c)object).d(FILE_MAX_SIZE_KEY) ? Integer.valueOf(((c)object).b(FILE_MAX_SIZE_KEY)) : null;
                            Integer n4 = n2 = ((c)object).d(FILE_MAX_BACKUP_KEY) ? Integer.valueOf(((c)object).b(FILE_MAX_BACKUP_KEY)) : null;
                            if (n3 != null && (n3 <= 0 || n3 > 1024)) {
                                throw new InvalidConfigException("Invalid value [" + n3 + "] for " + LogSettingParser.b(FILE_MAX_SIZE_KEY) + ". The value should be in range of [1" + " , 1024" + "]");
                            }
                            if (n2 != null && (n2 <= 0 || n2 > 100)) {
                                throw new InvalidConfigException("Invalid value [" + n2 + "] for " + LogSettingParser.b(FILE_MAX_BACKUP_KEY) + ". The value should be in range of [1" + " , 100" + "]");
                            }
                            break block13;
                        }
                        catch (InvalidPathException invalidPathException) {
                            throw new InvalidConfigException("Log file path [" + string2 + "] is invalid : " + invalidPathException.getMessage(), invalidPathException);
                        }
                    }
                    throw new InvalidConfigException("Expect json value for key [file] but found value [" + object + "]");
                }
            }
            if (string2 == null) {
                if (!bl) {
                    throw new InvalidConfigException("Cannot disable stderr on logging while no log file is defined in [" + ConfigProperty.AGENT_LOGGING.getConfigFileKey() + "]");
                }
                if (!bl2) {
                    throw new InvalidConfigException("Cannot disable stdout on logging while no log file is defined in [" + ConfigProperty.AGENT_LOGGING.getConfigFileKey() + "]");
                }
            }
            return new LogSetting(level, bl2, bl, path, n3, n2);
        }
        catch (b b2) {
            throw new InvalidConfigException("Failed parsing log settings from config file: " + b2.getMessage(), b2);
        }
    }

    private static void a(c object, List<String> list) throws InvalidConfigException {
        object = new ArrayList(((c)object).b());
        object.removeAll(list);
        if (!object.isEmpty()) {
            throw new InvalidConfigException("Found unknown key(s) [" + String.join((CharSequence)", ", (Iterable<? extends CharSequence>)object) + "], valid keys are [" + String.join((CharSequence)", ", list) + "]");
        }
    }

    private boolean a(c object, String string, boolean bl) throws InvalidConfigException {
        try {
            object = ((c)object).a(string, null);
            if (object == null) {
                return true;
            }
            return ModeStringToBooleanParser.INSTANCE.convert((String)object);
        }
        catch (InvalidConfigException invalidConfigException) {
            throw new InvalidConfigException("Failed to parse " + LogSettingParser.b(string) + " : " + invalidConfigException.getMessage(), invalidConfigException);
        }
    }

    private static String b(String string) {
        return "[" + string + "] of [" + ConfigProperty.AGENT_LOGGING.getConfigFileKey() + "]";
    }
}

