/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.instrumentation.nosql.mongo3;

import com.appoptics.instrumentation.nosql.mongo3.Mongo3BaseInstrumentation;
import com.appoptics.instrumentation.nosql.mongo3.Mongo3Callback;
import com.tracelytics.a.f.g;
import com.tracelytics.instrumentation.Instrument;
import com.tracelytics.instrumentation.MethodMatcher;
import com.tracelytics.instrumentation.Module;
import com.tracelytics.joboe.span.impl.ScopeManager;
import com.tracelytics.joboe.span.impl.Span;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@Instrument(targetType={"com.mongodb.connection.Connection", "com.mongodb.connection.AsyncConnection"}, module=Module.MONGODB)
public class Mongo3ConnectionInstrumentation
extends Mongo3BaseInstrumentation {
    private static final String f = Mongo3ConnectionInstrumentation.class.getName();
    private static List<MethodMatcher<MethodType>> g = Arrays.asList(new MethodMatcher<MethodType>("command", new String[0], "java.lang.Object", MethodType.COMMAND), new MethodMatcher<MethodType>("query", new String[0], "com.mongodb.connection.QueryResult", MethodType.QUERY), new MethodMatcher<MethodType>("insert", new String[0], "com.mongodb.WriteConcernResult", MethodType.INSERT), new MethodMatcher<MethodType>("update", new String[0], "com.mongodb.WriteConcernResult", MethodType.UPDATE), new MethodMatcher<MethodType>("delete", new String[0], "com.mongodb.WriteConcernResult", MethodType.DELETE), new MethodMatcher<MethodType>("insertCommand", new String[0], "com.mongodb.bulk.BulkWriteResult", MethodType.INSERT_COMMAND), new MethodMatcher<MethodType>("updateCommand", new String[0], "com.mongodb.bulk.BulkWriteResult", MethodType.UPDATE_COMMAND), new MethodMatcher<MethodType>("deleteCommand", new String[0], "com.mongodb.bulk.BulkWriteResult", MethodType.DELETE_COMMAND));
    private static List<MethodMatcher<MethodType>> h = Arrays.asList(new MethodMatcher<MethodType>("commandAsync", new String[0], "void", MethodType.COMMAND), new MethodMatcher<MethodType>("queryAsync", new String[0], "void", MethodType.QUERY), new MethodMatcher<MethodType>("insertAsync", new String[0], "void", MethodType.INSERT), new MethodMatcher<MethodType>("updateAsync", new String[0], "void", MethodType.UPDATE), new MethodMatcher<MethodType>("deleteAsync", new String[0], "void", MethodType.DELETE), new MethodMatcher<MethodType>("insertCommandAsync", new String[0], "void", MethodType.INSERT_COMMAND), new MethodMatcher<MethodType>("updateCommandAsync", new String[0], "void", MethodType.UPDATE_COMMAND), new MethodMatcher<MethodType>("deleteCommandAsync", new String[0], "void", MethodType.DELETE_COMMAND));

    public boolean applyInstrumentation(g g2, String iterator, byte[] object2) throws Exception {
        for (Map.Entry entry : this.a(g2, g).entrySet()) {
            Mongo3ConnectionInstrumentation.insertBefore(entry.getKey(), f + ".reportRemoteHost(getDescription() != null ? getDescription().getServerAddress() : null);");
        }
        for (Map.Entry entry : this.a(g2, h).entrySet()) {
            int n2 = this.a(entry.getKey());
            if (n2 < 0) continue;
            String string = "$" + (n2 + 1);
            Mongo3ConnectionInstrumentation.insertBefore(entry.getKey(), f + ".setRemoteHostToCallback(getDescription() != null ? getDescription().getServerAddress() : null, " + string + ");", false);
        }
        return true;
    }

    public static void reportRemoteHost(Object object) {
        Span span;
        if (object != null && (span = ScopeManager.INSTANCE.activeSpan()) != null) {
            span.setTag("RemoteHost", object.toString());
        }
    }

    public static void setRemoteHostToCallback(Object object, Object object2) {
        if (object != null && object2 instanceof Mongo3Callback) {
            ((Mongo3Callback)object2).tvSetRemoteHost(object.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum MethodType {
        COMMAND,
        QUERY,
        INSERT,
        UPDATE,
        DELETE,
        INSERT_COMMAND,
        UPDATE_COMMAND,
        DELETE_COMMAND;

    }
}

