/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.util.internal.shaded.org.jctools.queues.atomic;

import com.appoptics.ext.io.netty.util.internal.shaded.org.jctools.queues.IndexedQueueSizeUtil;
import com.appoptics.ext.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import com.appoptics.ext.io.netty.util.internal.shaded.org.jctools.queues.atomic.AtomicQueueUtil;
import com.appoptics.ext.io.netty.util.internal.shaded.org.jctools.util.Pow2;
import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReferenceArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AtomicReferenceArrayQueue<E>
extends AbstractQueue<E>
implements IndexedQueueSizeUtil.IndexedQueue,
MessagePassingQueue<E> {
    protected final AtomicReferenceArray<E> buffer;
    protected final int mask;

    public AtomicReferenceArrayQueue(int n2) {
        n2 = Pow2.roundToPowerOfTwo(n2);
        this.mask = n2 - 1;
        this.buffer = new AtomicReferenceArray(n2);
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public void clear() {
        while (this.poll() != null) {
        }
    }

    @Override
    public final int size() {
        return IndexedQueueSizeUtil.size(this);
    }

    @Override
    public final boolean isEmpty() {
        return IndexedQueueSizeUtil.isEmpty(this);
    }

    @Override
    public final Iterator<E> iterator() {
        long l2 = this.lvConsumerIndex();
        long l3 = this.lvProducerIndex();
        return new WeakIterator<E>(l2, l3, this.mask, this.buffer);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeakIterator<E>
    implements Iterator<E> {
        private final long pIndex;
        private final int mask;
        private final AtomicReferenceArray<E> buffer;
        private long nextIndex;
        private E nextElement;

        WeakIterator(long l2, long l3, int n2, AtomicReferenceArray<E> atomicReferenceArray) {
            this.nextIndex = l2;
            this.pIndex = l3;
            this.mask = n2;
            this.buffer = atomicReferenceArray;
            this.nextElement = this.getNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public boolean hasNext() {
            return this.nextElement != null;
        }

        @Override
        public E next() {
            E e2 = this.nextElement;
            if (e2 == null) {
                throw new NoSuchElementException();
            }
            this.nextElement = this.getNext();
            return e2;
        }

        private E getNext() {
            int n2 = this.mask;
            AtomicReferenceArray<E> atomicReferenceArray = this.buffer;
            while (this.nextIndex < this.pIndex) {
                int n3;
                E e2;
                if ((e2 = AtomicQueueUtil.lvRefElement(atomicReferenceArray, n3 = AtomicQueueUtil.calcCircularRefElementOffset(this.nextIndex++, n2))) == null) continue;
                return e2;
            }
            return null;
        }
    }
}

