/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.util.internal.logging;

import com.appoptics.ext.io.netty.util.internal.logging.FormattingTuple;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MessageFormatter {
    static FormattingTuple format(String string, Object object) {
        return MessageFormatter.arrayFormat(string, new Object[]{object});
    }

    static FormattingTuple format(String string, Object object, Object object2) {
        return MessageFormatter.arrayFormat(string, new Object[]{object, object2});
    }

    static FormattingTuple arrayFormat(String string, Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return new FormattingTuple(string, null);
        }
        int n2 = objectArray.length - 1;
        Object object = objectArray[n2];
        Object object2 = object = object instanceof Throwable ? (Throwable)object : null;
        if (string == null) {
            return new FormattingTuple(null, (Throwable)object);
        }
        int n3 = string.indexOf("{}");
        if (n3 == -1) {
            return new FormattingTuple(string, (Throwable)object);
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 50);
        int n4 = 0;
        int n5 = 0;
        do {
            boolean bl;
            if (bl = n3 == 0 || string.charAt(n3 - 1) != '\\') {
                stringBuilder.append(string, n4, n3);
            } else {
                stringBuilder.append(string, n4, n3 - 1);
                bl = n3 >= 2 && string.charAt(n3 - 2) == '\\';
            }
            n4 = n3 + 2;
            if (bl) {
                MessageFormatter.deeplyAppendParameter(stringBuilder, objectArray[n5], null);
                if (++n5 <= n2) continue;
                break;
            }
            stringBuilder.append("{}");
        } while ((n3 = string.indexOf("{}", n4)) != -1);
        stringBuilder.append(string, n4, string.length());
        return new FormattingTuple(stringBuilder.toString(), (Throwable)(n5 <= n2 ? object : null));
    }

    private static void deeplyAppendParameter(StringBuilder stringBuilder, Object object, Set<Object[]> set) {
        if (object == null) {
            stringBuilder.append("null");
            return;
        }
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            if (Number.class.isAssignableFrom(clazz)) {
                if (clazz == Long.class) {
                    stringBuilder.append((Long)object);
                    return;
                }
                if (clazz == Integer.class || clazz == Short.class || clazz == Byte.class) {
                    stringBuilder.append(((Number)object).intValue());
                    return;
                }
                if (clazz == Double.class) {
                    stringBuilder.append((Double)object);
                    return;
                }
                if (clazz == Float.class) {
                    stringBuilder.append(((Float)object).floatValue());
                    return;
                }
                MessageFormatter.safeObjectAppend(stringBuilder, object);
                return;
            }
            MessageFormatter.safeObjectAppend(stringBuilder, object);
            return;
        }
        stringBuilder.append('[');
        if (clazz == boolean[].class) {
            MessageFormatter.booleanArrayAppend(stringBuilder, (boolean[])object);
        } else if (clazz == byte[].class) {
            MessageFormatter.byteArrayAppend(stringBuilder, (byte[])object);
        } else if (clazz == char[].class) {
            MessageFormatter.charArrayAppend(stringBuilder, (char[])object);
        } else if (clazz == short[].class) {
            MessageFormatter.shortArrayAppend(stringBuilder, (short[])object);
        } else if (clazz == int[].class) {
            MessageFormatter.intArrayAppend(stringBuilder, (int[])object);
        } else if (clazz == long[].class) {
            MessageFormatter.longArrayAppend(stringBuilder, (long[])object);
        } else if (clazz == float[].class) {
            MessageFormatter.floatArrayAppend(stringBuilder, (float[])object);
        } else if (clazz == double[].class) {
            MessageFormatter.doubleArrayAppend(stringBuilder, (double[])object);
        } else {
            MessageFormatter.objectArrayAppend(stringBuilder, (Object[])object, set);
        }
        stringBuilder.append(']');
    }

    private static void safeObjectAppend(StringBuilder stringBuilder, Object object) {
        try {
            String string = object.toString();
            stringBuilder.append(string);
            return;
        }
        catch (Throwable throwable) {
            System.err.println("SLF4J: Failed toString() invocation on an object of type [" + object.getClass().getName() + ']');
            throwable.printStackTrace();
            stringBuilder.append("[FAILED toString()]");
            return;
        }
    }

    private static void objectArrayAppend(StringBuilder stringBuilder, Object[] objectArray, Set<Object[]> set) {
        if (objectArray.length == 0) {
            return;
        }
        if (set == null) {
            set = new HashSet<Object[]>(objectArray.length);
        }
        if (set.add(objectArray)) {
            MessageFormatter.deeplyAppendParameter(stringBuilder, objectArray[0], set);
            for (int i2 = 1; i2 < objectArray.length; ++i2) {
                stringBuilder.append(", ");
                MessageFormatter.deeplyAppendParameter(stringBuilder, objectArray[i2], set);
            }
            set.remove(objectArray);
            return;
        }
        stringBuilder.append("...");
    }

    private static void booleanArrayAppend(StringBuilder stringBuilder, boolean[] blArray) {
        if (blArray.length == 0) {
            return;
        }
        stringBuilder.append(blArray[0]);
        for (int i2 = 1; i2 < blArray.length; ++i2) {
            stringBuilder.append(", ");
            stringBuilder.append(blArray[i2]);
        }
    }

    private static void byteArrayAppend(StringBuilder stringBuilder, byte[] byArray) {
        if (byArray.length == 0) {
            return;
        }
        stringBuilder.append(byArray[0]);
        for (int i2 = 1; i2 < byArray.length; ++i2) {
            stringBuilder.append(", ");
            stringBuilder.append(byArray[i2]);
        }
    }

    private static void charArrayAppend(StringBuilder stringBuilder, char[] cArray) {
        if (cArray.length == 0) {
            return;
        }
        stringBuilder.append(cArray[0]);
        for (int i2 = 1; i2 < cArray.length; ++i2) {
            stringBuilder.append(", ");
            stringBuilder.append(cArray[i2]);
        }
    }

    private static void shortArrayAppend(StringBuilder stringBuilder, short[] sArray) {
        if (sArray.length == 0) {
            return;
        }
        stringBuilder.append(sArray[0]);
        for (int i2 = 1; i2 < sArray.length; ++i2) {
            stringBuilder.append(", ");
            stringBuilder.append(sArray[i2]);
        }
    }

    private static void intArrayAppend(StringBuilder stringBuilder, int[] nArray) {
        if (nArray.length == 0) {
            return;
        }
        stringBuilder.append(nArray[0]);
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            stringBuilder.append(", ");
            stringBuilder.append(nArray[i2]);
        }
    }

    private static void longArrayAppend(StringBuilder stringBuilder, long[] lArray) {
        if (lArray.length == 0) {
            return;
        }
        stringBuilder.append(lArray[0]);
        for (int i2 = 1; i2 < lArray.length; ++i2) {
            stringBuilder.append(", ");
            stringBuilder.append(lArray[i2]);
        }
    }

    private static void floatArrayAppend(StringBuilder stringBuilder, float[] fArray) {
        if (fArray.length == 0) {
            return;
        }
        stringBuilder.append(fArray[0]);
        for (int i2 = 1; i2 < fArray.length; ++i2) {
            stringBuilder.append(", ");
            stringBuilder.append(fArray[i2]);
        }
    }

    private static void doubleArrayAppend(StringBuilder stringBuilder, double[] dArray) {
        if (dArray.length == 0) {
            return;
        }
        stringBuilder.append(dArray[0]);
        for (int i2 = 1; i2 < dArray.length; ++i2) {
            stringBuilder.append(", ");
            stringBuilder.append(dArray[i2]);
        }
    }
}

