/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.util.internal.logging;

import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.JdkLoggerFactory;
import com.appoptics.ext.io.netty.util.internal.logging.Log4J2LoggerFactory;
import com.appoptics.ext.io.netty.util.internal.logging.Log4JLoggerFactory;
import com.appoptics.ext.io.netty.util.internal.logging.Slf4JLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InternalLoggerFactory {
    private static volatile InternalLoggerFactory defaultFactory;

    private static InternalLoggerFactory newDefaultFactory(String string) {
        InternalLoggerFactory internalLoggerFactory;
        try {
            internalLoggerFactory = new Slf4JLoggerFactory(true);
            ((InternalLoggerFactory)internalLoggerFactory).newInstance(string).debug("Using SLF4J as the default logging framework");
        }
        catch (Throwable throwable) {
            try {
                internalLoggerFactory = Log4J2LoggerFactory.INSTANCE;
                ((InternalLoggerFactory)internalLoggerFactory).newInstance(string).debug("Using Log4J2 as the default logging framework");
            }
            catch (Throwable throwable2) {
                try {
                    internalLoggerFactory = Log4JLoggerFactory.INSTANCE;
                    ((InternalLoggerFactory)internalLoggerFactory).newInstance(string).debug("Using Log4J as the default logging framework");
                }
                catch (Throwable throwable3) {
                    internalLoggerFactory = JdkLoggerFactory.INSTANCE;
                    ((InternalLoggerFactory)internalLoggerFactory).newInstance(string).debug("Using java.util.logging as the default logging framework");
                }
            }
        }
        return internalLoggerFactory;
    }

    public static InternalLoggerFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = InternalLoggerFactory.newDefaultFactory(InternalLoggerFactory.class.getName());
        }
        return defaultFactory;
    }

    public static InternalLogger getInstance(Class<?> clazz) {
        return InternalLoggerFactory.getInstance(clazz.getName());
    }

    public static InternalLogger getInstance(String string) {
        return InternalLoggerFactory.getDefaultFactory().newInstance(string);
    }

    protected abstract InternalLogger newInstance(String var1);
}

